/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.search;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import org.jphototagger.api.windows.MainWindowManager;
import org.jphototagger.api.windows.WaitDisplayer;
import org.jphototagger.domain.metadata.search.ParamStatement;
import org.jphototagger.domain.metadata.search.SavedSearch;
import org.jphototagger.domain.repository.FindRepository;
import org.jphototagger.domain.thumbnails.OriginOfDisplayedThumbnails;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.util.TreeUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.search.AdvancedSearchDialog;
import org.jphototagger.program.module.search.AdvancedSearchPanel;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class AdvancedSearchController
implements ActionListener {
    private final FindRepository repo = Lookup.getDefault().lookup(FindRepository.class);

    public AdvancedSearchController() {
        this.listen();
    }

    private void listen() {
        this.getSearchButton().addActionListener(this);
    }

    private AdvancedSearchPanel getSearchPanel() {
        return AdvancedSearchDialog.INSTANCE.getAdvancedSearchPanel();
    }

    private JButton getSearchButton() {
        return this.getSearchPanel().getButtonSearch();
    }

    private void applySavedSearch(final SavedSearch savedSearch) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                assert (savedSearch.isValid()) : savedSearch;
                WaitDisplayer waitDisplayer = Lookup.getDefault().lookup(WaitDisplayer.class);
                waitDisplayer.show();
                ParamStatement stmt = savedSearch.createParamStatement();
                TreeUtil.clearSelection(GUI.getAppPanel().getSelectionTrees());
                List<File> imageFiles = AdvancedSearchController.this.repo.findImageFiles(stmt);
                this.setTitle(savedSearch.getName());
                GUI.getThumbnailsPanel().setFiles(imageFiles, OriginOfDisplayedThumbnails.FILES_FOUND_BY_SAVED_SEARCH);
                waitDisplayer.hide();
            }

            private void setTitle(String name) {
                String titleAdvancedSearch = Bundle.getString(AdvancedSearchController.class, "AdvancedSearchController.AppFrame.Title.AdvancedSearch", new Object[0]);
                String titleSavedSearch = Bundle.getString(AdvancedSearchController.class, "AdvancedSearchController.AppFrame.Title.AdvancedSearch.Saved", name);
                String title = name == null ? titleAdvancedSearch : titleSavedSearch;
                MainWindowManager mainWindowManager = Lookup.getDefault().lookup(MainWindowManager.class);
                mainWindowManager.setMainWindowTitle(title);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        SavedSearch savedSearch = this.getSearchPanel().createSavedSearch();
        if (savedSearch.isValid()) {
            this.applySavedSearch(savedSearch);
        }
    }
}

