/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.rating;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import org.jphototagger.domain.metadata.SelectedFilesMetaDataEditor;
import org.jphototagger.program.module.thumbnails.ThumbnailsPopupMenu;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class SetRatingController
implements ActionListener,
KeyListener {
    private static final Map<Integer, Long> RATING_OF_KEY_CODE = new HashMap<Integer, Long>();

    public SetRatingController() {
        this.listen();
    }

    private void listen() {
        ThumbnailsPopupMenu popup = ThumbnailsPopupMenu.INSTANCE;
        GUI.getThumbnailsPanel().addKeyListener(this);
        popup.getItemRating0().addActionListener(this);
        popup.getItemRating1().addActionListener(this);
        popup.getItemRating2().addActionListener(this);
        popup.getItemRating3().addActionListener(this);
        popup.getItemRating4().addActionListener(this);
        popup.getItemRating5().addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.setRating(ThumbnailsPopupMenu.INSTANCE.getRatingOfItem((JMenuItem)evt.getSource()));
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (this.isRatingKey(evt)) {
            this.setRating(RATING_OF_KEY_CODE.get(evt.getKeyCode()));
        }
    }

    public void setRating(Long rating) {
        SelectedFilesMetaDataEditor editor = Lookup.getDefault().lookup(SelectedFilesMetaDataEditor.class);
        if (editor.isEditable()) {
            editor.setRating(rating);
        }
    }

    private boolean isRatingKey(KeyEvent evt) {
        return RATING_OF_KEY_CODE.containsKey(evt.getKeyCode());
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    static {
        RATING_OF_KEY_CODE.put(48, 0L);
        RATING_OF_KEY_CODE.put(49, 1L);
        RATING_OF_KEY_CODE.put(50, 2L);
        RATING_OF_KEY_CODE.put(51, 3L);
        RATING_OF_KEY_CODE.put(52, 4L);
        RATING_OF_KEY_CODE.put(53, 5L);
    }
}

