/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.programs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressHandle;
import org.jphototagger.api.progress.ProgressHandleFactory;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.repository.SaveOrUpdate;
import org.jphototagger.domain.repository.SaveToOrUpdateFilesInRepository;
import org.jphototagger.lib.runtime.External;
import org.jphototagger.lib.runtime.ProcessResult;
import org.jphototagger.lib.runtime.RuntimeUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.programs.ProgramInputParametersDialog;
import org.openide.util.Lookup;

public final class StartPrograms {
    private static final long MAX_MILLISECONDS_UNTIL_TERMINATE = 300000L;
    private static final Logger LOGGER = Logger.getLogger(StartPrograms.class.getName());
    private final Queue<Execute> queue = new ConcurrentLinkedQueue<Execute>();
    private ProgressHandle progressHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProgram(Program program, List<File> imageFiles, boolean waitForTermination) {
        if (this.checkFilecount(imageFiles)) {
            Execute execute = new Execute(program, imageFiles, waitForTermination);
            StartPrograms startPrograms = this;
            synchronized (startPrograms) {
                if (this.queue.isEmpty()) {
                    execute.start();
                } else {
                    this.queue.add(execute);
                }
            }
        }
    }

    private boolean checkFilecount(List<File> imageFiles) {
        if (imageFiles.size() <= 0) {
            String message = Bundle.getString(StartPrograms.class, "StartPrograms.Error.Selection", new Object[0]);
            MessageDisplayer.error(null, message);
            return false;
        }
        return true;
    }

    private class Execute
    extends Thread {
        private final ProgramInputParametersDialog dlg;
        private final List<File> imageFiles;
        private final Program program;
        private final boolean waitForTermination;

        Execute(Program program, List<File> imageFiles, boolean waitForTermination) {
            super("JPhotoTagger: Executing program " + program.getAlias());
            this.dlg = new ProgramInputParametersDialog();
            if (program == null) {
                throw new NullPointerException("program == null");
            }
            if (imageFiles == null) {
                throw new NullPointerException("imageFiles == null");
            }
            this.imageFiles = new ArrayList<File>(imageFiles);
            this.program = program;
            this.waitForTermination = waitForTermination;
        }

        @Override
        public void run() {
            this.progressStarted();
            if (this.program.isUsePattern()) {
                this.processPattern();
            } else if (this.program.isSingleFileProcessing()) {
                this.processSingle();
            } else {
                this.processAll();
            }
            StartPrograms.this.progressHandle.progressEnded();
            this.updateRepository();
            this.nextExecutor();
        }

        private void logCommand(String command) {
            LOGGER.log(Level.INFO, "Execute command: ''{0}''", command);
        }

        private void processPattern() {
            int count = 0;
            for (File file : this.imageFiles) {
                String command = this.getProcessPatternCommand(file);
                this.logCommand(command);
                if (this.waitForTermination) {
                    boolean terminatedWithErrors;
                    ProcessResult processResult = External.executeWaitForTermination(command, 300000L);
                    boolean bl = terminatedWithErrors = processResult == null || processResult.getExitValue() != 0;
                    if (terminatedWithErrors) {
                        this.logError(command, processResult);
                    }
                } else {
                    External.execute(command);
                }
                this.progressPerformed(++count);
            }
        }

        private void logError(String command, ProcessResult processResult) {
            LOGGER.log(Level.WARNING, "Error executing command  ''{0}'': {1}!", new Object[]{command, processResult == null ? "?" : new String(processResult.getStdErrBytes())});
        }

        private String getProcessPatternCommand(File file) {
            return this.getCommandPrefix() + this.getProgramPath() + RuntimeUtil.getDefaultCommandLineSeparator() + RuntimeUtil.substitudePattern(file, this.getPattern());
        }

        private String getPattern() {
            String pattern = this.program.getPattern();
            return this.program.isUsePattern() && pattern != null && !pattern.isEmpty() ? this.program.getPattern() : "%s";
        }

        private void processAll() {
            String command = this.getProcessAllCommand();
            this.logCommand(command);
            if (this.waitForTermination) {
                boolean terminatedWithErrors;
                ProcessResult processResult = External.executeWaitForTermination(command, 300000L);
                boolean bl = terminatedWithErrors = processResult == null || processResult.getExitValue() != 0;
                if (terminatedWithErrors) {
                    this.logError(command, processResult);
                }
            } else {
                External.execute(command);
            }
            this.progressPerformed(this.imageFiles.size());
        }

        private String getProcessAllCommand() {
            String commandPrefix = this.getCommandPrefix();
            String programPath = this.getProgramPath();
            String separator = RuntimeUtil.getDefaultCommandLineSeparator();
            String additionalParameters = this.getAdditionalParameters(Bundle.getString(Execute.class, "StartPrograms.GetInput.Title", new Object[0]), 2);
            String commandlineParameters = this.program.getCommandlineParameters(this.imageFiles, additionalParameters, this.dlg.isParametersBeforeFilename());
            return commandPrefix + programPath + separator + commandlineParameters;
        }

        private void processSingle() {
            int count = 0;
            for (File file : this.imageFiles) {
                String command = this.getProcessSingleCommand(file, count);
                this.logCommand(command);
                if (this.waitForTermination) {
                    boolean terminatedWithErrors;
                    ProcessResult processResult = External.executeWaitForTermination(command, 300000L);
                    boolean bl = terminatedWithErrors = processResult == null || processResult.getExitValue() != 0;
                    if (terminatedWithErrors) {
                        this.logError(command, processResult);
                    }
                } else {
                    External.execute(command);
                }
                this.progressPerformed(++count);
            }
        }

        private String getProcessSingleCommand(File file, int count) {
            String commandPrefix = this.getCommandPrefix();
            String programPath = this.getProgramPath();
            String separator = RuntimeUtil.getDefaultCommandLineSeparator();
            List<File> files = Arrays.asList(file);
            String additionalParameters = this.getAdditionalParameters(file.getAbsolutePath(), count + 1);
            String commandlineParameters = this.program.getCommandlineParameters(files, additionalParameters, this.dlg.isParametersBeforeFilename());
            return commandPrefix + programPath + separator + commandlineParameters;
        }

        private String getProgramPath() {
            return RuntimeUtil.quoteForCommandLine(this.program.getFile());
        }

        private String getCommandPrefix() {
            return this.isMacApplication() ? "open -a " : "";
        }

        private boolean isMacApplication() {
            String filename = this.program.getFile().getName();
            String filenameLowerCase = filename.toLowerCase();
            return filenameLowerCase.endsWith(".app");
        }

        private String getAdditionalParameters(String filename, int count) {
            if (this.program.isUsePattern()) {
                return "";
            }
            if (!this.program.isInputBeforeExecute()) {
                return "";
            }
            if (!this.program.isInputBeforeExecutePerFile() && count > 1) {
                return this.dlg.getParameters();
            }
            this.dlg.setProgram(this.program.getAlias());
            this.dlg.setFilename(filename);
            this.dlg.setVisible(true);
            if (this.dlg.isAccepted()) {
                return this.dlg.getParameters();
            }
            return "";
        }

        private synchronized void nextExecutor() {
            if (!StartPrograms.this.queue.isEmpty()) {
                ((Execute)StartPrograms.this.queue.poll()).start();
            }
        }

        private void progressStarted() {
            ProgressEvent evt = new ProgressEvent.Builder().source(this).minimum(0).maximum(this.imageFiles.size()).value(0).build();
            StartPrograms.this.progressHandle = Lookup.getDefault().lookup(ProgressHandleFactory.class).createProgressHandle();
            StartPrograms.this.progressHandle.progressStarted(evt);
        }

        private void progressPerformed(int value) {
            ProgressEvent evt = new ProgressEvent.Builder().source(this).minimum(0).maximum(this.imageFiles.size()).value(value).build();
            StartPrograms.this.progressHandle.progressPerformed(evt);
        }

        private void updateRepository() {
            if (this.program.isChangeFile()) {
                SaveToOrUpdateFilesInRepository updater = Lookup.getDefault().lookup(SaveToOrUpdateFilesInRepository.class).createInstance(this.imageFiles, SaveOrUpdate.OUT_OF_DATE);
                updater.saveOrUpdateWaitForTermination();
            }
        }
    }
}

