/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.programs;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.programs.ProgramType;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.actions.ActionsListCellRenderer;
import org.jphototagger.program.module.programs.ProgramsListCellRenderer;
import org.jphototagger.program.module.programs.ProgramsListModel;
import org.jphototagger.program.resource.GUI;

public class SelectProgramDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final ProgramsListModel model;
    private final ProgramType type;
    private boolean accepted;
    private JButton buttonSelect;
    private JXList listPrograms;
    private JScrollPane scrollPanePrograms;

    public SelectProgramDialog(ProgramType type) {
        super((Frame)GUI.getAppFrame(), true);
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        this.type = type;
        this.model = new ProgramsListModel(type);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        MnemonicUtil.setMnemonics(this);
        this.setTitle();
    }

    private void setTitle() {
        String actionsTitle = Bundle.getString(SelectProgramDialog.class, "SelectProgramDialog.Title.Actions", new Object[0]);
        String programsTitle = Bundle.getString(SelectProgramDialog.class, "SelectProgramDialog.Title.Programs", new Object[0]);
        this.setTitle(this.type.equals((Object)ProgramType.ACTION) ? actionsTitle : programsTitle);
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public Program getSelectedProgram() {
        Program program = null;
        int selectedIndex = this.listPrograms.getSelectedIndex();
        if (selectedIndex >= 0) {
            int modelIndex = this.listPrograms.convertIndexToModel(selectedIndex);
            program = (Program)this.model.get(modelIndex);
        }
        return program;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.accepted = false;
        }
        super.setVisible(visible);
    }

    private void handleMousClicked(MouseEvent evt) {
        boolean isSelected;
        int selectedIndex = this.listPrograms.getSelectedIndex();
        boolean bl = isSelected = selectedIndex >= 0;
        if (evt.getClickCount() >= 2 && isSelected) {
            this.handleButtonSelectAction();
        }
        this.buttonSelect.setEnabled(isSelected);
    }

    private void handleButtonSelectAction() {
        this.accepted = true;
        this.setVisible(false);
    }

    private void initComponents() {
        this.scrollPanePrograms = new JScrollPane();
        this.listPrograms = new JXList();
        this.buttonSelect = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SelectProgramDialog.this.formWindowClosing(evt);
            }
        });
        this.scrollPanePrograms.setFocusable(false);
        this.scrollPanePrograms.setName("scrollPanePrograms");
        this.listPrograms.setModel((ListModel)this.model);
        this.listPrograms.setSelectionMode(0);
        this.listPrograms.setCellRenderer((ListCellRenderer)(this.type.equals((Object)ProgramType.ACTION) ? new ActionsListCellRenderer() : new ProgramsListCellRenderer()));
        this.listPrograms.setName("listPrograms");
        this.listPrograms.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SelectProgramDialog.this.listProgramsMouseClicked(evt);
            }
        });
        this.scrollPanePrograms.setViewportView(this.listPrograms);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/programs/Bundle");
        this.buttonSelect.setText(bundle.getString("SelectProgramDialog.buttonSelect.text"));
        this.buttonSelect.setEnabled(false);
        this.buttonSelect.setName("buttonSelect");
        this.buttonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectProgramDialog.this.buttonSelectActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scrollPanePrograms, -1, 313, Short.MAX_VALUE).addGap(12, 12, 12)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonSelect).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPanePrograms, -1, 141, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelect).addContainerGap()));
        this.pack();
    }

    private void listProgramsMouseClicked(MouseEvent evt) {
        this.handleMousClicked(evt);
    }

    private void buttonSelectActionPerformed(ActionEvent evt) {
        this.handleButtonSelectAction();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectProgramDialog dialog = new SelectProgramDialog(ProgramType.PROGRAM);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

