/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.programs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.repository.ProgramsRepository;
import org.jphototagger.lib.swing.util.ListUtil;
import org.jphototagger.program.module.programs.ProgramPropertiesDialog;
import org.jphototagger.program.module.programs.StartPrograms;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class ProgramsUtil {
    public static void moveProgramUp(JXList listPrograms) {
        if (listPrograms == null) {
            throw new NullPointerException("listPrograms == null");
        }
        int selectedIndex = listPrograms.getSelectedIndex();
        int modelIndex = listPrograms.convertIndexToModel(selectedIndex);
        int upIndex = modelIndex - 1;
        boolean programIsSelected = selectedIndex >= 0;
        DefaultListModel model = (DefaultListModel)listPrograms.getModel();
        if (programIsSelected && upIndex >= 0) {
            ListUtil.swapModelElements(model, upIndex, modelIndex);
            ProgramsUtil.reorderPrograms(model);
            listPrograms.setSelectedIndex(upIndex);
        }
    }

    public static void moveProgramDown(JXList listPrograms) {
        boolean programIsSelected;
        if (listPrograms == null) {
            throw new NullPointerException("listPrograms == null");
        }
        DefaultListModel model = (DefaultListModel)listPrograms.getModel();
        int size = model.getSize();
        int selectedIndex = listPrograms.getSelectedIndex();
        int modelIndex = listPrograms.convertIndexToModel(selectedIndex);
        int downIndex = modelIndex + 1;
        boolean bl = programIsSelected = selectedIndex >= 0;
        if (programIsSelected && downIndex < size) {
            ListUtil.swapModelElements(model, downIndex, modelIndex);
            ProgramsUtil.reorderPrograms(model);
            listPrograms.setSelectedIndex(downIndex);
        }
    }

    public static void reorderPrograms(DefaultListModel<?> model) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        int size = model.getSize();
        ArrayList<Program> programs = new ArrayList<Program>(size);
        for (int sequenceNo = 0; sequenceNo < size; ++sequenceNo) {
            Program program = (Program)model.get(sequenceNo);
            program.setSequenceNumber(sequenceNo);
            programs.add(program);
        }
        ProgramsRepository repo = Lookup.getDefault().lookup(ProgramsRepository.class);
        for (Program program : programs) {
            repo.updateProgram(program);
        }
    }

    public static Program addProgram() {
        ProgramPropertiesDialog dlg = new ProgramPropertiesDialog(false);
        dlg.setVisible(true);
        if (dlg.isAccepted()) {
            Program program = dlg.getProgram();
            ProgramsRepository repo = Lookup.getDefault().lookup(ProgramsRepository.class);
            repo.saveProgram(program);
            return program;
        }
        return null;
    }

    public static void openSelectedFilesWidth(Program program, boolean waitForTermination) {
        if (program != null) {
            StartPrograms startPrograms = new StartPrograms();
            List<File> selectedImageFiles = GUI.getSelectedImageFiles();
            startPrograms.startProgram(program, selectedImageFiles, waitForTermination);
        }
    }

    private ProgramsUtil() {
    }

    public static class ReorderListener
    implements ListDataListener {
        private volatile boolean listenToModel = true;
        private final DefaultListModel<?> model;

        public ReorderListener(DefaultListModel<?> model) {
            if (model == null) {
                throw new NullPointerException("model == null");
            }
            this.model = model;
            model.addListDataListener(this);
        }

        public void setListenToModel(boolean listenToModel) {
            this.listenToModel = listenToModel;
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.reorder();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.reorder();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.reorder();
        }

        private void reorder() {
            if (this.listenToModel) {
                this.listenToModel = false;
                ProgramsUtil.reorderPrograms(this.model);
                this.listenToModel = true;
            }
        }
    }
}

