/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.programs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXList;
import org.jphototagger.api.storage.Persistence;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.programs.ProgramType;
import org.jphototagger.domain.repository.ProgramsRepository;
import org.jphototagger.lib.help.HelpPageProvider;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.datatransfer.ReorderListItemsTransferHandler;
import org.jphototagger.program.module.programs.EditDefaultProgramsDialog;
import org.jphototagger.program.module.programs.ProgramPropertiesDialog;
import org.jphototagger.program.module.programs.ProgramsListCellRenderer;
import org.jphototagger.program.module.programs.ProgramsListModel;
import org.jphototagger.program.module.programs.ProgramsUtil;
import org.openide.util.Lookup;

public final class ProgramsSettingsPanel
extends JPanel
implements Persistence,
HelpPageProvider {
    private static final long serialVersionUID = 1L;
    private final ProgramsListModel model = new ProgramsListModel(ProgramType.PROGRAM);
    private final ProgramsUtil.ReorderListener reorderListener = new ProgramsUtil.ReorderListener(this.model);
    private final ProgramsRepository repo = Lookup.getDefault().lookup(ProgramsRepository.class);
    private final ListDataListener buttonDefaultProgramsEnabler = new ListDataListener(){

        @Override
        public void intervalAdded(ListDataEvent e) {
            ProgramsSettingsPanel.this.setDefaultProgramsButtonEnabled();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            ProgramsSettingsPanel.this.setDefaultProgramsButtonEnabled();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ProgramsSettingsPanel.this.setDefaultProgramsButtonEnabled();
        }
    };
    private JButton buttonAddProgram;
    private JButton buttonDefaultPrograms;
    private JButton buttonEditProgram;
    private JButton buttonMoveProgramDown;
    private JButton buttonMoveProgramUp;
    private JButton buttonRemoveProgram;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JLabel labelInfoDefaultProgramFirstInList;
    private JLabel labelPrograms;
    private JXList listPrograms;
    private JMenuItem menuItemAddProgram;
    private JMenuItem menuItemEditProgram;
    private JMenuItem menuItemMoveProgramDown;
    private JMenuItem menuItemMoveProgramUp;
    private JMenuItem menuItemRemoveProgram;
    private JPanel panelProgramButtons;
    private JPopupMenu popupMenu;
    private JScrollPane scrollPanePrograms;

    public ProgramsSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        MnemonicUtil.setMnemonics(this);
        this.setAccelerators();
        this.setEnabled();
        this.setDefaultProgramsButtonEnabled();
        this.model.addListDataListener(this.buttonDefaultProgramsEnabler);
    }

    private void setAccelerators() {
        this.menuItemAddProgram.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(78));
        this.menuItemMoveProgramUp.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(38));
        this.menuItemMoveProgramDown.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(40));
    }

    @Override
    public void restore() {
    }

    @Override
    public void persist() {
    }

    private void addProgram() {
        ProgramPropertiesDialog dlg = new ProgramPropertiesDialog(false);
        dlg.setVisible(true);
        if (dlg.isAccepted()) {
            this.repo.saveProgram(dlg.getProgram());
        }
    }

    private void editProgram() {
        if (this.listPrograms.getSelectedIndex() >= 0) {
            ProgramPropertiesDialog dlg = new ProgramPropertiesDialog(false);
            dlg.setProgram((Program)this.listPrograms.getSelectedValue());
            dlg.setVisible(true);
            if (dlg.isAccepted()) {
                this.repo.updateProgram(dlg.getProgram());
            }
        }
    }

    private void removeProgram() {
        int selectedIndex = this.listPrograms.getSelectedIndex();
        int modelIndex = this.listPrograms.convertIndexToModel(selectedIndex);
        if (selectedIndex >= 0 && this.askRemove(this.model.getElementAt(modelIndex).toString())) {
            this.repo.deleteProgram((Program)this.model.get(modelIndex));
            this.setEnabled();
        }
    }

    private boolean askRemove(String otherImageOpenApp) {
        String message = Bundle.getString(ProgramsSettingsPanel.class, "ProgramsSettingsPanel.Confirm.RemoveImageOpenApp", otherImageOpenApp);
        return MessageDisplayer.confirmYesNo(this, message);
    }

    private void setEnabled() {
        boolean programSelected = this.isProgramSelected();
        int selectedIndex = this.listPrograms.getSelectedIndex();
        int size = this.listPrograms.getModel().getSize();
        boolean canMoveDown = programSelected && selectedIndex < size - 1;
        boolean canMoveUp = programSelected && selectedIndex > 0;
        this.buttonEditProgram.setEnabled(programSelected);
        this.menuItemEditProgram.setEnabled(programSelected);
        this.buttonRemoveProgram.setEnabled(programSelected);
        this.menuItemRemoveProgram.setEnabled(programSelected);
        this.buttonMoveProgramDown.setEnabled(canMoveDown);
        this.menuItemMoveProgramDown.setEnabled(canMoveDown);
        this.buttonMoveProgramUp.setEnabled(canMoveUp);
        this.menuItemMoveProgramUp.setEnabled(canMoveUp);
    }

    private void handleListProgramsKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 127) {
            this.removeProgram();
        } else if (keyCode == 10) {
            this.editProgram();
        } else if (KeyEventUtil.isMenuShortcut(evt, 78)) {
            this.addProgram();
        } else if (KeyEventUtil.isMenuShortcut(evt, 40)) {
            this.moveProgramDown();
        } else if (KeyEventUtil.isMenuShortcut(evt, 38)) {
            this.moveProgramUp();
        }
    }

    private boolean isProgramSelected() {
        return this.listPrograms.getSelectedIndex() >= 0;
    }

    private void handleListOtherProgramsMouseClicked(MouseEvent evt) {
        if (MouseEventUtil.isDoubleClick(evt)) {
            this.editProgram();
        }
    }

    private void moveProgramDown() {
        this.reorderListener.setListenToModel(false);
        ProgramsUtil.moveProgramDown(this.listPrograms);
        this.reorderListener.setListenToModel(true);
    }

    private void moveProgramUp() {
        this.reorderListener.setListenToModel(false);
        ProgramsUtil.moveProgramUp(this.listPrograms);
        this.reorderListener.setListenToModel(true);
    }

    @Override
    public String getHelpPageUrl() {
        return Bundle.getString(ProgramsSettingsPanel.class, "ProgramsSettingsPanel.HelpPage", new Object[0]);
    }

    private void editDefaultPrograms() {
        EditDefaultProgramsDialog dialog = new EditDefaultProgramsDialog();
        dialog.setVisible(true);
        ComponentUtil.parentWindowToFront(this);
    }

    private void setDefaultProgramsButtonEnabled() {
        int programCount = this.model.getSize();
        this.buttonDefaultPrograms.setEnabled(programCount > 0);
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.menuItemAddProgram = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.menuItemEditProgram = new JMenuItem();
        this.menuItemRemoveProgram = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.menuItemMoveProgramUp = new JMenuItem();
        this.menuItemMoveProgramDown = new JMenuItem();
        this.labelPrograms = new JLabel();
        this.buttonDefaultPrograms = new JButton();
        this.scrollPanePrograms = new JScrollPane();
        this.listPrograms = new JXList();
        this.labelInfoDefaultProgramFirstInList = new JLabel();
        this.panelProgramButtons = new JPanel();
        this.buttonMoveProgramUp = new JButton();
        this.buttonMoveProgramDown = new JButton();
        this.buttonRemoveProgram = new JButton();
        this.buttonAddProgram = new JButton();
        this.buttonEditProgram = new JButton();
        this.menuItemAddProgram.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_new.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/programs/Bundle");
        this.menuItemAddProgram.setText(bundle.getString("ProgramsSettingsPanel.menuItemAddProgram.text"));
        this.menuItemAddProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramsSettingsPanel.this.menuItemAddProgramActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemAddProgram);
        this.popupMenu.add(this.jSeparator1);
        this.menuItemEditProgram.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        this.menuItemEditProgram.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_edit.png")));
        this.menuItemEditProgram.setText(bundle.getString("ProgramsSettingsPanel.menuItemEditProgram.text"));
        this.menuItemEditProgram.setEnabled(false);
        this.menuItemEditProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramsSettingsPanel.this.menuItemEditProgramActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemEditProgram);
        this.menuItemRemoveProgram.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.menuItemRemoveProgram.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_delete.png")));
        this.menuItemRemoveProgram.setText(bundle.getString("ProgramsSettingsPanel.menuItemRemoveProgram.text"));
        this.menuItemRemoveProgram.setEnabled(false);
        this.menuItemRemoveProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramsSettingsPanel.this.menuItemRemoveProgramActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemRemoveProgram);
        this.popupMenu.add(this.jSeparator2);
        this.menuItemMoveProgramUp.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_arrow_up.png")));
        this.menuItemMoveProgramUp.setText(bundle.getString("ProgramsSettingsPanel.menuItemMoveProgramUp.text"));
        this.menuItemMoveProgramUp.setEnabled(false);
        this.menuItemMoveProgramUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramsSettingsPanel.this.menuItemMoveProgramUpActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemMoveProgramUp);
        this.menuItemMoveProgramDown.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_arrow_down.png")));
        this.menuItemMoveProgramDown.setText(bundle.getString("ProgramsSettingsPanel.menuItemMoveProgramDown.text"));
        this.menuItemMoveProgramDown.setEnabled(false);
        this.menuItemMoveProgramDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramsSettingsPanel.this.menuItemMoveProgramDownActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemMoveProgramDown);
        this.setLayout(new GridBagLayout());
        this.labelPrograms.setLabelFor(this.listPrograms);
        this.labelPrograms.setText(bundle.getString("ProgramsSettingsPanel.labelPrograms.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.labelPrograms, gridBagConstraints);
        this.buttonDefaultPrograms.setText(bundle.getString("ProgramsSettingsPanel.buttonDefaultPrograms.text"));
        this.buttonDefaultPrograms.setEnabled(false);
        this.buttonDefaultPrograms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramsSettingsPanel.this.buttonDefaultProgramsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.buttonDefaultPrograms, gridBagConstraints);
        this.listPrograms.setModel((ListModel)this.model);
        this.listPrograms.setSelectionMode(0);
        this.listPrograms.setCellRenderer((ListCellRenderer)new ProgramsListCellRenderer());
        this.listPrograms.setComponentPopupMenu(this.popupMenu);
        this.listPrograms.setDragEnabled(true);
        this.listPrograms.setDropMode(DropMode.INSERT);
        this.listPrograms.setTransferHandler(new ReorderListItemsTransferHandler(this.listPrograms));
        this.listPrograms.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProgramsSettingsPanel.this.listProgramsMouseClicked(evt);
            }
        });
        this.listPrograms.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ProgramsSettingsPanel.this.listProgramsValueChanged(evt);
            }
        });
        this.listPrograms.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ProgramsSettingsPanel.this.listProgramsKeyPressed(evt);
            }
        });
        this.scrollPanePrograms.setViewportView(this.listPrograms);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.scrollPanePrograms, gridBagConstraints);
        this.labelInfoDefaultProgramFirstInList.setText(bundle.getString("ProgramsSettingsPanel.labelInfoDefaultProgramFirstInList.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.labelInfoDefaultProgramFirstInList, gridBagConstraints);
        this.panelProgramButtons.setLayout(new GridBagLayout());
        this.buttonMoveProgramUp.setText(bundle.getString("ProgramsSettingsPanel.buttonMoveProgramUp.text"));
        this.buttonMoveProgramUp.setEnabled(false);
        this.buttonMoveProgramUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramsSettingsPanel.this.buttonMoveProgramUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelProgramButtons.add((Component)this.buttonMoveProgramUp, gridBagConstraints);
        this.buttonMoveProgramDown.setText(bundle.getString("ProgramsSettingsPanel.buttonMoveProgramDown.text"));
        this.buttonMoveProgramDown.setEnabled(false);
        this.buttonMoveProgramDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramsSettingsPanel.this.buttonMoveProgramDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelProgramButtons.add((Component)this.buttonMoveProgramDown, gridBagConstraints);
        this.buttonRemoveProgram.setText(bundle.getString("ProgramsSettingsPanel.buttonRemoveProgram.text"));
        this.buttonRemoveProgram.setToolTipText(bundle.getString("ProgramsSettingsPanel.buttonRemoveProgram.toolTipText"));
        this.buttonRemoveProgram.setEnabled(false);
        this.buttonRemoveProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramsSettingsPanel.this.buttonRemoveProgramActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelProgramButtons.add((Component)this.buttonRemoveProgram, gridBagConstraints);
        this.buttonAddProgram.setText(bundle.getString("ProgramsSettingsPanel.buttonAddProgram.text"));
        this.buttonAddProgram.setToolTipText(bundle.getString("ProgramsSettingsPanel.buttonAddProgram.toolTipText"));
        this.buttonAddProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramsSettingsPanel.this.buttonAddProgramActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelProgramButtons.add((Component)this.buttonAddProgram, gridBagConstraints);
        this.buttonEditProgram.setText(bundle.getString("ProgramsSettingsPanel.buttonEditProgram.text"));
        this.buttonEditProgram.setToolTipText(bundle.getString("ProgramsSettingsPanel.buttonEditProgram.toolTipText"));
        this.buttonEditProgram.setEnabled(false);
        this.buttonEditProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramsSettingsPanel.this.buttonEditProgramActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelProgramButtons.add((Component)this.buttonEditProgram, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.panelProgramButtons, gridBagConstraints);
    }

    private void listProgramsValueChanged(ListSelectionEvent evt) {
        this.setEnabled();
    }

    private void buttonRemoveProgramActionPerformed(ActionEvent evt) {
        this.removeProgram();
    }

    private void buttonAddProgramActionPerformed(ActionEvent evt) {
        this.addProgram();
    }

    private void buttonEditProgramActionPerformed(ActionEvent evt) {
        this.editProgram();
    }

    private void listProgramsMouseClicked(MouseEvent evt) {
        this.handleListOtherProgramsMouseClicked(evt);
    }

    private void buttonMoveProgramDownActionPerformed(ActionEvent evt) {
        this.moveProgramDown();
    }

    private void buttonMoveProgramUpActionPerformed(ActionEvent evt) {
        this.moveProgramUp();
    }

    private void menuItemAddProgramActionPerformed(ActionEvent evt) {
        this.addProgram();
    }

    private void menuItemEditProgramActionPerformed(ActionEvent evt) {
        this.editProgram();
    }

    private void menuItemRemoveProgramActionPerformed(ActionEvent evt) {
        this.removeProgram();
    }

    private void menuItemMoveProgramUpActionPerformed(ActionEvent evt) {
        this.moveProgramUp();
    }

    private void menuItemMoveProgramDownActionPerformed(ActionEvent evt) {
        this.moveProgramDown();
    }

    private void listProgramsKeyPressed(KeyEvent evt) {
        this.handleListProgramsKeyPressed(evt);
    }

    private void buttonDefaultProgramsActionPerformed(ActionEvent evt) {
        this.editDefaultPrograms();
    }
}

