/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.programs;

import java.util.List;
import javax.swing.DefaultListModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.programs.ProgramType;
import org.jphototagger.domain.repository.ProgramsRepository;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.domain.repository.event.programs.ProgramDeletedEvent;
import org.jphototagger.domain.repository.event.programs.ProgramInsertedEvent;
import org.jphototagger.domain.repository.event.programs.ProgramUpdatedEvent;
import org.openide.util.Lookup;

public final class ProgramsListModel
extends DefaultListModel<Object> {
    private static final long serialVersionUID = 1L;
    private boolean listen = true;
    private ProgramType type;
    private final ProgramsRepository programsRepo = Lookup.getDefault().lookup(ProgramsRepository.class);

    public ProgramsListModel(ProgramType type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        this.type = type;
        this.addElements();
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    private void addElements() {
        Repository repo = Lookup.getDefault().lookup(Repository.class);
        if (repo == null || !repo.isInit()) {
            return;
        }
        List<Program> programs = this.programsRepo.findAllPrograms(this.type);
        for (Program program : programs) {
            this.addElement(program);
        }
    }

    private boolean isAppropriateProgramType(Program program) {
        return program.isAction() && this.type.equals((Object)ProgramType.ACTION) || !program.isAction() && this.type.equals((Object)ProgramType.PROGRAM);
    }

    private void updateProgram(Program program) throws IllegalArgumentException {
        this.listen = false;
        int index = this.indexOf(program);
        if (index >= 0) {
            boolean validSeqNumber;
            int sequenceNumber = program.getSequenceNumber();
            boolean bl = validSeqNumber = sequenceNumber >= 0 && sequenceNumber <= this.getSize();
            if (!validSeqNumber) {
                throw new IllegalArgumentException("Invalid sequence number. Size: " + this.getSize() + ". Sequence number: " + sequenceNumber);
            }
            if (index == sequenceNumber) {
                this.set(index, program);
            } else if (validSeqNumber) {
                this.remove(index);
                this.insertElementAt(program, sequenceNumber);
            }
        }
        this.listen = true;
    }

    @EventSubscriber(eventClass=ProgramDeletedEvent.class)
    public void programDeleted(ProgramDeletedEvent evt) {
        if (!this.listen) {
            return;
        }
        Program program = evt.getProgram();
        if (this.isAppropriateProgramType(program)) {
            this.removeElement(program);
        }
    }

    @EventSubscriber(eventClass=ProgramInsertedEvent.class)
    public void programInserted(ProgramInsertedEvent evt) {
        if (!this.listen) {
            return;
        }
        Program program = evt.getProgram();
        if (this.isAppropriateProgramType(program)) {
            this.addElement(program);
        }
    }

    @EventSubscriber(eventClass=ProgramUpdatedEvent.class)
    public void programUpdated(ProgramUpdatedEvent evt) {
        if (!this.listen) {
            return;
        }
        Program program = evt.getProgram();
        if (this.isAppropriateProgramType(program)) {
            this.updateProgram(program);
        }
    }
}

