/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.programs;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.TabOrEnterLeavingTextArea;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.LookAndFeelUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.lib.util.SystemUtil;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class ProgramPropertiesDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private transient Program program = new Program();
    private static final String KEY_LAST_DIR = "ProgramPropertiesDialog.LastDirectory";
    private static final String KEY_EXPERT_SETTINGS = "ProgramPropertiesDialog.ExpertSettings";
    private static final String BUTTON_TEXT_TOGGLE_TO_EXPERT_SETTINGS = Bundle.getString(ProgramPropertiesDialog.class, "ProgramPropertiesDialog.ButtonText.ExpertSettings", new Object[0]);
    private static final String BUTTON_TEXT_TOGGLE_TO_SIMPLE_SETTINGS = Bundle.getString(ProgramPropertiesDialog.class, "ProgramPropertiesDialog.ButtonText.SimpleSettings", new Object[0]);
    private static final Preferences PREFS = Lookup.getDefault().lookup(Preferences.class);
    private File lastDir = this.initCreateLastDir();
    private File file;
    private boolean accecpted = false;
    private final boolean action;
    private static final Color FG_COLOR_LABEL_FILE_EXISTS = Color.BLUE;
    private static final Color BG_COLOR_LABEL_FILE_EXISTS = LookAndFeelUtil.getUiColor("Label.background");
    private static final Color FG_COLOR_LABEL_FILE_NOT_EXISTS = Color.WHITE;
    private static final Color BG_COLOR_LABEL_FILE_NOT_EXISTS = Color.RED;
    private JButton buttonCancel;
    private JButton buttonChooseFile;
    private ButtonGroup buttonGroupSingleFileProcessing;
    private JButton buttonInfoUsePattern;
    private JButton buttonOk;
    private JCheckBox checkBoxChangeFile;
    private JCheckBox checkBoxInputBeforeExecute;
    private JCheckBox checkBoxInputBeforeExecutePerFile;
    private JCheckBox checkBoxUsePattern;
    private JLabel labelAlias;
    private JLabel labelErrorFileDoesNotExist;
    private JLabel labelFile;
    private JLabel labelFilePrompt;
    private JLabel labelInfoRequiredInputs;
    private JLabel labelParametersAfterFilename;
    private JLabel labelParametersBeforeFilename;
    private JPanel panelExpertSettings;
    private JPanel panelInputBeforeExecute;
    private JPanel panelMultipleSelection;
    private JPanel panelParameter;
    private JPanel panelProgram;
    private JRadioButton radioButtonSingleFileProcessingNo;
    private JRadioButton radioButtonSingleFileProcessingYes;
    private JScrollPane scrollPaneParametersAfterFilename;
    private JScrollPane scrollPaneParametersBeforeFilename;
    private JScrollPane scrollPaneUsePattern;
    private JTextArea textAreaParametersAfterFilename;
    private JTextArea textAreaParametersBeforeFilename;
    private JTextArea textAreaUsePattern;
    private JTextField textFieldAlias;
    private JToggleButton toggleButtonExpertSettings;

    public ProgramPropertiesDialog(boolean action) {
        super((Frame)GUI.getAppFrame(), true);
        this.action = action;
        this.program.setAction(action);
        this.initComponents();
        this.postInitComponents();
    }

    private File initCreateLastDir() {
        String lastDirPath = PREFS.getString(KEY_LAST_DIR);
        if (!StringUtil.hasContent(lastDirPath)) {
            return new File(SystemUtil.getDefaultProgramDirPath());
        }
        return new File(lastDirPath);
    }

    private void postInitComponents() {
        if (this.action) {
            this.setActionTexts();
        } else {
            this.getContentPane().remove(this.checkBoxInputBeforeExecute);
        }
        this.setIgnorePersistedSizeAndLocation(true);
        MnemonicUtil.setMnemonics(this);
        MnemonicUtil.setMnemonics(this.panelExpertSettings);
        this.listen();
    }

    private void listen() {
        this.textFieldAlias.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent evt) {
                ProgramPropertiesDialog.this.setEnabledButtonOk();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                ProgramPropertiesDialog.this.setEnabledButtonOk();
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                ProgramPropertiesDialog.this.setEnabledButtonOk();
            }
        });
    }

    private void setEnabledButtonOk() {
        this.buttonOk.setEnabled(this.inputsValid());
    }

    private void showFileExists(boolean exists) {
        if (exists) {
            this.labelErrorFileDoesNotExist.setText("<html> </html>");
        } else {
            this.labelErrorFileDoesNotExist.setText(Bundle.getString(ProgramPropertiesDialog.class, "ProgramPropertiesDialog.LabelErrorFileDoesNotExist.ErrorText", new Object[0]));
        }
        this.labelFile.setForeground(exists ? FG_COLOR_LABEL_FILE_EXISTS : FG_COLOR_LABEL_FILE_NOT_EXISTS);
        this.labelFile.setBackground(exists ? BG_COLOR_LABEL_FILE_EXISTS : BG_COLOR_LABEL_FILE_NOT_EXISTS);
    }

    public void setProgram(Program program) {
        if (program == null) {
            throw new NullPointerException("program == null");
        }
        this.program = program;
        this.file = program.getFile();
        String parametersBeforeFilename = program.getParametersBeforeFilename();
        String parametersAfterFilename = program.getParametersAfterFilename();
        this.labelFile.setText(this.file.getAbsolutePath());
        this.textFieldAlias.setText(program.getAlias());
        this.textAreaParametersBeforeFilename.setText(parametersBeforeFilename == null ? "" : parametersBeforeFilename);
        this.textAreaParametersAfterFilename.setText(parametersAfterFilename == null ? "" : parametersAfterFilename);
        this.checkBoxInputBeforeExecute.setSelected(program.isInputBeforeExecute());
        this.checkBoxInputBeforeExecutePerFile.setSelected(program.isInputBeforeExecutePerFile());
        this.checkBoxInputBeforeExecutePerFile.setEnabled(program.isInputBeforeExecute());
        this.radioButtonSingleFileProcessingYes.setSelected(program.isSingleFileProcessing());
        this.radioButtonSingleFileProcessingNo.setSelected(!program.isSingleFileProcessing());
        this.checkBoxChangeFile.setSelected(program.isChangeFile());
        this.checkBoxUsePattern.setSelected(program.isUsePattern());
        String pattern = program.getPattern();
        this.textAreaUsePattern.setText(pattern == null ? "" : pattern);
        this.setPatternStatus();
        this.setProgramIcon();
        this.showFileExists(this.file != null && this.file.exists());
        this.setEnabledButtonOk();
    }

    private void setActionTexts() {
        this.setTitle(Bundle.getString(ProgramPropertiesDialog.class, "ProgramPropertiesDialog.title.Action", new Object[0]));
        this.labelFilePrompt.setText(Bundle.getString(ProgramPropertiesDialog.class, "ProgramPropertiesDialog.labelFilePrompt.text.Action", new Object[0]));
        this.labelAlias.setText(Bundle.getString(ProgramPropertiesDialog.class, "ProgramPropertiesDialog.labelAlias.text.Action", new Object[0]));
    }

    private void setProgramIcon() {
        if (this.file != null && this.file.exists()) {
            this.labelFile.setIcon(IconUtil.getSystemIcon(this.file));
        }
    }

    public Program getProgram() {
        return this.program;
    }

    public boolean isAccepted() {
        return this.accecpted;
    }

    private void accept() {
        if (this.inputsValid()) {
            String parametersBeforeFilename = this.textAreaParametersBeforeFilename.getText().trim();
            String parametersAfterFilename = this.textAreaParametersAfterFilename.getText().trim();
            String pattern = this.textAreaUsePattern.getText().trim();
            this.program.setAction(this.action);
            this.program.setFile(this.file);
            this.program.setAlias(this.textFieldAlias.getText().trim());
            this.program.setParametersBeforeFilename(parametersBeforeFilename.isEmpty() ? null : parametersBeforeFilename);
            this.program.setParametersAfterFilename(parametersAfterFilename.isEmpty() ? null : parametersAfterFilename);
            this.program.setInputBeforeExecute(this.checkBoxInputBeforeExecute.isSelected());
            this.program.setInputBeforeExecutePerFile(this.checkBoxInputBeforeExecutePerFile.isSelected());
            this.program.setSingleFileProcessing(this.radioButtonSingleFileProcessingYes.isSelected());
            this.program.setChangeFile(this.checkBoxChangeFile.isSelected());
            this.program.setUsePattern(this.checkBoxUsePattern.isSelected());
            this.program.setPattern(pattern.isEmpty() ? null : pattern);
            this.accecpted = true;
            this.setVisible(false);
        } else {
            String message = Bundle.getString(ProgramPropertiesDialog.class, "ProgramPropertiesDialog.Error.MissingData", new Object[0]);
            MessageDisplayer.error(this, message);
        }
    }

    private boolean inputsValid() {
        return this.file != null && this.file.exists() && this.aliasDefined();
    }

    private boolean aliasDefined() {
        String alias = this.textFieldAlias.getText().trim();
        return !alias.isEmpty();
    }

    private void cancel() {
        this.accecpted = false;
        this.setVisible(false);
    }

    @Override
    protected void escape() {
        this.cancel();
    }

    private void chooseProgram() {
        JFileChooser fileChooser = new JFileChooser(this.lastDir);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(0);
        if (fileChooser.showOpenDialog(this) == 0) {
            this.file = fileChooser.getSelectedFile();
            this.storeLastDirOfFile(this.file);
            this.labelFile.setText(this.file.getAbsolutePath());
            this.showFileExists(true);
            this.setProgramIcon();
            if (!StringUtil.hasContent(this.textFieldAlias.getText())) {
                this.textFieldAlias.setText(this.file.getName());
            }
            this.textFieldAlias.requestFocusInWindow();
        }
        this.setEnabledButtonOk();
    }

    private void storeLastDirOfFile(File file) {
        File dir = file.getParentFile();
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        PREFS.setString(KEY_LAST_DIR, dir.getAbsolutePath());
        this.lastDir = dir;
    }

    private void handleCheckBoxInputBeforeExecuteActionPerformed() {
        boolean selected = this.checkBoxInputBeforeExecute.isSelected();
        if (!selected && this.checkBoxInputBeforeExecutePerFile.isSelected()) {
            this.checkBoxInputBeforeExecutePerFile.setSelected(false);
        }
        this.checkBoxInputBeforeExecutePerFile.setEnabled(selected);
    }

    private void handleTextFieldAliasKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.accept();
        }
    }

    private void setPatternStatus() {
        boolean usePattern = this.checkBoxUsePattern.isSelected();
        this.textAreaParametersBeforeFilename.setEnabled(!usePattern);
        this.textAreaParametersAfterFilename.setEnabled(!usePattern);
        this.textAreaUsePattern.setEnabled(usePattern);
        if (usePattern && this.radioButtonSingleFileProcessingNo.isSelected()) {
            this.radioButtonSingleFileProcessingYes.setSelected(true);
        }
        if (usePattern && this.checkBoxInputBeforeExecute.isSelected()) {
            this.checkBoxInputBeforeExecute.setSelected(false);
            this.checkBoxInputBeforeExecutePerFile.setSelected(false);
            this.checkBoxInputBeforeExecutePerFile.setEnabled(false);
        }
        this.radioButtonSingleFileProcessingNo.setEnabled(!usePattern);
        this.checkBoxInputBeforeExecute.setEnabled(!usePattern);
    }

    private void handleCheckBoxUsePatternActionPerformed() {
        this.setPatternStatus();
    }

    private void showPatternHelp() {
        this.showHelp("/org/jphototagger/program/resource/doc/de/parameter_substitution.html");
    }

    private void toggleExpertSettings() {
        boolean isExpertSettings = this.toggleButtonExpertSettings.isSelected();
        if (isExpertSettings) {
            this.addExpertSettingsPanel();
        } else {
            this.removeExpertSettings();
        }
        PREFS.setBoolean(KEY_EXPERT_SETTINGS, isExpertSettings);
        this.pack();
        ComponentUtil.forceRepaint(this);
    }

    private void addExpertSettingsPanel() {
        this.getContentPane().add((Component)this.panelExpertSettings, this.getExpertSettingsConstraints());
        this.toggleButtonExpertSettings.setText(BUTTON_TEXT_TOGGLE_TO_SIMPLE_SETTINGS);
        MnemonicUtil.setMnemonics(this.toggleButtonExpertSettings);
    }

    private void removeExpertSettings() {
        this.getContentPane().remove(this.panelExpertSettings);
        this.toggleButtonExpertSettings.setText(BUTTON_TEXT_TOGGLE_TO_EXPERT_SETTINGS);
        MnemonicUtil.setMnemonics(this.toggleButtonExpertSettings);
    }

    private GridBagConstraints getExpertSettingsConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.fill = 1;
        return gbc;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.addExperSettingBasedOnUserSettings();
            this.pack();
            this.setLocationRelativeTo(null);
        }
        super.setVisible(visible);
    }

    private void addExperSettingBasedOnUserSettings() {
        boolean isExpertSettings = PREFS.getBoolean(KEY_EXPERT_SETTINGS);
        if (isExpertSettings) {
            this.addExpertSettingsPanel();
            this.toggleButtonExpertSettings.setSelected(true);
        }
    }

    private void initComponents() {
        this.buttonGroupSingleFileProcessing = new ButtonGroup();
        this.panelExpertSettings = new JPanel();
        this.checkBoxChangeFile = new JCheckBox();
        this.panelParameter = new JPanel();
        this.labelParametersBeforeFilename = new JLabel();
        this.scrollPaneParametersBeforeFilename = new JScrollPane();
        this.textAreaParametersBeforeFilename = new TabOrEnterLeavingTextArea();
        this.labelParametersAfterFilename = new JLabel();
        this.scrollPaneParametersAfterFilename = new JScrollPane();
        this.textAreaParametersAfterFilename = new TabOrEnterLeavingTextArea();
        this.checkBoxUsePattern = new JCheckBox();
        this.buttonInfoUsePattern = new JButton();
        this.scrollPaneUsePattern = new JScrollPane();
        this.textAreaUsePattern = new TabOrEnterLeavingTextArea();
        this.panelInputBeforeExecute = new JPanel();
        this.checkBoxInputBeforeExecute = new JCheckBox();
        this.checkBoxInputBeforeExecutePerFile = new JCheckBox();
        this.panelMultipleSelection = new JPanel();
        this.radioButtonSingleFileProcessingYes = new JRadioButton();
        this.radioButtonSingleFileProcessingNo = new JRadioButton();
        this.panelProgram = new JPanel();
        this.labelFilePrompt = new JLabel();
        this.labelErrorFileDoesNotExist = new JLabel();
        this.buttonChooseFile = new JButton();
        this.labelFile = new JLabel();
        this.labelAlias = new JLabel();
        this.textFieldAlias = new JTextField();
        this.toggleButtonExpertSettings = new JToggleButton();
        this.labelInfoRequiredInputs = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.panelExpertSettings.setName("panelExpertSettings");
        this.panelExpertSettings.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/programs/Bundle");
        this.checkBoxChangeFile.setText(bundle.getString("ProgramPropertiesDialog.checkBoxChangeFile.text"));
        this.checkBoxChangeFile.setToolTipText(bundle.getString("ProgramPropertiesDialog.checkBoxChangeFile.toolTipText"));
        this.checkBoxChangeFile.setName("checkBoxChangeFile");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelExpertSettings.add((Component)this.checkBoxChangeFile, gridBagConstraints);
        this.panelParameter.setBorder(BorderFactory.createTitledBorder(bundle.getString("ProgramPropertiesDialog.panelParameter.border.title")));
        this.panelParameter.setName("panelParameter");
        this.panelParameter.setLayout(new GridBagLayout());
        this.labelParametersBeforeFilename.setLabelFor(this.textAreaParametersBeforeFilename);
        this.labelParametersBeforeFilename.setText(bundle.getString("ProgramPropertiesDialog.labelParametersBeforeFilename.text"));
        this.labelParametersBeforeFilename.setName("labelParametersBeforeFilename");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelParameter.add((Component)this.labelParametersBeforeFilename, gridBagConstraints);
        this.scrollPaneParametersBeforeFilename.setName("scrollPaneParametersBeforeFilename");
        this.textAreaParametersBeforeFilename.setColumns(20);
        this.textAreaParametersBeforeFilename.setLineWrap(true);
        this.textAreaParametersBeforeFilename.setRows(1);
        this.textAreaParametersBeforeFilename.setName("textAreaParametersBeforeFilename");
        this.scrollPaneParametersBeforeFilename.setViewportView(this.textAreaParametersBeforeFilename);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.33;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelParameter.add((Component)this.scrollPaneParametersBeforeFilename, gridBagConstraints);
        this.labelParametersAfterFilename.setLabelFor(this.textAreaParametersAfterFilename);
        this.labelParametersAfterFilename.setText(bundle.getString("ProgramPropertiesDialog.labelParametersAfterFilename.text"));
        this.labelParametersAfterFilename.setName("labelParametersAfterFilename");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelParameter.add((Component)this.labelParametersAfterFilename, gridBagConstraints);
        this.scrollPaneParametersAfterFilename.setName("scrollPaneParametersAfterFilename");
        this.textAreaParametersAfterFilename.setColumns(20);
        this.textAreaParametersAfterFilename.setLineWrap(true);
        this.textAreaParametersAfterFilename.setRows(1);
        this.textAreaParametersAfterFilename.setName("textAreaParametersAfterFilename");
        this.scrollPaneParametersAfterFilename.setViewportView(this.textAreaParametersAfterFilename);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.33;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelParameter.add((Component)this.scrollPaneParametersAfterFilename, gridBagConstraints);
        this.checkBoxUsePattern.setText(bundle.getString("ProgramPropertiesDialog.checkBoxUsePattern.text"));
        this.checkBoxUsePattern.setName("checkBoxUsePattern");
        this.checkBoxUsePattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramPropertiesDialog.this.checkBoxUsePatternActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelParameter.add((Component)this.checkBoxUsePattern, gridBagConstraints);
        this.buttonInfoUsePattern.setText(bundle.getString("ProgramPropertiesDialog.buttonInfoUsePattern.text"));
        this.buttonInfoUsePattern.setName("buttonInfoUsePattern");
        this.buttonInfoUsePattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramPropertiesDialog.this.buttonInfoUsePatternActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelParameter.add((Component)this.buttonInfoUsePattern, gridBagConstraints);
        this.scrollPaneUsePattern.setName("scrollPaneUsePattern");
        this.textAreaUsePattern.setColumns(20);
        this.textAreaUsePattern.setLineWrap(true);
        this.textAreaUsePattern.setRows(1);
        this.textAreaUsePattern.setName("textAreaUsePattern");
        this.scrollPaneUsePattern.setViewportView(this.textAreaUsePattern);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.33;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelParameter.add((Component)this.scrollPaneUsePattern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelExpertSettings.add((Component)this.panelParameter, gridBagConstraints);
        this.panelInputBeforeExecute.setBorder(BorderFactory.createTitledBorder(bundle.getString("ProgramPropertiesDialog.panelInputBeforeExecute.border.title")));
        this.panelInputBeforeExecute.setName("panelInputBeforeExecute");
        this.panelInputBeforeExecute.setLayout(new GridBagLayout());
        this.checkBoxInputBeforeExecute.setText(bundle.getString("ProgramPropertiesDialog.checkBoxInputBeforeExecute.text"));
        this.checkBoxInputBeforeExecute.setName("checkBoxInputBeforeExecute");
        this.checkBoxInputBeforeExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramPropertiesDialog.this.checkBoxInputBeforeExecuteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelInputBeforeExecute.add((Component)this.checkBoxInputBeforeExecute, gridBagConstraints);
        this.checkBoxInputBeforeExecutePerFile.setText(bundle.getString("ProgramPropertiesDialog.checkBoxInputBeforeExecutePerFile.text"));
        this.checkBoxInputBeforeExecutePerFile.setEnabled(false);
        this.checkBoxInputBeforeExecutePerFile.setName("checkBoxInputBeforeExecutePerFile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelInputBeforeExecute.add((Component)this.checkBoxInputBeforeExecutePerFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelExpertSettings.add((Component)this.panelInputBeforeExecute, gridBagConstraints);
        this.panelMultipleSelection.setBorder(BorderFactory.createTitledBorder(bundle.getString("ProgramPropertiesDialog.panelMultipleSelection.border.title")));
        this.panelMultipleSelection.setName("panelMultipleSelection");
        this.panelMultipleSelection.setLayout(new GridBagLayout());
        this.buttonGroupSingleFileProcessing.add(this.radioButtonSingleFileProcessingYes);
        this.radioButtonSingleFileProcessingYes.setSelected(true);
        this.radioButtonSingleFileProcessingYes.setText(bundle.getString("ProgramPropertiesDialog.radioButtonSingleFileProcessingYes.text"));
        this.radioButtonSingleFileProcessingYes.setName("radioButtonSingleFileProcessingYes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelMultipleSelection.add((Component)this.radioButtonSingleFileProcessingYes, gridBagConstraints);
        this.buttonGroupSingleFileProcessing.add(this.radioButtonSingleFileProcessingNo);
        this.radioButtonSingleFileProcessingNo.setText(bundle.getString("ProgramPropertiesDialog.radioButtonSingleFileProcessingNo.text"));
        this.radioButtonSingleFileProcessingNo.setName("radioButtonSingleFileProcessingNo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelMultipleSelection.add((Component)this.radioButtonSingleFileProcessingNo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelExpertSettings.add((Component)this.panelMultipleSelection, gridBagConstraints);
        this.setDefaultCloseOperation(2);
        this.setTitle(bundle.getString("ProgramPropertiesDialog.title"));
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProgramPropertiesDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.panelProgram.setBorder(BorderFactory.createTitledBorder(bundle.getString("ProgramPropertiesDialog.panelProgram.border.title")));
        this.panelProgram.setName("panelProgram");
        this.labelFilePrompt.setForeground(new Color(255, 0, 0));
        this.labelFilePrompt.setText(bundle.getString("ProgramPropertiesDialog.labelFilePrompt.text"));
        this.labelFilePrompt.setName("labelFilePrompt");
        this.labelErrorFileDoesNotExist.setForeground(new Color(255, 0, 0));
        this.labelErrorFileDoesNotExist.setText("<html> </html>");
        this.labelErrorFileDoesNotExist.setName("labelErrorFileDoesNotExist");
        this.buttonChooseFile.setText(bundle.getString("ProgramPropertiesDialog.buttonChooseFile.text"));
        this.buttonChooseFile.setName("buttonChooseFile");
        this.buttonChooseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramPropertiesDialog.this.buttonChooseFileActionPerformed(evt);
            }
        });
        this.labelFile.setForeground(new Color(0, 0, 255));
        this.labelFile.setBorder(BorderFactory.createEtchedBorder());
        this.labelFile.setName("labelFile");
        this.labelFile.setOpaque(true);
        this.labelAlias.setForeground(new Color(255, 0, 0));
        this.labelAlias.setLabelFor(this.textFieldAlias);
        this.labelAlias.setText(bundle.getString("ProgramPropertiesDialog.labelAlias.text"));
        this.labelAlias.setName("labelAlias");
        this.textFieldAlias.setName("textFieldAlias");
        this.textFieldAlias.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ProgramPropertiesDialog.this.textFieldAliasKeyPressed(evt);
            }
        });
        GroupLayout panelProgramLayout = new GroupLayout(this.panelProgram);
        this.panelProgram.setLayout(panelProgramLayout);
        panelProgramLayout.setHorizontalGroup(panelProgramLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelProgramLayout.createSequentialGroup().addContainerGap().addGroup(panelProgramLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelProgramLayout.createSequentialGroup().addComponent(this.labelFilePrompt).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.labelErrorFileDoesNotExist, -1, 314, Short.MAX_VALUE).addGap(3, 3, 3)).addGroup(panelProgramLayout.createSequentialGroup().addComponent(this.labelAlias).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldAlias, -1, 310, Short.MAX_VALUE)).addComponent(this.labelFile, GroupLayout.Alignment.TRAILING, -1, 427, Short.MAX_VALUE)).addGap(9, 9, 9).addComponent(this.buttonChooseFile).addContainerGap()));
        panelProgramLayout.setVerticalGroup(panelProgramLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelProgramLayout.createSequentialGroup().addGroup(panelProgramLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(panelProgramLayout.createSequentialGroup().addGroup(panelProgramLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelErrorFileDoesNotExist, -2, -1, -2).addComponent(this.labelFilePrompt)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelFile, -2, 23, -2)).addComponent(this.buttonChooseFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelProgramLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textFieldAlias, -2, -1, -2).addComponent(this.labelAlias)).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.panelProgram, gridBagConstraints);
        this.toggleButtonExpertSettings.setText(BUTTON_TEXT_TOGGLE_TO_EXPERT_SETTINGS);
        this.toggleButtonExpertSettings.setName("toggleButtonExpertSettings");
        this.toggleButtonExpertSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramPropertiesDialog.this.toggleButtonExpertSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 10, 0, 0);
        this.getContentPane().add((Component)this.toggleButtonExpertSettings, gridBagConstraints);
        this.labelInfoRequiredInputs.setForeground(new Color(255, 0, 0));
        this.labelInfoRequiredInputs.setText(bundle.getString("ProgramPropertiesDialog.labelInfoRequiredInputs.text"));
        this.labelInfoRequiredInputs.setName("labelInfoRequiredInputs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 0);
        this.getContentPane().add((Component)this.labelInfoRequiredInputs, gridBagConstraints);
        this.buttonCancel.setText(bundle.getString("ProgramPropertiesDialog.buttonCancel.text"));
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramPropertiesDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 10, 0);
        this.getContentPane().add((Component)this.buttonCancel, gridBagConstraints);
        this.buttonOk.setText(bundle.getString("ProgramPropertiesDialog.buttonOk.text"));
        this.buttonOk.setEnabled(false);
        this.buttonOk.setName("buttonOk");
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramPropertiesDialog.this.buttonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 10, 10);
        this.getContentPane().add((Component)this.buttonOk, gridBagConstraints);
        this.pack();
    }

    private void buttonChooseFileActionPerformed(ActionEvent evt) {
        this.chooseProgram();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancel();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.accept();
    }

    private void checkBoxInputBeforeExecuteActionPerformed(ActionEvent evt) {
        this.handleCheckBoxInputBeforeExecuteActionPerformed();
    }

    private void textFieldAliasKeyPressed(KeyEvent evt) {
        this.handleTextFieldAliasKeyPressed(evt);
    }

    private void checkBoxUsePatternActionPerformed(ActionEvent evt) {
        this.handleCheckBoxUsePatternActionPerformed();
    }

    private void buttonInfoUsePatternActionPerformed(ActionEvent evt) {
        this.showPatternHelp();
    }

    private void toggleButtonExpertSettingsActionPerformed(ActionEvent evt) {
        this.toggleExpertSettings();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgramPropertiesDialog dialog = new ProgramPropertiesDialog(true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

