/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.programs;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesHints;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class ProgramInputParametersDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private boolean accepted = false;
    private JButton buttonCancel;
    private ButtonGroup buttonGroup;
    private JButton buttonOk;
    private JLabel labelContextFile;
    private JLabel labelContextFilePrompt;
    private JLabel labelContextProgram;
    private JLabel labelContextProgramPrompt;
    private JLabel labelPrompt;
    private JPanel panelContext;
    private JRadioButton radioButtonParametersAfterFilename;
    private JRadioButton radioButtonParametersBeforeFilename;
    private JScrollPane scrollPaneAreaParameter;
    private JTextArea textAreaParameter;

    public ProgramInputParametersDialog() {
        super((Frame)GUI.getAppFrame(), true);
        this.initComponents();
        MnemonicUtil.setMnemonics(this);
    }

    public void setProgram(String program) {
        if (program == null) {
            throw new NullPointerException("program == null");
        }
        this.labelContextProgram.setText(program);
    }

    public void setFilename(String filename) {
        if (filename == null) {
            throw new NullPointerException("filename == null");
        }
        this.labelContextFile.setText(filename);
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public String getParameters() {
        return this.textAreaParameter.getText();
    }

    public boolean isParametersBeforeFilename() {
        return this.radioButtonParametersBeforeFilename.isSelected();
    }

    @Override
    public void setVisible(boolean visible) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (visible) {
            prefs.applyComponentSettings(this, new PreferencesHints(PreferencesHints.Option.SET_TABBED_PANE_CONTENT));
        } else {
            prefs.setComponent(this, new PreferencesHints(PreferencesHints.Option.SET_TABBED_PANE_CONTENT));
        }
        super.setVisible(visible);
    }

    @Override
    protected void escape() {
        this.cancel();
    }

    private void cancel() {
        this.accepted = false;
        this.setVisible(false);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.panelContext = new JPanel();
        this.labelContextProgramPrompt = new JLabel();
        this.labelContextProgram = new JLabel();
        this.labelContextFilePrompt = new JLabel();
        this.labelContextFile = new JLabel();
        this.labelPrompt = new JLabel();
        this.scrollPaneAreaParameter = new JScrollPane();
        this.textAreaParameter = new JTextArea();
        this.radioButtonParametersBeforeFilename = new JRadioButton();
        this.radioButtonParametersAfterFilename = new JRadioButton();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/programs/Bundle");
        this.setTitle(bundle.getString("ProgramInputParametersDialog.title"));
        this.setName("Form");
        this.panelContext.setBorder(BorderFactory.createTitledBorder(bundle.getString("ProgramInputParametersDialog.panelContext.border.title")));
        this.panelContext.setName("panelContext");
        this.labelContextProgramPrompt.setText(bundle.getString("ProgramInputParametersDialog.labelContextProgramPrompt.text"));
        this.labelContextProgramPrompt.setName("labelContextProgramPrompt");
        this.labelContextProgram.setName("labelContextProgram");
        this.labelContextFilePrompt.setText(bundle.getString("ProgramInputParametersDialog.labelContextFilePrompt.text"));
        this.labelContextFilePrompt.setName("labelContextFilePrompt");
        this.labelContextFile.setName("labelContextFile");
        GroupLayout panelContextLayout = new GroupLayout(this.panelContext);
        this.panelContext.setLayout(panelContextLayout);
        panelContextLayout.setHorizontalGroup(panelContextLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelContextLayout.createSequentialGroup().addContainerGap().addGroup(panelContextLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelContextProgramPrompt).addComponent(this.labelContextFilePrompt)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelContextLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelContextFile, GroupLayout.Alignment.TRAILING, -1, 187, Short.MAX_VALUE).addComponent(this.labelContextProgram, GroupLayout.Alignment.TRAILING, -1, 187, Short.MAX_VALUE)).addContainerGap()));
        panelContextLayout.setVerticalGroup(panelContextLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelContextLayout.createSequentialGroup().addGroup(panelContextLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelContextProgram).addComponent(this.labelContextProgramPrompt)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(panelContextLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelContextFile).addComponent(this.labelContextFilePrompt)).addContainerGap()));
        panelContextLayout.linkSize(1, this.labelContextProgram, this.labelContextProgramPrompt);
        panelContextLayout.linkSize(1, this.labelContextFile, this.labelContextFilePrompt);
        this.labelPrompt.setLabelFor(this.textAreaParameter);
        this.labelPrompt.setText(bundle.getString("ProgramInputParametersDialog.labelPrompt.text"));
        this.labelPrompt.setName("labelPrompt");
        this.scrollPaneAreaParameter.setName("scrollPaneAreaParameter");
        this.textAreaParameter.setColumns(20);
        this.textAreaParameter.setRows(2);
        this.textAreaParameter.setName("textAreaParameter");
        this.scrollPaneAreaParameter.setViewportView(this.textAreaParameter);
        this.buttonGroup.add(this.radioButtonParametersBeforeFilename);
        this.radioButtonParametersBeforeFilename.setSelected(true);
        this.radioButtonParametersBeforeFilename.setText(bundle.getString("ProgramInputParametersDialog.radioButtonParametersBeforeFilename.text"));
        this.radioButtonParametersBeforeFilename.setName("radioButtonParametersBeforeFilename");
        this.buttonGroup.add(this.radioButtonParametersAfterFilename);
        this.radioButtonParametersAfterFilename.setText(bundle.getString("ProgramInputParametersDialog.radioButtonParametersAfterFilename.text"));
        this.radioButtonParametersAfterFilename.setName("radioButtonParametersAfterFilename");
        this.buttonCancel.setText(bundle.getString("ProgramInputParametersDialog.buttonCancel.text"));
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramInputParametersDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOk.setText(bundle.getString("ProgramInputParametersDialog.buttonOk.text"));
        this.buttonOk.setName("buttonOk");
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramInputParametersDialog.this.buttonOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioButtonParametersBeforeFilename).addComponent(this.panelContext, -1, -1, Short.MAX_VALUE).addComponent(this.labelPrompt).addComponent(this.scrollPaneAreaParameter, -1, 294, Short.MAX_VALUE).addComponent(this.radioButtonParametersAfterFilename).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOk))).addContainerGap()));
        layout.linkSize(0, this.buttonCancel, this.buttonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.panelContext, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelPrompt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPaneAreaParameter, -1, 57, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonParametersBeforeFilename).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonParametersAfterFilename).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk).addComponent(this.buttonCancel)).addContainerGap()));
        this.pack();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.accepted = true;
        this.setVisible(false);
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgramInputParametersDialog dialog = new ProgramInputParametersDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

