/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.programs;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.programs.ProgramType;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.program.module.programs.ProgramsListCellRenderer;
import org.jphototagger.program.module.programs.ProgramsListModel;

public class ProgramChooseDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final ProgramsListModel model = new ProgramsListModel(ProgramType.PROGRAM);
    private boolean accepted;
    private Program selectedProgram;
    private JButton buttonChooseProgram;
    private JXList listPrograms;
    private JScrollPane scrollPanePrograms;
    private BindingGroup bindingGroup;

    public ProgramChooseDialog() {
        this((Program)null);
    }

    public ProgramChooseDialog(Program selectedProgram) {
        super(ComponentUtil.findFrameWithIcon(), true);
        this.initComponents();
        this.selectedProgram = selectedProgram;
        this.postInitComponents();
    }

    private void postInitComponents() {
        if (this.selectedProgram != null) {
            this.listPrograms.setSelectedValue(this.selectedProgram, true);
        }
        MnemonicUtil.setMnemonics(this);
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public Program getSelectedProgram() {
        return this.selectedProgram;
    }

    public void setSelectedProgram(Program selectedProgram) {
        this.selectedProgram = selectedProgram;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.scrollPanePrograms = new JScrollPane();
        this.listPrograms = new JXList();
        this.buttonChooseProgram = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/programs/Bundle");
        this.setTitle(bundle.getString("ProgramChooseDialog.title"));
        this.listPrograms.setModel((ListModel)this.model);
        this.listPrograms.setSelectionMode(0);
        this.listPrograms.setCellRenderer((ListCellRenderer)new ProgramsListCellRenderer());
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this, ELProperty.create("${selectedProgram}"), this.listPrograms, BeanProperty.create("selectedElement"));
        this.bindingGroup.addBinding(binding);
        this.listPrograms.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProgramChooseDialog.this.listProgramsMouseClicked(evt);
            }
        });
        this.listPrograms.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ProgramChooseDialog.this.listProgramsKeyPressed(evt);
            }
        });
        this.scrollPanePrograms.setViewportView(this.listPrograms);
        this.buttonChooseProgram.setText(bundle.getString("ProgramChooseDialog.buttonChooseProgram.text"));
        this.buttonChooseProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramChooseDialog.this.buttonChooseProgramActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPanePrograms).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 264, Short.MAX_VALUE).addComponent(this.buttonChooseProgram))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPanePrograms, -1, 246, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonChooseProgram).addContainerGap()));
        this.bindingGroup.bind();
        this.pack();
    }

    private void buttonChooseProgramActionPerformed(ActionEvent evt) {
        this.accepted = true;
        this.dispose();
    }

    private void listProgramsMouseClicked(MouseEvent evt) {
        if (MouseEventUtil.isDoubleClick(evt) && this.listPrograms.getSelectedIndex() >= 0) {
            this.setSelectedProgram((Program)this.listPrograms.getSelectedValue());
            this.accepted = true;
            this.dispose();
        }
    }

    private void listProgramsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.listPrograms.getSelectedIndex() >= 0) {
            this.setSelectedProgram((Program)this.listPrograms.getSelectedValue());
            this.accepted = true;
            this.dispose();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgramChooseDialog dialog = new ProgramChooseDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

