/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.programs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import org.jphototagger.domain.filetypes.UserDefinedFileType;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.repository.ProgramsRepository;
import org.jphototagger.domain.repository.UserDefinedFileTypesRepository;
import org.jphototagger.domain.thumbnails.ThumbnailCreator;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.programs.ProgramChooseDialog;
import org.openide.util.Lookup;

public class EditDefaultProgramsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final FileSystemView FILE_SYSTEM_VIEW = FileSystemView.getFileSystemView();
    private final ProgramsRepository programsRepository = Lookup.getDefault().lookup(ProgramsRepository.class);
    private final ListCellRenderer<String> suffixProgramListCellRenderer = new ListCellRenderer<String>(){
        private final DefaultListCellRenderer delegate = new DefaultListCellRenderer();

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String filesuffix, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)this.delegate.getListCellRendererComponent(list, filesuffix, index, isSelected, cellHasFocus);
            Program program = null;
            if (EditDefaultProgramsPanel.this.programsRepository != null) {
                program = EditDefaultProgramsPanel.this.programsRepository.findDefaultProgram(filesuffix);
            }
            label.setText(program == null ? filesuffix : filesuffix + " - " + program.getAlias());
            label.setHorizontalTextPosition(2);
            label.setIcon(program == null ? null : this.findIcon(program.getFile()));
            return label;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Icon findIcon(File file) {
            FileSystemView fileSystemView = FILE_SYSTEM_VIEW;
            synchronized (fileSystemView) {
                try {
                    return FILE_SYSTEM_VIEW.getSystemIcon(file);
                }
                catch (Throwable t) {
                    Logger.getLogger(EditDefaultProgramsPanel.class.getName()).log(Level.SEVERE, null, t);
                    return null;
                }
            }
        }
    };
    private final ListSelectionListener suffixesListListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                EditDefaultProgramsPanel.this.setButtonsEnabled();
            }
        }
    };
    private JButton buttonRemoveDefaultPrograms;
    private JButton buttonSetDefaultPrograms;
    private JLabel labelListFilenameSuffixes;
    private JList<String> listFilenameSuffixes;
    private JPanel panelButtons;
    private JScrollPane scrollPaneFilenameSuffixes;

    public EditDefaultProgramsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.listFilenameSuffixes.addListSelectionListener(this.suffixesListListener);
        MnemonicUtil.setMnemonics(this);
    }

    private void setButtonsEnabled() {
        this.buttonRemoveDefaultPrograms.setEnabled(this.allSelectedHavingDefaultProgram());
        boolean filenameSuffixSelected = this.listFilenameSuffixes.getSelectedIndex() >= 0;
        this.buttonSetDefaultPrograms.setEnabled(filenameSuffixSelected);
    }

    private boolean allSelectedHavingDefaultProgram() {
        List<String> selectedFilenameSuffixes = this.listFilenameSuffixes.getSelectedValuesList();
        for (String filenameSuffix : selectedFilenameSuffixes) {
            if (this.programsRepository.existsDefaultProgram(filenameSuffix)) continue;
            return false;
        }
        return !selectedFilenameSuffixes.isEmpty();
    }

    private void setDefaultPrograms() {
        List<String> selectedFilenameSuffixes = this.listFilenameSuffixes.getSelectedValuesList();
        if (selectedFilenameSuffixes.isEmpty()) {
            return;
        }
        Program program = this.chooseProgram(selectedFilenameSuffixes.size() == 1 ? selectedFilenameSuffixes.get(0) : null);
        ComponentUtil.parentWindowToFront(this);
        if (program == null) {
            return;
        }
        for (String filenameSuffix : selectedFilenameSuffixes) {
            if (this.programsRepository.setDefaultProgram(filenameSuffix, program.getId())) continue;
            String message = Bundle.getString(EditDefaultProgramsPanel.class, "EditDefaultProgramsPanel.Error.SetDefaultProgram", filenameSuffix);
            MessageDisplayer.error(this, message);
        }
        ComponentUtil.forceRepaint(this.listFilenameSuffixes);
        this.setButtonsEnabled();
    }

    private Program chooseProgram(String filenameSuffix) {
        ProgramChooseDialog dialog = new ProgramChooseDialog(filenameSuffix == null ? null : this.programsRepository.findDefaultProgram(filenameSuffix));
        dialog.setVisible(true);
        return dialog.isAccepted() ? dialog.getSelectedProgram() : null;
    }

    private void removeDefaultPrograms() {
        List<String> selectedFilenameSuffixes = this.listFilenameSuffixes.getSelectedValuesList();
        if (selectedFilenameSuffixes.isEmpty()) {
            return;
        }
        String message = Bundle.getString(EditDefaultProgramsPanel.class, "EditDefaultProgramsPanel.Confirm.RemoveProgram", new Object[0]);
        if (MessageDisplayer.confirmYesNo(this, message)) {
            for (String filenameSuffix : selectedFilenameSuffixes) {
                if (this.programsRepository.removeDefaultProgram(filenameSuffix)) continue;
                String errorMessage = Bundle.getString(EditDefaultProgramsPanel.class, "EditDefaultProgramsPanel.Error.RemoveDefaultProgram", filenameSuffix);
                MessageDisplayer.error(this, errorMessage);
            }
        }
        ComponentUtil.forceRepaint(this.listFilenameSuffixes);
        this.setButtonsEnabled();
    }

    private void initComponents() {
        this.labelListFilenameSuffixes = new JLabel();
        this.panelButtons = new JPanel();
        this.buttonRemoveDefaultPrograms = new JButton();
        this.buttonSetDefaultPrograms = new JButton();
        this.scrollPaneFilenameSuffixes = new JScrollPane();
        this.listFilenameSuffixes = new JList();
        this.setLayout(new GridBagLayout());
        this.labelListFilenameSuffixes.setLabelFor(this.listFilenameSuffixes);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/programs/Bundle");
        this.labelListFilenameSuffixes.setText(bundle.getString("EditDefaultProgramsPanel.labelListFilenameSuffixes.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.labelListFilenameSuffixes, gridBagConstraints);
        this.panelButtons.setLayout(new GridBagLayout());
        this.buttonRemoveDefaultPrograms.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/module/programs/delete.png")));
        this.buttonRemoveDefaultPrograms.setToolTipText(bundle.getString("EditDefaultProgramsPanel.buttonRemoveDefaultPrograms.toolTipText"));
        this.buttonRemoveDefaultPrograms.setEnabled(false);
        this.buttonRemoveDefaultPrograms.setMargin(new Insets(0, 0, 0, 0));
        this.buttonRemoveDefaultPrograms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditDefaultProgramsPanel.this.buttonRemoveDefaultProgramsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelButtons.add((Component)this.buttonRemoveDefaultPrograms, gridBagConstraints);
        this.buttonSetDefaultPrograms.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/module/programs/edit.png")));
        this.buttonSetDefaultPrograms.setToolTipText(bundle.getString("EditDefaultProgramsPanel.buttonSetDefaultPrograms.toolTipText"));
        this.buttonSetDefaultPrograms.setEnabled(false);
        this.buttonSetDefaultPrograms.setMargin(new Insets(0, 0, 0, 0));
        this.buttonSetDefaultPrograms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditDefaultProgramsPanel.this.buttonSetDefaultProgramsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelButtons.add((Component)this.buttonSetDefaultPrograms, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.panelButtons, gridBagConstraints);
        this.listFilenameSuffixes.setModel(new FilenameSuffixesListModel());
        this.listFilenameSuffixes.setCellRenderer(this.suffixProgramListCellRenderer);
        this.listFilenameSuffixes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EditDefaultProgramsPanel.this.listFilenameSuffixesMouseClicked(evt);
            }
        });
        this.listFilenameSuffixes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                EditDefaultProgramsPanel.this.listFilenameSuffixesKeyPressed(evt);
            }
        });
        this.scrollPaneFilenameSuffixes.setViewportView(this.listFilenameSuffixes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.scrollPaneFilenameSuffixes, gridBagConstraints);
    }

    private void buttonSetDefaultProgramsActionPerformed(ActionEvent evt) {
        this.setDefaultPrograms();
    }

    private void buttonRemoveDefaultProgramsActionPerformed(ActionEvent evt) {
        this.removeDefaultPrograms();
    }

    private void listFilenameSuffixesMouseClicked(MouseEvent evt) {
        if (MouseEventUtil.isDoubleClick(evt) && this.listFilenameSuffixes.getSelectedIndex() >= 0) {
            this.setDefaultPrograms();
        }
    }

    private void listFilenameSuffixesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.listFilenameSuffixes.getSelectedIndex() >= 0) {
            this.setDefaultPrograms();
        } else if (evt.getKeyCode() == 127 && this.listFilenameSuffixes.getSelectedIndex() >= 0) {
            this.removeDefaultPrograms();
        }
    }

    private static class FilenameSuffixesListModel
    extends DefaultListModel<String> {
        private static final long serialVersionUID = 1L;

        private FilenameSuffixesListModel() {
            this.addElements();
        }

        private void addElements() {
            Collection<ThumbnailCreator> tnCreators = Lookup.getDefault().lookupAll(ThumbnailCreator.class);
            UserDefinedFileTypesRepository udfRepo = Lookup.getDefault().lookup(UserDefinedFileTypesRepository.class);
            if (tnCreators == null || udfRepo == null) {
                return;
            }
            LinkedList<String> filenameSuffixes = new LinkedList<String>();
            List<UserDefinedFileType> fileTypes = udfRepo.findAllUserDefinedFileTypes();
            for (UserDefinedFileType fileType : fileTypes) {
                filenameSuffixes.add(fileType.getSuffix());
            }
            for (ThumbnailCreator tnCreator : tnCreators) {
                for (String filenameSuffix : tnCreator.getAllSupportedFileTypeSuffixes()) {
                    if (filenameSuffixes.contains(filenameSuffix)) continue;
                    filenameSuffixes.add(filenameSuffix);
                }
            }
            Collections.sort(filenameSuffixes);
            for (String suffix : filenameSuffixes) {
                this.addElement(suffix);
            }
        }
    }
}

