/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.miscmetadata;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.concurrent.SerialTaskExecutor;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpMetaDataValues;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.repository.SaveOrUpdate;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.ProgressBarUpdater;
import org.jphototagger.lib.util.ThreadUtil;
import org.jphototagger.program.misc.SaveToOrUpdateFilesInRepositoryImpl;
import org.jphototagger.program.module.miscmetadata.MiscMetadataUtil;
import org.jphototagger.xmp.XmpMetadata;
import org.openide.util.Lookup;

public final class RenameDeleteXmpValue {
    private RenameDeleteXmpValue() {
    }

    public static void rename(MetaDataValue metaDataValue, String oldValue) {
        if (metaDataValue == null) {
            throw new NullPointerException("metaDataValue == null");
        }
        if (oldValue == null) {
            throw new NullPointerException("oldValue == null");
        }
        RenameDeleteXmpValue.checkMetaDataValue(metaDataValue);
        String info = Bundle.getString(RenameDeleteXmpValue.class, "RenameDeleteXmpValue.Input.NewValue", new Object[0]);
        String input = oldValue;
        String newValue = MessageDisplayer.input(info, input);
        if (newValue != null) {
            if ((newValue = newValue.trim()).equals(oldValue.trim())) {
                String message = Bundle.getString(RenameDeleteXmpValue.class, "RenameDeleteXmpValue.Error.ValuesEquals", new Object[0]);
                MessageDisplayer.error(null, message);
            } else {
                SerialTaskExecutor executor = Lookup.getDefault().lookup(SerialTaskExecutor.class);
                Rename rename = new Rename(metaDataValue, oldValue, newValue);
                executor.addTask(rename);
            }
        }
    }

    public static void delete(MetaDataValue mdValue, String value) {
        if (mdValue == null) {
            throw new NullPointerException("mdValue == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        RenameDeleteXmpValue.checkMetaDataValue(mdValue);
        if (value.trim().isEmpty()) {
            return;
        }
        String message = Bundle.getString(RenameDeleteXmpValue.class, "RenameDeleteXmpValue.Confirm.Delete", value);
        if (MessageDisplayer.confirmYesNo(null, message)) {
            SerialTaskExecutor executor = Lookup.getDefault().lookup(SerialTaskExecutor.class);
            Rename rename = new Rename(mdValue, value, "");
            executor.addTask(rename);
        }
    }

    private static void checkMetaDataValue(MetaDataValue mdValue) {
        if (!XmpMetaDataValues.get().contains(mdValue)) {
            throw new IllegalArgumentException("Not a XMP metadata value: " + mdValue);
        }
        if (mdValue.equals(XmpDcSubjectsSubjectMetaDataValue.INSTANCE)) {
            throw new IllegalArgumentException("DC subjects are invalid!");
        }
    }

    private static class Rename
    extends Thread
    implements Cancelable {
        private final ProgressBarUpdater pb = new ProgressBarUpdater(this, Bundle.getString(Rename.class, "RenameDeleteXmpValue.ProgressBar.String", new Object[0]));
        private final MetaDataValue metaDataValue;
        private final String newValue;
        private final String oldValue;
        private volatile boolean cancel;
        private final ImageFilesRepository repo = Lookup.getDefault().lookup(ImageFilesRepository.class);
        private final XmpSidecarFileResolver xmpSidecarFileResolver = Lookup.getDefault().lookup(XmpSidecarFileResolver.class);

        Rename(MetaDataValue metaDataValue, String oldValue, String newValue) {
            super("JPhotoTagger: Renaming XMP value");
            this.metaDataValue = metaDataValue;
            this.oldValue = oldValue.trim();
            this.newValue = newValue.trim();
        }

        @Override
        public void cancel() {
            this.cancel = true;
        }

        @Override
        public void run() {
            List<File> imageFiles = this.repo.findImageFilesWhereMetaDataValueHasExactValue(this.metaDataValue, this.oldValue);
            int size = imageFiles.size();
            int value = 0;
            this.notifyStarted(size);
            for (File imageFile : imageFiles) {
                if (this.cancel || this.isInterrupted()) break;
                Xmp xmp = null;
                try {
                    xmp = XmpMetadata.getXmpFromSidecarFileOf(imageFile);
                }
                catch (IOException ex) {
                    Logger.getLogger(RenameDeleteXmpValue.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (xmp != null) {
                    this.rename(xmp);
                    File suggestSidecarFile = this.xmpSidecarFileResolver.suggestXmpSidecarFile(imageFile);
                    if (XmpMetadata.writeXmpToSidecarFile(xmp, suggestSidecarFile)) {
                        SaveToOrUpdateFilesInRepositoryImpl insertImageFilesIntoRepository = new SaveToOrUpdateFilesInRepositoryImpl(Collections.singletonList(imageFile), SaveOrUpdate.XMP);
                        ThreadUtil.runInThisThread(insertImageFilesIntoRepository);
                    }
                }
                this.notifyPerformed(++value, size);
            }
            this.repo.deleteValueOfJoinedMetaDataValue(this.metaDataValue, this.oldValue);
            MiscMetadataUtil.removeChildValueFrom(this.metaDataValue, this.oldValue);
            this.notifyEnded(value, size);
        }

        private void rename(Xmp xmp) {
            xmp.setValue(this.metaDataValue, this.newValue);
        }

        private void notifyStarted(int count) {
            ProgressEvent evt = new ProgressEvent.Builder().source(this).minimum(0).maximum(count).value(0).build();
            this.pb.progressStarted(evt);
        }

        private void notifyPerformed(int value, int count) {
            ProgressEvent evt = new ProgressEvent.Builder().source(this).minimum(0).maximum(count).value(value).build();
            this.pb.progressPerformed(evt);
        }

        private void notifyEnded(int value, int count) {
            ProgressEvent evt = new ProgressEvent.Builder().source(this).minimum(0).maximum(count).value(value).build();
            this.pb.progressEnded(evt);
        }
    }
}

