/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.miscmetadata;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jphototagger.domain.metadata.MetaDataStringValue;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.MetaDataValueData;
import org.jphototagger.domain.metadata.SelectedFilesMetaDataEditor;
import org.jphototagger.domain.metadata.xmp.FileXmp;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpMetaDataValues;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.program.misc.SaveXmp;
import org.jphototagger.program.module.filesystem.FilesystemImageUtil;
import org.jphototagger.program.resource.GUI;
import org.jphototagger.xmp.XmpMetadata;
import org.openide.util.Lookup;

public final class MiscMetadataUtil {
    private static final List<MetaDataValue> XMP_META_DATA_VALUES = XmpMetaDataValues.get();

    public static void saveToImageFiles(List<MetaDataValueData> valueData, Collection<? extends File> imageFiles) {
        if (valueData == null) {
            throw new NullPointerException("values == null");
        }
        if (imageFiles == null) {
            throw new NullPointerException("imageFile == null");
        }
        ArrayList<FileXmp> saveList = new ArrayList<FileXmp>();
        for (File file : imageFiles) {
            if (!file.exists() || !FilesystemImageUtil.checkImageEditable(file)) continue;
            Xmp xmp = null;
            try {
                xmp = XmpMetadata.getXmpFromSidecarFileOf(file);
            }
            catch (IOException ex) {
                Logger.getLogger(MiscMetadataUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (xmp == null) {
                xmp = new Xmp();
            }
            for (MetaDataValueData valueDate : valueData) {
                xmp.setValue(valueDate.getMetaDataValue(), valueDate.getData());
            }
            saveList.add(new FileXmp(file, xmp));
        }
        if (!saveList.isEmpty()) {
            SaveXmp.save(saveList);
        }
    }

    public static void saveToImageFile(List<MetaDataValueData> colData, File imageFile) {
        if (colData == null) {
            throw new NullPointerException("colData == null");
        }
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        MiscMetadataUtil.saveToImageFiles(colData, Collections.singleton(imageFile));
    }

    public static void addMetadataToSelectedImages(final Collection<? extends DefaultMutableTreeNode> nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes == null");
        }
        final List<MetaDataValue> xmpMetaDataValues = XmpMetaDataValues.get();
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                SelectedFilesMetaDataEditor editor = Lookup.getDefault().lookup(SelectedFilesMetaDataEditor.class);
                if (!editor.isEditable()) {
                    return;
                }
                for (DefaultMutableTreeNode node : nodes) {
                    if (!MiscMetadataUtil.isParentUserObjectAMetaDataValue(node, xmpMetaDataValues)) continue;
                    String text = (String)node.getUserObject();
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    MetaDataValue mdValue = (MetaDataValue)parent.getUserObject();
                    editor.setOrAddText(mdValue, text);
                }
            }
        });
    }

    public static void removeMetadataFromSelectedImages(final Collection<? extends DefaultMutableTreeNode> nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes == null");
        }
        final List<MetaDataValue> xmpMetaDataValues = XmpMetaDataValues.get();
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                SelectedFilesMetaDataEditor editor = Lookup.getDefault().lookup(SelectedFilesMetaDataEditor.class);
                if (!editor.isEditable()) {
                    return;
                }
                for (DefaultMutableTreeNode node : nodes) {
                    if (!MiscMetadataUtil.isParentUserObjectAMetaDataValue(node, xmpMetaDataValues)) continue;
                    String text = (String)node.getUserObject();
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    MetaDataValue mdValue = (MetaDataValue)parent.getUserObject();
                    editor.removeText(mdValue, text);
                }
            }
        });
    }

    public static void addMetadataToSelectedImages(final MetaDataValue mdValue, final String text) {
        if (mdValue == null) {
            throw new NullPointerException("mdValue == null");
        }
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                SelectedFilesMetaDataEditor editor = Lookup.getDefault().lookup(SelectedFilesMetaDataEditor.class);
                if (editor.isEditable()) {
                    editor.setOrAddText(mdValue, text);
                }
            }
        });
    }

    public static void removeMetadataFromSelectedImages(final MetaDataValue mdValue, final String text) {
        if (mdValue == null) {
            throw new NullPointerException("mdValue == null");
        }
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                SelectedFilesMetaDataEditor editor = Lookup.getDefault().lookup(SelectedFilesMetaDataEditor.class);
                if (editor.isEditable()) {
                    editor.removeText(mdValue, text);
                }
            }
        });
    }

    public static boolean isParentUserObjectAMetaDataValue(DefaultMutableTreeNode node, Collection<? extends MetaDataValue> mdValues) {
        if (node == null) {
            throw new NullPointerException("node == null");
        }
        if (mdValues == null) {
            throw new NullPointerException("mdValues == null");
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        Object userObject = parent.getUserObject();
        if (userObject instanceof MetaDataValue) {
            return mdValues.contains((MetaDataValue)userObject);
        }
        return false;
    }

    private static DefaultTreeModel getModel() {
        return (DefaultTreeModel)GUI.getAppPanel().getTreeMiscMetadata().getModel();
    }

    public static DefaultMutableTreeNode findNodeContains(MetaDataValue mdValue) {
        if (mdValue == null) {
            throw new NullPointerException("mdValue == null");
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)MiscMetadataUtil.getModel().getRoot();
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof MetaDataValue) || !((MetaDataValue)userObject).equals(mdValue)) continue;
            return node;
        }
        return null;
    }

    public static void removeChildValueFrom(final MetaDataValue mdValue, final String value) {
        if (mdValue == null) {
            throw new NullPointerException("value == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode node = MiscMetadataUtil.findNodeContains(mdValue);
                if (node != null) {
                    int count = node.getChildCount();
                    for (int i = 0; i < count; ++i) {
                        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                        Object uo = childNode.getUserObject();
                        if (!(uo instanceof String) || !((String)uo).equals(value)) continue;
                        MiscMetadataUtil.getModel().removeNodeFromParent(childNode);
                        return;
                    }
                }
            }
        });
    }

    public static List<MetaDataStringValue> getColValuesFrom(List<TreePath> paths) {
        if (paths == null) {
            throw new NullPointerException("paths == null");
        }
        ArrayList<MetaDataStringValue> values = new ArrayList<MetaDataStringValue>(paths.size());
        for (TreePath path : paths) {
            MetaDataStringValue value = MiscMetadataUtil.getColValueFrom(path);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public static MetaDataStringValue getColValueFrom(TreePath path) {
        if (path == null) {
            throw new NullPointerException("path == null");
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return MiscMetadataUtil.getColValueFrom(node);
    }

    public static MetaDataStringValue getColValueFrom(DefaultMutableTreeNode node) {
        if (node == null) {
            throw new NullPointerException("node == null");
        }
        if (MiscMetadataUtil.isParentUserObjectAMetaDataValue(node, XMP_META_DATA_VALUES)) {
            String value = node.getUserObject().toString();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            MetaDataValue mdValue = (MetaDataValue)parentNode.getUserObject();
            return new MetaDataStringValue(mdValue, value);
        }
        return null;
    }

    private MiscMetadataUtil() {
    }
}

