/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.miscmetadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.exif.Exif;
import org.jphototagger.domain.metadata.exif.ExifFocalLengthMetaDataValue;
import org.jphototagger.domain.metadata.exif.ExifIsoSpeedRatingsMetaDataValue;
import org.jphototagger.domain.metadata.exif.ExifLensMetaDataValue;
import org.jphototagger.domain.metadata.exif.ExifRecordingEquipmentMetaDataValue;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpDcCreatorMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcRightsMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpIptc4xmpcoreLocationMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopCityMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopCountryMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopSourceMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopStateMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpRatingMetaDataValue;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.repository.event.dcsubjects.DcSubjectDeletedEvent;
import org.jphototagger.domain.repository.event.dcsubjects.DcSubjectInsertedEvent;
import org.jphototagger.domain.repository.event.exif.ExifDeletedEvent;
import org.jphototagger.domain.repository.event.exif.ExifInsertedEvent;
import org.jphototagger.domain.repository.event.exif.ExifUpdatedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpDeletedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.lib.swing.util.TreeUtil;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class MiscMetadataTreeModel
extends DefaultTreeModel {
    private static final Object EXIF_USER_OBJECT = Bundle.getString(MiscMetadataTreeModel.class, "MiscMetadataTreeModel.ExifNode.DisplayName", new Object[0]);
    private static final long serialVersionUID = 1L;
    private static final Object XMP_USER_OBJECT = Bundle.getString(MiscMetadataTreeModel.class, "MiscMetadataTreeModel.XmpNode.DisplayName", new Object[0]);
    private static final Set<MetaDataValue> XMP_META_DATA_VALUES = new LinkedHashSet<MetaDataValue>();
    private static final Set<MetaDataValue> EXIF_META_DATA_VALUES = new LinkedHashSet<MetaDataValue>();
    private final boolean onlyXmp;
    private final DefaultMutableTreeNode ROOT;
    private final ImageFilesRepository repo = Lookup.getDefault().lookup(ImageFilesRepository.class);

    public MiscMetadataTreeModel(boolean onlyXmp) {
        super(new DefaultMutableTreeNode(Bundle.getString(MiscMetadataTreeModel.class, "MiscMetadataTreeModel.Root.DisplayName", new Object[0])));
        this.onlyXmp = onlyXmp;
        this.ROOT = (DefaultMutableTreeNode)this.getRoot();
        if (!onlyXmp) {
            this.addMetaDataValueNodes(EXIF_USER_OBJECT, EXIF_META_DATA_VALUES);
        }
        this.addMetaDataValueNodes(XMP_USER_OBJECT, XMP_META_DATA_VALUES);
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    public boolean isOnlyXmp() {
        return this.onlyXmp;
    }

    public static Set<MetaDataValue> getExifMetaDataValues() {
        return new LinkedHashSet<MetaDataValue>(EXIF_META_DATA_VALUES);
    }

    public static Set<MetaDataValue> getXmpMetaDataValues() {
        return new LinkedHashSet<MetaDataValue>(XMP_META_DATA_VALUES);
    }

    private void addMetaDataValueNodes(Object userObject, Set<MetaDataValue> metaDataValues) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(userObject);
        for (MetaDataValue mdValue : metaDataValues) {
            DefaultMutableTreeNode mdValueNode = new DefaultMutableTreeNode(mdValue);
            this.addChildren(mdValueNode, this.repo.findAllDistinctMetaDataValues(mdValue), mdValue.getValueType());
            node.add(mdValueNode);
        }
        this.ROOT.add(node);
    }

    private void addChildren(DefaultMutableTreeNode parentNode, Set<String> data, MetaDataValue.ValueType dataType) {
        for (String string : this.getTrimmedStrigns(data)) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode();
            if (dataType.equals((Object)MetaDataValue.ValueType.STRING)) {
                node.setUserObject(string);
            } else if (dataType.equals((Object)MetaDataValue.ValueType.SMALLINT)) {
                node.setUserObject(Short.valueOf(string));
            } else if (dataType.equals((Object)MetaDataValue.ValueType.REAL)) {
                node.setUserObject(Double.valueOf(string));
            } else if (dataType.equals((Object)MetaDataValue.ValueType.BIGINT)) {
                node.setUserObject(Long.valueOf(string));
            } else assert (false) : "Unregognized data type: " + (Object)((Object)dataType);
            parentNode.add(node);
        }
    }

    private Collection<String> getTrimmedStrigns(Collection<? extends String> strings) {
        LinkedHashSet<String> trimmedStrings = new LinkedHashSet<String>();
        for (String string : strings) {
            trimmedStrings.add(string.trim());
        }
        return trimmedStrings;
    }

    private void checkDeleted(Xmp xmp) {
        for (MetaDataValue xmpMdValue : XMP_META_DATA_VALUES) {
            Object value = xmp.getValue(xmpMdValue);
            if (value == null) continue;
            this.checkDeleted(xmpMdValue, value);
        }
    }

    private void checkDeleted(Exif exif) {
        String lens;
        double f;
        short iso;
        String recordingEquipment = exif.getRecordingEquipment();
        if (recordingEquipment != null) {
            this.checkDeleted(ExifRecordingEquipmentMetaDataValue.INSTANCE, recordingEquipment);
        }
        if ((iso = exif.getIsoSpeedRatings()) > 0) {
            this.checkDeleted(ExifIsoSpeedRatingsMetaDataValue.INSTANCE, iso);
        }
        if ((f = exif.getFocalLength()) > 0.0) {
            this.checkDeleted(ExifFocalLengthMetaDataValue.INSTANCE, f);
        }
        if ((lens = exif.getLens()) != null) {
            this.checkDeleted(ExifLensMetaDataValue.INSTANCE, lens);
        }
    }

    private void checkDeleted(MetaDataValue mdValue, Object userObject) {
        DefaultMutableTreeNode child;
        DefaultMutableTreeNode node = this.findNodeWithUserObject(this.ROOT, mdValue);
        if (node != null && !this.repo.existsMetaDataValue(userObject, mdValue) && (child = this.findNodeWithUserObject(node, userObject)) != null) {
            int index = node.getIndex(child);
            node.remove(index);
            this.nodesWereRemoved(node, new int[]{index}, new Object[]{child});
        }
    }

    private void checkInserted(Xmp xmp) {
        for (MetaDataValue xmpMdValue : XMP_META_DATA_VALUES) {
            Object value = xmp.getValue(xmpMdValue);
            if (value == null) continue;
            this.checkInserted(xmpMdValue, value);
        }
    }

    private void checkInserted(Exif exif) {
        String lens;
        double f;
        short iso;
        String recordingEquipment = exif.getRecordingEquipment();
        if (recordingEquipment != null) {
            this.checkInserted(ExifRecordingEquipmentMetaDataValue.INSTANCE, recordingEquipment);
        }
        if ((iso = exif.getIsoSpeedRatings()) > 0) {
            this.checkInserted(ExifIsoSpeedRatingsMetaDataValue.INSTANCE, iso);
        }
        if ((f = exif.getFocalLength()) > 0.0) {
            this.checkInserted(ExifFocalLengthMetaDataValue.INSTANCE, f);
        }
        if ((lens = exif.getLens()) != null) {
            this.checkInserted(ExifLensMetaDataValue.INSTANCE, lens);
        }
    }

    private void checkInserted(MetaDataValue mdValue, Object userObject) {
        DefaultMutableTreeNode child;
        DefaultMutableTreeNode node = this.findNodeWithUserObject(this.ROOT, mdValue);
        if (node != null && (child = this.findNodeWithUserObject(node, userObject)) == null) {
            DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(userObject);
            node.add(newChild);
            this.nodesWereInserted(node, new int[]{node.getIndex(newChild)});
        }
    }

    private DefaultMutableTreeNode findNodeWithUserObject(DefaultMutableTreeNode rootNode, Object userObject) {
        ArrayList foundNodes = new ArrayList(1);
        TreeUtil.addNodesUserWithObject(foundNodes, rootNode, userObject, 1);
        return foundNodes.size() > 0 ? (DefaultMutableTreeNode)foundNodes.get(0) : null;
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        this.checkDeleted(evt.getOldXmp());
        this.checkInserted(evt.getUpdatedXmp());
    }

    @EventSubscriber(eventClass=XmpInsertedEvent.class)
    public void xmpInserted(XmpInsertedEvent evt) {
        this.checkInserted(evt.getXmp());
    }

    @EventSubscriber(eventClass=XmpDeletedEvent.class)
    public void xmpDeleted(XmpDeletedEvent evt) {
        this.checkDeleted(evt.getXmp());
    }

    @EventSubscriber(eventClass=DcSubjectDeletedEvent.class)
    public void dcSubjectDeleted(DcSubjectDeletedEvent evt) {
        this.checkDeleted(XmpDcSubjectsSubjectMetaDataValue.INSTANCE, evt.getDcSubject());
    }

    @EventSubscriber(eventClass=DcSubjectInsertedEvent.class)
    public void dcSubjectInserted(DcSubjectInsertedEvent evt) {
        this.checkInserted(XmpDcSubjectsSubjectMetaDataValue.INSTANCE, evt.getDcSubject());
    }

    @EventSubscriber(eventClass=ExifInsertedEvent.class)
    public void exifInserted(ExifInsertedEvent evt) {
        this.checkInserted(evt.getExif());
    }

    @EventSubscriber(eventClass=ExifUpdatedEvent.class)
    public void exifUpdated(ExifUpdatedEvent evt) {
        this.checkDeleted(evt.getOldExif());
        this.checkInserted(evt.getUpdatedExif());
    }

    @EventSubscriber(eventClass=ExifDeletedEvent.class)
    public void exifDeleted(ExifDeletedEvent evt) {
        this.checkDeleted(evt.getExif());
    }

    static {
        EXIF_META_DATA_VALUES.add(ExifRecordingEquipmentMetaDataValue.INSTANCE);
        EXIF_META_DATA_VALUES.add(ExifFocalLengthMetaDataValue.INSTANCE);
        EXIF_META_DATA_VALUES.add(ExifLensMetaDataValue.INSTANCE);
        EXIF_META_DATA_VALUES.add(ExifIsoSpeedRatingsMetaDataValue.INSTANCE);
        XMP_META_DATA_VALUES.add(XmpIptc4xmpcoreLocationMetaDataValue.INSTANCE);
        XMP_META_DATA_VALUES.add(XmpPhotoshopCityMetaDataValue.INSTANCE);
        XMP_META_DATA_VALUES.add(XmpPhotoshopStateMetaDataValue.INSTANCE);
        XMP_META_DATA_VALUES.add(XmpPhotoshopCountryMetaDataValue.INSTANCE);
        XMP_META_DATA_VALUES.add(XmpDcCreatorMetaDataValue.INSTANCE);
        XMP_META_DATA_VALUES.add(XmpDcRightsMetaDataValue.INSTANCE);
        XMP_META_DATA_VALUES.add(XmpPhotoshopSourceMetaDataValue.INSTANCE);
        XMP_META_DATA_VALUES.add(XmpRatingMetaDataValue.INSTANCE);
    }
}

