/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.miscmetadata;

import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.SelectedFilesMetaDataEditor;
import org.jphototagger.domain.metadata.xmp.XmpMetaDataValues;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.swing.PopupMenuTree;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.jphototagger.program.module.miscmetadata.MiscMetadataUtil;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class MiscMetadataPopupMenu
extends PopupMenuTree {
    private static final long serialVersionUID = 1L;
    private static final List<MetaDataValue> XMP_META_DATA_VALUES = XmpMetaDataValues.get();
    private JMenuItem itemAddToEditPanel;
    private JMenuItem itemCollapseAllSubitems;
    private JMenuItem itemDelete;
    private JMenuItem itemExpandAllSubitems;
    private JMenuItem itemRemoveFromEditPanel;
    private JMenuItem itemRename;

    public MiscMetadataPopupMenu(JTree tree) {
        super(tree);
        this.setAccelerators();
        this.setExpandAllSubItems(this.itemExpandAllSubitems);
        this.setCollapseAllSubItems(this.itemCollapseAllSubitems);
    }

    private void createMenuItems() {
        this.itemDelete = new JMenuItem(Bundle.getString(MiscMetadataPopupMenu.class, "MiscMetadataPopupMenu.DisplayName.ItemDelete", new Object[0]), AppLookAndFeel.ICON_DELETE);
        this.itemExpandAllSubitems = new JMenuItem(Bundle.getString(MiscMetadataPopupMenu.class, "MiscMetadataPopupMenu.ItemExpand", new Object[0]));
        this.itemRename = new JMenuItem(Bundle.getString(MiscMetadataPopupMenu.class, "MiscMetadataPopupMenu.DisplayName.ItemRename", new Object[0]), AppLookAndFeel.ICON_RENAME);
        this.itemCollapseAllSubitems = new JMenuItem(Bundle.getString(MiscMetadataPopupMenu.class, "MiscMetadataPopupMenu.ItemCollapse", new Object[0]));
        this.itemAddToEditPanel = new JMenuItem(Bundle.getString(MiscMetadataPopupMenu.class, "MiscMetadataPopupMenu.DisplayName.ActionAddToEditPanel", new Object[0]));
        this.itemRemoveFromEditPanel = new JMenuItem(Bundle.getString(MiscMetadataPopupMenu.class, "MiscMetadataPopupMenu.DisplayName.ActionRemoveFromEditPanel", new Object[0]));
    }

    @Override
    protected void setMenuItemsEnabled(List<TreePath> selTreePaths) {
        if (selTreePaths == null) {
            throw new NullPointerException("selTreePaths == null");
        }
        boolean xmpValues = this.allNodesXmpValues(selTreePaths);
        boolean editable = this.isEditable();
        this.itemDelete.setEnabled(xmpValues);
        this.itemRename.setEnabled(xmpValues);
        this.itemAddToEditPanel.setEnabled(xmpValues && editable);
        this.itemRemoveFromEditPanel.setEnabled(xmpValues && editable);
    }

    private boolean isEditable() {
        SelectedFilesMetaDataEditor editor = Lookup.getDefault().lookup(SelectedFilesMetaDataEditor.class);
        return editor.isEditable();
    }

    private boolean allNodesXmpValues(List<TreePath> treePaths) {
        for (TreePath treePath : treePaths) {
            if (this.isNodeXmpValue(treePath)) continue;
            return false;
        }
        return true;
    }

    private boolean isNodeXmpValue(TreePath treePath) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return MiscMetadataUtil.isParentUserObjectAMetaDataValue(node, XMP_META_DATA_VALUES);
    }

    public JMenuItem getItemDelete() {
        return this.itemDelete;
    }

    public JMenuItem getItemRename() {
        return this.itemRename;
    }

    public JMenuItem getItemAddToEditPanel() {
        return this.itemAddToEditPanel;
    }

    public JMenuItem getItemRemoveFromEditPanel() {
        return this.itemRemoveFromEditPanel;
    }

    @Override
    protected void addMenuItems() {
        this.createMenuItems();
        this.add(this.itemRename);
        this.add(this.itemDelete);
        this.add(new JPopupMenu.Separator());
        this.add(this.itemAddToEditPanel);
        this.add(this.itemRemoveFromEditPanel);
        this.add(new JPopupMenu.Separator());
        this.add(this.itemExpandAllSubitems);
        this.add(this.itemCollapseAllSubitems);
        this.addActionsToTree();
    }

    private void addActionsToTree() {
        JTree tree = GUI.getAppPanel().getTreeMiscMetadata();
        InputMap inputMap = tree.getInputMap();
        ActionMap actionMap = tree.getActionMap();
        Action actionRename = this.itemRename.getAction();
        Action actionDelete = this.itemDelete.getAction();
        String keyActionRename = "actionRename";
        String keyActionDelete = "actionDelete";
        inputMap.put(KeyEventUtil.getKeyStroke(113), keyActionRename);
        actionMap.put(keyActionRename, actionRename);
        inputMap.put(KeyEventUtil.getKeyStroke(127), keyActionDelete);
        actionMap.put(keyActionDelete, actionDelete);
    }

    private void setAccelerators() {
        this.itemDelete.setAccelerator(KeyEventUtil.getKeyStroke(127));
        this.itemRename.setAccelerator(KeyEventUtil.getKeyStroke(113));
        this.itemAddToEditPanel.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(66));
        this.itemRemoveFromEditPanel.setAccelerator(KeyEventUtil.getKeyStroke(8));
    }
}

