/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.metadatatemplates;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import org.jphototagger.domain.repository.MetadataTemplatesRepository;
import org.jphototagger.domain.templates.MetadataTemplate;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.misc.InputHelperDialog;
import org.jphototagger.program.module.metadatatemplates.MetadataTemplateController;
import org.jphototagger.program.module.metadatatemplates.MetadataTemplateUtil;
import org.jphototagger.program.module.metadatatemplates.MetadataTemplatesPopupMenu;
import org.openide.util.Lookup;

public final class RenameMetadataTemplateController
extends MetadataTemplateController {
    private final MetadataTemplatesRepository repo = Lookup.getDefault().lookup(MetadataTemplatesRepository.class);

    public RenameMetadataTemplateController() {
        this.listen();
    }

    private void listen() {
        this.listenToActionsOf(MetadataTemplatesPopupMenu.INSTANCE.getItemRename());
        this.getRenameButton().addActionListener(this);
    }

    private JButton getRenameButton() {
        return InputHelperDialog.INSTANCE.getPanelMetaDataTemplates().getButtonRename();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.getRenameButton() && this.isInputHelperListItemSelected()) {
            this.action(this.getTemplateOfInputHelperList());
        } else {
            super.actionPerformed(evt);
        }
    }

    @Override
    protected boolean myKey(KeyEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return evt.getKeyCode() == 113;
    }

    @Override
    protected boolean myAction(ActionEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return evt.getSource() == MetadataTemplatesPopupMenu.INSTANCE.getItemRename();
    }

    @Override
    protected void action(MetadataTemplate template) {
        if (template == null) {
            throw new NullPointerException("template == null");
        }
        String fromName = template.getName();
        String toName = MetadataTemplateUtil.getNewTemplateName(fromName);
        if (toName != null && !this.repo.updateRenameMetadataTemplate(fromName, toName)) {
            String message = Bundle.getString(RenameMetadataTemplateController.class, "RenameMetadataTemplateController.Error", fromName);
            MessageDisplayer.error(null, message);
        }
        this.focusList();
    }
}

