/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.metadatatemplates;

import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.repository.MetadataTemplatesRepository;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.domain.repository.event.metadatatemplates.MetadataTemplateDeletedEvent;
import org.jphototagger.domain.repository.event.metadatatemplates.MetadataTemplateInsertedEvent;
import org.jphototagger.domain.repository.event.metadatatemplates.MetadataTemplateRenamedEvent;
import org.jphototagger.domain.repository.event.metadatatemplates.MetadataTemplateUpdatedEvent;
import org.jphototagger.domain.templates.MetadataTemplate;
import org.openide.util.Lookup;

public final class MetadataTemplatesComboBoxModel
extends DefaultComboBoxModel<Object> {
    private static final long serialVersionUID = 1L;
    private final MetadataTemplatesRepository templateRepo = Lookup.getDefault().lookup(MetadataTemplatesRepository.class);

    public MetadataTemplatesComboBoxModel() {
        this.addElements();
        this.listen();
    }

    private void addElements() {
        Repository repo = Lookup.getDefault().lookup(Repository.class);
        if (repo == null || !repo.isInit()) {
            return;
        }
        List<MetadataTemplate> templates = this.templateRepo.findAllMetadataTemplates();
        for (MetadataTemplate template : templates) {
            this.addElement(template);
        }
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    @EventSubscriber(eventClass=MetadataTemplateDeletedEvent.class)
    public void templateDeleted(MetadataTemplateDeletedEvent evt) {
        this.removeElement(evt.getTemplate());
    }

    @EventSubscriber(eventClass=MetadataTemplateInsertedEvent.class)
    public void templateInserted(MetadataTemplateInsertedEvent evt) {
        this.addElement(evt.getTemplate());
    }

    @EventSubscriber(eventClass=MetadataTemplateUpdatedEvent.class)
    public void templateUpdated(MetadataTemplateUpdatedEvent evt) {
        this.updateTemplate(evt.getUpdatedTemplate());
    }

    @EventSubscriber(eventClass=MetadataTemplateRenamedEvent.class)
    public void templateRenamed(MetadataTemplateRenamedEvent evt) {
        this.renameTemplate(evt.getFromName(), evt.getToName());
    }

    private void updateTemplate(MetadataTemplate updatedTemplate) {
        int index = this.indexOfTemplate(updatedTemplate.getName());
        if (index >= 0) {
            MetadataTemplate template = (MetadataTemplate)this.getElementAt(index);
            template.updateValuesWithTemplate(updatedTemplate);
            this.fireContentsChanged(this, index, index);
        }
    }

    private void renameTemplate(String fromName, String toName) {
        int index = this.indexOfTemplate(fromName);
        if (index >= 0) {
            MetadataTemplate template = (MetadataTemplate)this.getElementAt(index);
            template.setName(toName);
            this.fireContentsChanged(this, index, index);
        }
    }

    private int indexOfTemplate(String name) {
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            Object o = this.getElementAt(i);
            if (!(o instanceof MetadataTemplate) || !((MetadataTemplate)o).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }
}

