/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.metadatatemplates;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.program.module.metadatatemplates.MetadataTemplatesListCellRenderer;
import org.jphototagger.program.module.thumbnails.ThumbnailsPanel;
import org.jphototagger.program.resource.GUI;

public class MetaDataTemplatesPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JButton buttonAdd;
    private JButton buttonAddToSelImages;
    private JButton buttonDelete;
    private JButton buttonEdit;
    private JButton buttonRename;
    private JXList list;
    private JPanel panelButtons;
    private JPanel panelModifyButtons;
    private JScrollPane scrollPane;

    public MetaDataTemplatesPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.list.addListSelectionListener(this);
        MnemonicUtil.setMnemonics(this);
        AnnotationProcessor.process(this);
    }

    public JXList getList() {
        return this.list;
    }

    public JButton getButtonAdd() {
        return this.buttonAdd;
    }

    public JButton getButtonDelete() {
        return this.buttonDelete;
    }

    public JButton getButtonEdit() {
        return this.buttonEdit;
    }

    public JButton getButtonRename() {
        return this.buttonRename;
    }

    public JButton getButtonAddToSelImages() {
        return this.buttonAddToSelImages;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            boolean selected = this.list.getSelectedIndex() >= 0;
            this.buttonDelete.setEnabled(selected);
            this.buttonEdit.setEnabled(selected);
            this.buttonRename.setEnabled(selected);
            ThumbnailsPanel tnPanel = GUI.getThumbnailsPanel();
            this.buttonAddToSelImages.setEnabled(selected && tnPanel.isAFileSelected());
        }
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        ThumbnailsPanel tnPanel = GUI.getThumbnailsPanel();
        this.buttonAddToSelImages.setEnabled(this.list.getSelectedIndex() >= 0 && tnPanel.isAFileSelected());
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.list = new JXList();
        this.panelButtons = new JPanel();
        this.panelModifyButtons = new JPanel();
        this.buttonRename = new JButton();
        this.buttonAdd = new JButton();
        this.buttonEdit = new JButton();
        this.buttonDelete = new JButton();
        this.buttonAddToSelImages = new JButton();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.scrollPane.setName("scrollPane");
        this.list.setSelectionMode(0);
        this.list.setCellRenderer((ListCellRenderer)new MetadataTemplatesListCellRenderer());
        this.list.setDragEnabled(true);
        this.list.setName("list");
        this.scrollPane.setViewportView(this.list);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.panelButtons.setName("panelButtons");
        this.panelButtons.setLayout(new GridBagLayout());
        this.panelModifyButtons.setName("panelModifyButtons");
        this.panelModifyButtons.setLayout(new GridLayout(2, 0));
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/metadatatemplates/Bundle");
        this.buttonRename.setText(bundle.getString("MetaDataTemplatesPanel.buttonRename.text"));
        this.buttonRename.setEnabled(false);
        this.buttonRename.setName("buttonRename");
        this.panelModifyButtons.add(this.buttonRename);
        this.buttonAdd.setText(bundle.getString("MetaDataTemplatesPanel.buttonAdd.text"));
        this.buttonAdd.setName("buttonAdd");
        this.panelModifyButtons.add(this.buttonAdd);
        this.buttonEdit.setText(bundle.getString("MetaDataTemplatesPanel.buttonEdit.text"));
        this.buttonEdit.setEnabled(false);
        this.buttonEdit.setName("buttonEdit");
        this.panelModifyButtons.add(this.buttonEdit);
        this.buttonDelete.setText(bundle.getString("MetaDataTemplatesPanel.buttonDelete.text"));
        this.buttonDelete.setEnabled(false);
        this.buttonDelete.setName("buttonDelete");
        this.panelModifyButtons.add(this.buttonDelete);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.panelButtons.add((Component)this.panelModifyButtons, gridBagConstraints);
        this.buttonAddToSelImages.setText(bundle.getString("MetaDataTemplatesPanel.buttonAddToSelImages.text"));
        this.buttonAddToSelImages.setEnabled(false);
        this.buttonAddToSelImages.setName("buttonAddToSelImages");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.panelButtons.add((Component)this.buttonAddToSelImages, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.panelButtons, gridBagConstraints);
    }
}

