/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.metadatatemplates;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpDcCreatorMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcDescriptionMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcRightsMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcTitleMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpIptc4XmpCoreDateCreatedMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpIptc4xmpcoreLocationMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopAuthorspositionMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopCaptionwriterMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopCityMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopCountryMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopCreditMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopHeadlineMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopInstructionsMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopSourceMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopStateMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopTransmissionReferenceMetaDataValue;
import org.jphototagger.domain.text.TextEntry;
import org.jphototagger.program.module.editmetadata.EditRepeatableTextEntryPanel;
import org.jphototagger.program.module.editmetadata.EditTextEntryPanel;
import org.openide.util.Lookup;

public class EditXmpPanel
extends JPanel
implements FocusListener {
    private static final long serialVersionUID = 1L;
    private final List<TextEntry> textEntries = new ArrayList<TextEntry>(18);
    private Component firstInputComponent;
    private Component lastInputComponent;
    private Component lastFocussedComponent;
    private transient Xmp xmp = new Xmp();
    private EditTextEntryPanel panelDcCreator;
    private EditTextEntryPanel panelDcDescription;
    private EditTextEntryPanel panelDcRights;
    private EditRepeatableTextEntryPanel panelDcSubjects;
    private EditTextEntryPanel panelDcTitle;
    private JPanel panelFill;
    private EditTextEntryPanel panelIptc4XmpCoreDateCreated;
    private EditTextEntryPanel panelIptc4xmpcoreLocation;
    private EditTextEntryPanel panelPhotoshopAuthorsposition;
    private EditTextEntryPanel panelPhotoshopCaptionwriter;
    private EditTextEntryPanel panelPhotoshopCity;
    private EditTextEntryPanel panelPhotoshopCountry;
    private EditTextEntryPanel panelPhotoshopCredit;
    private EditTextEntryPanel panelPhotoshopHeadline;
    private EditTextEntryPanel panelPhotoshopInstructions;
    private EditTextEntryPanel panelPhotoshopSource;
    private EditTextEntryPanel panelPhotoshopState;
    private EditTextEntryPanel panelPhotoshopTransmissionReference;

    public EditXmpPanel() {
        this.init();
    }

    private void init() {
        this.initComponents();
        this.addTextEntries();
        this.setAutocomplete();
        this.addAsFocusListener();
        this.firstInputComponent = this.panelDcSubjects.textAreaInput;
        this.lastInputComponent = this.panelPhotoshopCaptionwriter.getInputComponents().get(0);
        this.lastFocussedComponent = this.firstInputComponent;
        this.firstInputComponent.requestFocusInWindow();
        this.panelDcSubjects.setBundleKeyPosRenameDialog("EditXmpPanel.Keywords.RenameDialog.Pos");
    }

    private void addTextEntries() {
        for (Component c : this.getComponents()) {
            if (!(c instanceof TextEntry)) continue;
            this.textEntries.add((TextEntry)((Object)c));
        }
    }

    private void setAutocomplete() {
        if (this.isAutocomplete()) {
            for (TextEntry textEntry : this.textEntries) {
                textEntry.enableAutocomplete();
            }
        }
    }

    private boolean isAutocomplete() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs == null ? false : (prefs.containsKey("UserSettings.EnableAutoComplete") ? prefs.getBoolean("UserSettings.EnableAutoComplete") : true);
    }

    public void focusLastFocuessedComponent() {
        if (this.lastFocussedComponent != null) {
            this.lastFocussedComponent.requestFocusInWindow();
        }
    }

    public void setXmp(Xmp xmp) {
        if (xmp == null) {
            throw new NullPointerException("xmp == null");
        }
        this.xmp = xmp;
        this.setXmpToInputComponents();
    }

    public void setInputToXmp() {
        this.xmp.clear();
        for (TextEntry textEntry : this.textEntries) {
            MetaDataValue value = textEntry.getMetaDataValue();
            if (textEntry instanceof EditRepeatableTextEntryPanel) {
                for (String text : ((EditRepeatableTextEntryPanel)textEntry).getRepeatableText()) {
                    this.xmp.setValue(value, text);
                }
                this.xmp.setValue(value, textEntry.getText());
                continue;
            }
            this.xmp.setValue(value, textEntry.getText());
        }
    }

    private void setXmpToInputComponents() {
        for (TextEntry textEntry : this.textEntries) {
            Object value = this.xmp.getValue(textEntry.getMetaDataValue());
            if (value == null) continue;
            if (textEntry instanceof EditRepeatableTextEntryPanel) {
                ((EditRepeatableTextEntryPanel)textEntry).setTexts((Collection)value);
                continue;
            }
            textEntry.setText(value.toString());
        }
    }

    public boolean isDirty() {
        for (TextEntry textEntry : this.textEntries) {
            if (!textEntry.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void setDirty(boolean dirty) {
        for (TextEntry textEntry : this.textEntries) {
            textEntry.setDirty(dirty);
        }
    }

    public Xmp getXmp() {
        return this.xmp;
    }

    private void addAsFocusListener() {
        for (TextEntry textEntry : this.textEntries) {
            for (Component c : textEntry.getInputComponents()) {
                c.addFocusListener(this);
            }
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean requested = super.requestFocusInWindow();
        this.focusLastFocuessedComponent();
        return requested;
    }

    @Override
    public void focusGained(FocusEvent evt) {
        this.lastFocussedComponent = evt.getComponent();
        if (this.lastFocussedComponent instanceof JTextComponent) {
            ((JTextComponent)this.lastFocussedComponent).selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        Component c = evt.getComponent();
        if (c == this.lastInputComponent) {
            this.firstInputComponent.requestFocusInWindow();
        }
        if (c instanceof JTextComponent) {
            ((JTextComponent)c).select(0, 0);
        }
    }

    private void scrollToVisible(Component c) {
        if (c == null) {
            return;
        }
        TextEntry textEntry = c instanceof TextEntry ? (TextEntry)((Object)c) : null;
        for (Container parent = c.getParent(); textEntry == null && parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TextEntry)) continue;
            textEntry = (TextEntry)((Object)parent);
        }
        if (textEntry != null) {
            this.scrollRectToVisible(((Component)((Object)textEntry)).getBounds());
        }
    }

    private void initComponents() {
        this.panelDcSubjects = new EditRepeatableTextEntryPanel();
        this.panelDcTitle = new EditTextEntryPanel(XmpDcTitleMetaDataValue.INSTANCE);
        this.panelDcDescription = new EditTextEntryPanel(XmpDcDescriptionMetaDataValue.INSTANCE);
        this.panelPhotoshopHeadline = new EditTextEntryPanel(XmpPhotoshopHeadlineMetaDataValue.INSTANCE);
        this.panelIptc4XmpCoreDateCreated = new EditTextEntryPanel(XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE);
        this.panelIptc4xmpcoreLocation = new EditTextEntryPanel(XmpIptc4xmpcoreLocationMetaDataValue.INSTANCE);
        this.panelPhotoshopCity = new EditTextEntryPanel(XmpPhotoshopCityMetaDataValue.INSTANCE);
        this.panelPhotoshopState = new EditTextEntryPanel(XmpPhotoshopStateMetaDataValue.INSTANCE);
        this.panelPhotoshopCountry = new EditTextEntryPanel(XmpPhotoshopCountryMetaDataValue.INSTANCE);
        this.panelPhotoshopAuthorsposition = new EditTextEntryPanel(XmpPhotoshopAuthorspositionMetaDataValue.INSTANCE);
        this.panelDcCreator = new EditTextEntryPanel(XmpDcCreatorMetaDataValue.INSTANCE);
        this.panelDcRights = new EditTextEntryPanel(XmpDcRightsMetaDataValue.INSTANCE);
        this.panelPhotoshopCredit = new EditTextEntryPanel(XmpPhotoshopCreditMetaDataValue.INSTANCE);
        this.panelPhotoshopSource = new EditTextEntryPanel(XmpPhotoshopSourceMetaDataValue.INSTANCE);
        this.panelPhotoshopTransmissionReference = new EditTextEntryPanel(XmpPhotoshopTransmissionReferenceMetaDataValue.INSTANCE);
        this.panelPhotoshopInstructions = new EditTextEntryPanel(XmpPhotoshopInstructionsMetaDataValue.INSTANCE);
        this.panelPhotoshopCaptionwriter = new EditTextEntryPanel(XmpPhotoshopCaptionwriterMetaDataValue.INSTANCE);
        this.panelFill = new JPanel();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.panelDcSubjects.setName("panelDcSubjects");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelDcSubjects, gridBagConstraints);
        this.panelDcTitle.setName("panelDcTitle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelDcTitle, gridBagConstraints);
        this.panelDcDescription.setName("panelDcDescription");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelDcDescription, gridBagConstraints);
        this.panelPhotoshopHeadline.setName("panelPhotoshopHeadline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelPhotoshopHeadline, gridBagConstraints);
        this.panelIptc4XmpCoreDateCreated.setName("panelIptc4XmpCoreDateCreated");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelIptc4XmpCoreDateCreated, gridBagConstraints);
        this.panelIptc4xmpcoreLocation.setName("panelIptc4xmpcoreLocation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelIptc4xmpcoreLocation, gridBagConstraints);
        this.panelPhotoshopCity.setName("panelPhotoshopCity");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelPhotoshopCity, gridBagConstraints);
        this.panelPhotoshopState.setName("panelPhotoshopState");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelPhotoshopState, gridBagConstraints);
        this.panelPhotoshopCountry.setName("panelPhotoshopCountry");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelPhotoshopCountry, gridBagConstraints);
        this.panelPhotoshopAuthorsposition.setName("panelPhotoshopAuthorsposition");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelPhotoshopAuthorsposition, gridBagConstraints);
        this.panelDcCreator.setName("panelDcCreator");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelDcCreator, gridBagConstraints);
        this.panelDcRights.setName("panelDcRights");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelDcRights, gridBagConstraints);
        this.panelPhotoshopCredit.setName("panelPhotoshopCredit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelPhotoshopCredit, gridBagConstraints);
        this.panelPhotoshopSource.setName("panelPhotoshopSource");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelPhotoshopSource, gridBagConstraints);
        this.panelPhotoshopTransmissionReference.setName("panelPhotoshopTransmissionReference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelPhotoshopTransmissionReference, gridBagConstraints);
        this.panelPhotoshopInstructions.setName("panelPhotoshopInstructions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelPhotoshopInstructions, gridBagConstraints);
        this.panelPhotoshopCaptionwriter.setName("panelPhotoshopCaptionwriter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelPhotoshopCaptionwriter, gridBagConstraints);
        GroupLayout panelFillLayout = new GroupLayout(this.panelFill);
        this.panelFill.setLayout(panelFillLayout);
        panelFillLayout.setHorizontalGroup(panelFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panelFillLayout.setVerticalGroup(panelFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panelFill, gridBagConstraints);
    }
}

