/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.metadatatemplates;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.templates.MetadataTemplate;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.program.module.metadatatemplates.EditMetaDataTemplateDialog;
import org.jphototagger.program.module.metadatatemplates.EditXmpPanel;
import org.jphototagger.program.module.metadatatemplates.MetadataTemplatesComboBoxModel;

public class EditXmpDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final Xmp xmp;
    private boolean accepted;
    private JButton buttonCancel;
    private JButton buttonEditMetadataTemplates;
    private JButton buttonInsertTemplate;
    private JButton buttonOk;
    private JComboBox<Object> comboBoxTemplates;
    private JLabel labelTemplates;
    private JPanel panelContent;
    private EditXmpPanel panelEditXmp;
    private JPanel panelSubmitButtons;
    private JPanel panelTemplates;
    private JScrollPane scrollPanePanelEditXmp;

    public EditXmpDialog() {
        this(new Xmp());
    }

    public EditXmpDialog(Xmp xmp) {
        super(ComponentUtil.findFrameWithIcon(), true);
        if (xmp == null) {
            throw new NullPointerException("xmp == null");
        }
        this.xmp = xmp;
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.panelEditXmp.setXmp(this.xmp);
        this.setButtonInsertTemplateEnabled();
        MnemonicUtil.setMnemonics(this);
    }

    private void setButtonInsertTemplateEnabled() {
        this.buttonInsertTemplate.setEnabled(this.comboBoxTemplates.getSelectedIndex() >= 0);
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public Xmp getXmp() {
        return this.xmp;
    }

    private void insertTemplate() {
        Object selectedItem = this.comboBoxTemplates.getSelectedItem();
        if (selectedItem instanceof MetadataTemplate) {
            this.xmp.setMetaDataTemplate((MetadataTemplate)selectedItem);
            this.panelEditXmp.setXmp(this.xmp);
        }
    }

    private void acceptInputAndDispose() {
        this.accepted = true;
        if (this.panelEditXmp.isDirty()) {
            this.panelEditXmp.setInputToXmp();
        }
        this.dispose();
    }

    private void cancelAndDispose() {
        this.accepted = false;
        this.dispose();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.panelEditXmp.requestFocusInWindow();
        }
        super.setVisible(visible);
    }

    private void editMetadataTemplates() {
        EditMetaDataTemplateDialog dialog = new EditMetaDataTemplateDialog();
        MetadataTemplate t = new MetadataTemplate();
        dialog.setTemplate(t);
        ComponentUtil.show(dialog);
        this.toFront();
    }

    private void initComponents() {
        this.panelContent = new JPanel();
        this.panelTemplates = new JPanel();
        this.labelTemplates = new JLabel();
        this.comboBoxTemplates = new JComboBox();
        this.buttonEditMetadataTemplates = new JButton();
        this.buttonInsertTemplate = new JButton();
        this.scrollPanePanelEditXmp = new JScrollPane();
        this.panelEditXmp = new EditXmpPanel();
        this.panelSubmitButtons = new JPanel();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/metadatatemplates/Bundle");
        this.setTitle(bundle.getString("EditXmpDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.panelContent.setPreferredSize(new Dimension(500, 450));
        this.panelContent.setLayout(new GridBagLayout());
        this.panelTemplates.setLayout(new GridBagLayout());
        this.labelTemplates.setLabelFor(this.comboBoxTemplates);
        this.labelTemplates.setText(bundle.getString("EditXmpDialog.labelTemplates.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelTemplates.add((Component)this.labelTemplates, gridBagConstraints);
        this.comboBoxTemplates.setModel(new MetadataTemplatesComboBoxModel());
        this.comboBoxTemplates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditXmpDialog.this.comboBoxTemplatesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelTemplates.add(this.comboBoxTemplates, gridBagConstraints);
        this.buttonEditMetadataTemplates.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/module/metadatatemplates/add.png")));
        this.buttonEditMetadataTemplates.setToolTipText(bundle.getString("EditXmpDialog.buttonEditMetadataTemplates.toolTipText"));
        this.buttonEditMetadataTemplates.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEditMetadataTemplates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditXmpDialog.this.buttonEditMetadataTemplatesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelTemplates.add((Component)this.buttonEditMetadataTemplates, gridBagConstraints);
        this.buttonInsertTemplate.setText(bundle.getString("EditXmpDialog.buttonInsertTemplate.text"));
        this.buttonInsertTemplate.setEnabled(false);
        this.buttonInsertTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditXmpDialog.this.buttonInsertTemplateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelTemplates.add((Component)this.buttonInsertTemplate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelContent.add((Component)this.panelTemplates, gridBagConstraints);
        this.scrollPanePanelEditXmp.setViewportView(this.panelEditXmp);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add((Component)this.scrollPanePanelEditXmp, gridBagConstraints);
        this.panelSubmitButtons.setLayout(new GridBagLayout());
        this.buttonCancel.setText(bundle.getString("EditXmpDialog.buttonCancel.text"));
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditXmpDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.panelSubmitButtons.add((Component)this.buttonCancel, gridBagConstraints);
        this.buttonOk.setText(bundle.getString("EditXmpDialog.buttonOk.text"));
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditXmpDialog.this.buttonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelSubmitButtons.add((Component)this.buttonOk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add((Component)this.panelSubmitButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.panelContent, gridBagConstraints);
        this.pack();
    }

    private void buttonInsertTemplateActionPerformed(ActionEvent evt) {
        this.insertTemplate();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.acceptInputAndDispose();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancelAndDispose();
    }

    private void comboBoxTemplatesActionPerformed(ActionEvent evt) {
        this.setButtonInsertTemplateEnabled();
    }

    private void buttonEditMetadataTemplatesActionPerformed(ActionEvent evt) {
        this.editMetadataTemplates();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditXmpDialog dialog = new EditXmpDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

