/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.metadatatemplates;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.repository.MetadataTemplatesRepository;
import org.jphototagger.domain.templates.MetadataTemplate;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.misc.InputHelperDialog;
import org.jphototagger.program.module.metadatatemplates.EditXmpPanel;
import org.jphototagger.program.view.ViewUtil;
import org.openide.util.Lookup;

public class EditMetaDataTemplateDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private transient MetadataTemplate template;
    private final transient Xmp xmp = new Xmp();
    private final MetadataTemplatesRepository repo = Lookup.getDefault().lookup(MetadataTemplatesRepository.class);
    private JButton buttonCancel;
    private JButton buttonSave;
    private JLabel labelName;
    private JPanel panelButtons;
    private JPanel panelContent;
    private JPanel panelName;
    private EditXmpPanel panelXmpEdit;
    private JScrollPane scrollPane;
    private JTextField textFieldName;

    public EditMetaDataTemplateDialog() {
        super(InputHelperDialog.INSTANCE, true);
        this.initComponents();
        this.setMnemonics();
    }

    private void setMnemonics() {
        MnemonicUtil.setMnemonics(this);
        ViewUtil.setDisplayedMnemonicsToLabels(this.panelXmpEdit, Collections.emptyList(), Character.valueOf((char)this.buttonCancel.getMnemonic()), Character.valueOf((char)this.buttonSave.getMnemonic()), Character.valueOf((char)this.labelName.getDisplayedMnemonic()));
    }

    public void setTemplate(MetadataTemplate template) {
        if (template == null) {
            throw new NullPointerException("template == null");
        }
        this.template = template;
        String name = template.getName();
        if (name != null) {
            this.textFieldName.setText(name);
        }
        this.textFieldName.setEnabled(name == null);
        this.setTitle();
    }

    private void setTitle() {
        String title = this.templateHasName() ? Bundle.getString(EditMetaDataTemplateDialog.class, "EditMetaDataTemplateDialog.Title.Edit", new Object[0]) : Bundle.getString(EditMetaDataTemplateDialog.class, "EditMetaDataTemplateDialog.Title.New", new Object[0]);
        this.setTitle(title);
    }

    private boolean templateHasName() {
        return this.template.getName() != null && !this.template.getName().trim().isEmpty();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.templateToInput();
        }
        super.setVisible(visible);
    }

    private void templateToInput() {
        assert (this.template != null) : "Template was not set via #setTemplate()!";
        this.xmp.setMetaDataTemplate(this.template);
        this.panelXmpEdit.setXmp(this.xmp);
    }

    @Override
    protected void escape() {
        this.checkSave();
        super.escape();
    }

    private void checkSave() {
        String message = Bundle.getString(EditMetaDataTemplateDialog.class, "EditMetaDataTemplateDialog.Confirm.CheckSave", new Object[0]);
        if (this.panelXmpEdit.isDirty() && MessageDisplayer.confirmYesNo(this, message)) {
            this.save();
        }
    }

    private void save() {
        if (this.panelXmpEdit.isDirty() && this.checkSaveTemplateName()) {
            this.panelXmpEdit.setInputToXmp();
            this.template.setXmp(this.xmp);
            if (this.repo.saveOrUpdateMetadataTemplate(this.template)) {
                this.panelXmpEdit.setDirty(false);
            } else {
                String message = Bundle.getString(EditMetaDataTemplateDialog.class, "EditMetaDataTemplateDialog.Error.Save", new Object[0]);
                MessageDisplayer.error(this, message);
            }
            this.setVisible(false);
        }
    }

    private boolean checkSaveTemplateName() {
        if (!this.templateHasName()) {
            boolean textfieldHasName;
            String name = this.textFieldName.getText();
            boolean bl = textfieldHasName = name != null && !name.trim().isEmpty();
            if (textfieldHasName) {
                if (this.repo.existsMetadataTemplate(name)) {
                    String message = Bundle.getString(EditMetaDataTemplateDialog.class, "EditMetaDataTemplateDialog.Error.NameExists", name);
                    MessageDisplayer.error(this, message);
                    this.textFieldName.requestFocusInWindow();
                    this.textFieldName.selectAll();
                    return false;
                }
                this.template.setName(name);
            } else {
                String message = Bundle.getString(EditMetaDataTemplateDialog.class, "EditMetaDataTemplateDialog.Error.SaveNoName", new Object[0]);
                MessageDisplayer.error(this, message);
                this.textFieldName.requestFocusInWindow();
                return false;
            }
        }
        return true;
    }

    private void initComponents() {
        this.panelContent = new JPanel();
        this.panelName = new JPanel();
        this.labelName = new JLabel();
        this.textFieldName = new JTextField();
        this.scrollPane = new JScrollPane();
        this.panelXmpEdit = new EditXmpPanel();
        this.panelButtons = new JPanel();
        this.buttonCancel = new JButton();
        this.buttonSave = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/metadatatemplates/Bundle");
        this.setTitle(bundle.getString("EditMetaDataTemplateDialog.title"));
        this.setName("Form");
        this.setPreferredSize(new Dimension(500, 500));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditMetaDataTemplateDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.panelContent.setLayout(new GridBagLayout());
        this.panelName.setLayout(new GridBagLayout());
        this.labelName.setLabelFor(this.textFieldName);
        this.labelName.setText(bundle.getString("EditMetaDataTemplateDialog.labelName.text"));
        this.labelName.setName("labelName");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelName.add((Component)this.labelName, gridBagConstraints);
        this.textFieldName.setColumns(20);
        this.textFieldName.setEnabled(false);
        this.textFieldName.setName("textFieldName");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelName.add((Component)this.textFieldName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelContent.add((Component)this.panelName, gridBagConstraints);
        this.scrollPane.setName("scrollPane");
        this.panelXmpEdit.setName("panelXmpEdit");
        this.scrollPane.setViewportView(this.panelXmpEdit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelContent.add((Component)this.scrollPane, gridBagConstraints);
        this.panelButtons.setLayout(new GridLayout(1, 0, 5, 0));
        this.buttonCancel.setText(bundle.getString("EditMetaDataTemplateDialog.buttonCancel.text"));
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMetaDataTemplateDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonCancel);
        this.buttonSave.setText(bundle.getString("EditMetaDataTemplateDialog.buttonSave.text"));
        this.buttonSave.setName("buttonSave");
        this.buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMetaDataTemplateDialog.this.buttonSaveActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonSave);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelContent.add((Component)this.panelButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.panelContent, gridBagConstraints);
        this.pack();
    }

    private void buttonSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.checkSave();
        this.setVisible(false);
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditMetaDataTemplateDialog dialog = new EditMetaDataTemplateDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

