/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.metadatatemplates;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import org.jphototagger.domain.repository.MetadataTemplatesRepository;
import org.jphototagger.domain.templates.MetadataTemplate;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.misc.InputHelperDialog;
import org.jphototagger.program.module.metadatatemplates.MetadataTemplateController;
import org.jphototagger.program.module.metadatatemplates.MetadataTemplatesPopupMenu;
import org.openide.util.Lookup;

public final class DeleteMetadataTemplateController
extends MetadataTemplateController {
    private final MetadataTemplatesRepository repo = Lookup.getDefault().lookup(MetadataTemplatesRepository.class);

    public DeleteMetadataTemplateController() {
        this.listen();
    }

    private void listen() {
        this.listenToActionsOf(MetadataTemplatesPopupMenu.INSTANCE.getItemDelete());
        this.getDeleteButton().addActionListener(this);
    }

    private JButton getDeleteButton() {
        return InputHelperDialog.INSTANCE.getPanelMetaDataTemplates().getButtonDelete();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.getDeleteButton() && this.isInputHelperListItemSelected()) {
            this.action(this.getTemplateOfInputHelperList());
        } else {
            super.actionPerformed(evt);
        }
    }

    @Override
    protected boolean myKey(KeyEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return evt.getKeyCode() == 127;
    }

    @Override
    protected boolean myAction(ActionEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return evt.getSource() == MetadataTemplatesPopupMenu.INSTANCE.getItemDelete();
    }

    @Override
    protected void action(MetadataTemplate template) {
        if (template == null) {
            throw new NullPointerException("template == null");
        }
        String name = template.getName();
        String message = Bundle.getString(DeleteMetadataTemplateController.class, "DeleteMetadataTemplateController.Confirm", name);
        if (MessageDisplayer.confirmYesNo(InputHelperDialog.INSTANCE, message) && !this.repo.deleteMetadataTemplate(name)) {
            message = Bundle.getString(DeleteMetadataTemplateController.class, "DeleteMetadataTemplateController.Error", name);
            MessageDisplayer.error(InputHelperDialog.INSTANCE, message);
        }
        this.focusList();
    }
}

