/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jphototagger.api.text.Suggest;
import org.jphototagger.domain.metadata.keywords.Keyword;
import org.jphototagger.domain.metadata.keywords.KeywordType;
import org.jphototagger.domain.repository.KeywordsRepository;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.keywords.tree.PathSelectionDialog;
import org.openide.util.Lookup;

public class SuggestKeywords
implements Suggest {
    private final KeywordsRepository repo = Lookup.getDefault().lookup(KeywordsRepository.class);
    private boolean accepted;

    @Override
    public Collection<String> suggest(String keywordName) {
        if (keywordName == null) {
            throw new NullPointerException("keywordName == null");
        }
        ArrayList<String> parentKeywordNames = new ArrayList<String>();
        Collection<Collection<Keyword>> parentKeywords = this.repo.findParentKeywords(keywordName, KeywordType.REAL_KEYWORD);
        parentKeywordNames.addAll(this.chooseParentKeywords(keywordName, this.toStringCollection(parentKeywords)));
        return new HashSet<String>(parentKeywordNames);
    }

    private Collection<Collection<String>> toStringCollection(Collection<Collection<Keyword>> keywordCollection) {
        ArrayList<Collection<String>> strings = new ArrayList<Collection<String>>();
        for (Collection<Keyword> keywords : keywordCollection) {
            ArrayList<String> keywordStrings = new ArrayList<String>(keywords.size());
            for (Keyword keyword : keywords) {
                keywordStrings.add(keyword.getName());
            }
            strings.add(keywordStrings);
        }
        return strings;
    }

    private Collection<String> chooseParentKeywords(String keywordName, Collection<Collection<String>> allParentKeywords) {
        ArrayList<String> choosenParentKeywords = new ArrayList<String>();
        this.accepted = true;
        if (allParentKeywords.size() > 0) {
            PathSelectionDialog dlg = new PathSelectionDialog(allParentKeywords, PathSelectionDialog.Mode.DISTINCT_ELEMENTS);
            dlg.setInfoMessage(Bundle.getString(SuggestKeywords.class, "SuggestKeywords.Info", keywordName));
            dlg.setVisible(true);
            if (dlg.isAccepted()) {
                this.addToKeywords(choosenParentKeywords, dlg.getSelPaths());
            }
            this.accepted = dlg.isAccepted();
        }
        return choosenParentKeywords;
    }

    private void addToKeywords(Collection<String> keywords, Collection<Collection<String>> parentKeywords) {
        for (Collection<String> collection : parentKeywords) {
            keywords.addAll(collection);
        }
    }

    @Override
    public String getDescription() {
        return Bundle.getString(SuggestKeywords.class, "SuggestKeywords.Description", new Object[0]);
    }

    @Override
    public String getRequiresDescription() {
        return Bundle.getString(SuggestKeywords.class, "SuggestKeywords.RequiresDescription", new Object[0]);
    }

    @Override
    public boolean isAccepted() {
        return this.accepted;
    }
}

