/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.tree;

import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jphototagger.domain.metadata.keywords.Keyword;
import org.jphototagger.domain.repository.KeywordsRepository;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.InputDialog;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.program.factory.ModelFactory;
import org.jphototagger.program.misc.InputHelperDialog;
import org.jphototagger.program.module.keywords.KeywordsPanel;
import org.jphototagger.program.module.keywords.tree.KeywordsController;
import org.jphototagger.program.module.keywords.tree.KeywordsTreeModel;
import org.openide.util.Lookup;

public class RenameKeywordController
extends KeywordsController
implements ActionListener,
KeyListener {
    public RenameKeywordController(KeywordsPanel _panel) {
        super(_panel);
    }

    @Override
    protected boolean myKey(KeyEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return evt.getKeyCode() == 113;
    }

    @Override
    protected boolean canHandleMultipleNodes() {
        return false;
    }

    @Override
    protected void localAction(List<DefaultMutableTreeNode> nodes) {
        DefaultMutableTreeNode node = nodes.get(0);
        Object userObject = node.getUserObject();
        if (userObject instanceof Keyword) {
            this.renameKeyword(node, (Keyword)userObject);
        } else {
            String message = Bundle.getString(RenameKeywordController.class, "RenameKeywordController.Error.Node", node);
            MessageDisplayer.error(null, message);
        }
    }

    private void renameKeyword(final DefaultMutableTreeNode node, final Keyword keyword) {
        final String newName = RenameKeywordController.getName(keyword);
        if (newName != null && !newName.trim().isEmpty()) {
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    RenameKeywordController.this.rename(node, keyword, newName);
                }
            });
        }
    }

    private void rename(DefaultMutableTreeNode node, Keyword keyword, String toName) {
        KeywordsTreeModel keywordsTreeModel = ModelFactory.INSTANCE.getModel(KeywordsTreeModel.class);
        keyword.setName(toName);
        keywordsTreeModel.changed(node, keyword);
    }

    static String getName(Keyword keyword) {
        String toName = null;
        String fromName = keyword.getName();
        InputDialog inputDialog = RenameKeywordController.createInputDialog(fromName);
        boolean input = true;
        KeywordsRepository repo = Lookup.getDefault().lookup(KeywordsRepository.class);
        while (input) {
            inputDialog.setVisible(true);
            if (!inputDialog.isAccepted()) {
                return null;
            }
            toName = inputDialog.getInput();
            if (!StringUtil.hasContent(toName)) {
                return null;
            }
            if ((toName = toName.trim()).equals(fromName)) {
                return null;
            }
            Keyword newKeyword = RenameKeywordController.createKeywordFromExistingKeyword(keyword, toName);
            if (repo.hasParentChildKeywordWithEqualName(newKeyword)) {
                toName = null;
                String message = Bundle.getString(RenameKeywordController.class, "RenameKeywordController.Confirm.Exists", newKeyword);
                input = MessageDisplayer.confirmYesNo(null, message);
                continue;
            }
            return toName;
        }
        return toName;
    }

    private static InputDialog createInputDialog(String input) {
        InputHelperDialog owner = InputHelperDialog.INSTANCE;
        String info = Bundle.getString(RenameKeywordController.class, "RenameKeywordController.Input.Name", input);
        String preferencesKey = RenameKeywordController.class.getName();
        InputDialog inputDialog = new InputDialog(owner, info, input);
        inputDialog.setPreferencesKey(preferencesKey);
        return inputDialog;
    }

    private static Keyword createKeywordFromExistingKeyword(Keyword keyword, String newName) {
        Long keywordId = keyword.getId();
        Long parentKeywordId = keyword.getIdParent();
        String newKeywordName = newName.trim();
        Boolean isReal = keyword.isReal();
        return new Keyword(keywordId, parentKeywordId, newKeywordName, isReal);
    }
}

