/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.tree;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXList;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.jphototagger.program.resource.GUI;

public class PathSelectionDialog
extends Dialog
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private boolean accepted;
    private final Collection<Collection<String>> paths;
    private Collection<Collection<String>> selPaths;
    private final Mode mode;
    private JButton buttonSelectAll;
    private JButton buttonSelectNothing;
    private JButton buttonSelectSelected;
    private JLabel labelInfo;
    private JXList list;
    private JScrollPane scrollPane;

    public PathSelectionDialog(Collection<Collection<String>> paths, Mode mode) {
        super((Frame)GUI.getAppFrame(), true);
        if (paths == null) {
            throw new NullPointerException("paths == null");
        }
        if (mode == null) {
            throw new NullPointerException("mode == null");
        }
        this.paths = paths;
        this.mode = mode;
        assert (paths != null) : "paths == null!";
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.list.addListSelectionListener(this);
        if (this.mode.equals((Object)Mode.DISTINCT_ELEMENTS)) {
            this.list.setLayoutOrientation(2);
            this.list.setVisibleRowCount(-1);
        }
        MnemonicUtil.setMnemonics(this);
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setInfoMessage(String message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        this.labelInfo.setText(message);
        this.labelInfo.setDisplayedMnemonic(message.charAt(0));
    }

    public Collection<Collection<String>> getSelPaths() {
        return Collections.unmodifiableCollection(this.selPaths);
    }

    private void handleButtonSelectNothingActionPerformed() {
        this.selPaths = new ArrayList<Collection<String>>();
        this.accepted = false;
        this.setVisible(false);
    }

    private void handleButtonSelectAllActionPerformed() {
        this.accepted = true;
        this.selPaths = new ArrayList<Collection<String>>(this.paths);
        this.setVisible(false);
    }

    private void handleButtonSelectSelectedActionPerformed() {
        Object[] selValues;
        this.accepted = true;
        ArrayList<Collection<String>> sel = new ArrayList<Collection<String>>();
        for (Object selValue : selValues = this.list.getSelectedValues()) {
            List<String> collection;
            if (selValue instanceof Collection) {
                collection = (List<String>)selValue;
                sel.add((Collection<String>)collection);
                continue;
            }
            if (!(selValue instanceof String)) continue;
            collection = Collections.singletonList((String)selValue);
            sel.add(collection);
        }
        this.selPaths = sel;
        this.setVisible(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        if (!evt.getValueIsAdjusting()) {
            this.buttonSelectSelected.setEnabled(this.list.getSelectedIndex() >= 0);
        }
    }

    private void initComponents() {
        this.labelInfo = new JLabel();
        this.scrollPane = new JScrollPane();
        this.list = new JXList();
        this.buttonSelectNothing = new JButton();
        this.buttonSelectAll = new JButton();
        this.buttonSelectSelected = new JButton();
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/keywords/tree/Bundle");
        this.setTitle(bundle.getString("PathSelectionDialog.title"));
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PathSelectionDialog.this.formWindowClosing(evt);
            }
        });
        this.labelInfo.setLabelFor(this.list);
        this.labelInfo.setName("labelInfo");
        this.scrollPane.setName("scrollPane");
        this.list.setModel((ListModel)new Model());
        this.list.setCellRenderer((ListCellRenderer)new Renderer());
        this.list.setName("list");
        this.scrollPane.setViewportView(this.list);
        this.buttonSelectNothing.setText(bundle.getString("PathSelectionDialog.buttonSelectNothing.text"));
        this.buttonSelectNothing.setName("buttonSelectNothing");
        this.buttonSelectNothing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathSelectionDialog.this.buttonSelectNothingActionPerformed(evt);
            }
        });
        this.buttonSelectAll.setText(bundle.getString("PathSelectionDialog.buttonSelectAll.text"));
        this.buttonSelectAll.setName("buttonSelectAll");
        this.buttonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathSelectionDialog.this.buttonSelectAllActionPerformed(evt);
            }
        });
        this.buttonSelectSelected.setText(bundle.getString("PathSelectionDialog.buttonSelectSelected.text"));
        this.buttonSelectSelected.setEnabled(false);
        this.buttonSelectSelected.setName("buttonSelectSelected");
        this.buttonSelectSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathSelectionDialog.this.buttonSelectSelectedActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelInfo, -1, 476, Short.MAX_VALUE).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING, -1, 476, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonSelectNothing).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelectAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelectSelected))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.labelInfo, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scrollPane, -1, 102, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonSelectSelected).addComponent(this.buttonSelectAll).addComponent(this.buttonSelectNothing)).addGap(12, 12, 12)));
        this.pack();
    }

    private void buttonSelectNothingActionPerformed(ActionEvent evt) {
        this.handleButtonSelectNothingActionPerformed();
    }

    private void buttonSelectAllActionPerformed(ActionEvent evt) {
        this.handleButtonSelectAllActionPerformed();
    }

    private void buttonSelectSelectedActionPerformed(ActionEvent evt) {
        this.handleButtonSelectSelectedActionPerformed();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PathSelectionDialog dialog = new PathSelectionDialog(new ArrayList<Collection<String>>(new ArrayList()), Mode.PATHS);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private final Icon ICON = AppLookAndFeel.getIcon("icon_keyword.png");

        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof Collection) {
                this.renderCollection(value, label);
            } else if (value instanceof String) {
                String padding = "  ";
                label.setText((String)value + padding);
            }
            label.setIcon(this.ICON);
            return label;
        }

        private void renderCollection(Object value, JLabel label) {
            Collection collection = (Collection)value;
            StringBuilder sb = new StringBuilder();
            String pathDelim = " > ";
            int i = 0;
            for (Object element : collection) {
                sb.append(i == 0 ? "" : pathDelim).append(element.toString());
                ++i;
            }
            label.setText(sb.toString());
        }
    }

    private class Model
    extends DefaultListModel<Object> {
        private static final long serialVersionUID = 1L;

        Model() {
            if (PathSelectionDialog.this.mode.equals((Object)Mode.DISTINCT_ELEMENTS)) {
                this.addDistinctElements();
            } else {
                this.addPaths();
            }
        }

        private void addPaths() {
            for (Collection path : PathSelectionDialog.this.paths) {
                this.addElement(path);
            }
        }

        private void addDistinctElements() {
            for (Collection path : PathSelectionDialog.this.paths) {
                for (String element : path) {
                    this.addElement(element);
                }
            }
        }
    }

    public static enum Mode {
        PATHS,
        DISTINCT_ELEMENTS;

    }
}

