/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.tree;

import java.util.Arrays;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.ui.AppLookAndFeel;

public final class KeywordsTreePopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    public static final KeywordsTreePopupMenu INSTANCE = new KeywordsTreePopupMenu();
    private final JMenuItem itemAdd = new JMenuItem(Bundle.getString(KeywordsTreePopupMenu.class, "KeywordsTreePopupMenu.DisplayName.ActionAddKeyword", new Object[0]), AppLookAndFeel.ICON_NEW);
    private final JMenuItem itemAddToEditPanel = new JMenuItem(Bundle.getString(KeywordsTreePopupMenu.class, "KeywordsTreePopupMenu.DisplayName.ActionAddToEditPanel", new Object[0]));
    private final JMenuItem itemRemove = new JMenuItem(Bundle.getString(KeywordsTreePopupMenu.class, "KeywordsTreePopupMenu.DisplayName.ActionRemoveKeyword", new Object[0]), AppLookAndFeel.ICON_DELETE);
    private final JMenuItem itemRename = new JMenuItem(Bundle.getString(KeywordsTreePopupMenu.class, "KeywordsTreePopupMenu.DisplayName.ActionRenameKeyword", new Object[0]), AppLookAndFeel.ICON_RENAME);
    private final JMenuItem itemToggleReal = new JMenuItem(Bundle.getString(KeywordsTreePopupMenu.class, "KeywordsTreePopupMenu.DisplayName.ActionToggleReal", new Object[0]));
    private final JMenuItem itemRemoveFromEditPanel = new JMenuItem(Bundle.getString(KeywordsTreePopupMenu.class, "KeywordsTreePopupMenu.DisplayName.ActionRemoveFromEditPanel", new Object[0]));
    private final JMenuItem itemPaste = new JMenuItem(Bundle.getString(KeywordsTreePopupMenu.class, "KeywordsTreePopupMenu.DisplayName.ActionPaste", new Object[0]), AppLookAndFeel.ICON_PASTE);
    private final JMenuItem itemExpandAllSubitems = new JMenuItem(Bundle.getString(KeywordsTreePopupMenu.class, "KeywordsTreePopupMenu.ItemExpand", new Object[0]));
    private final JMenuItem itemDisplayImagesKw = new JMenuItem(Bundle.getString(KeywordsTreePopupMenu.class, "KeywordsTreePopupMenu.DisplayName.ActionDisplayImagesKw", new Object[0]));
    private final JMenuItem itemDisplayImages = new JMenuItem(Bundle.getString(KeywordsTreePopupMenu.class, "KeywordsTreePopupMenu.DisplayName.ActionDisplayImages", new Object[0]));
    private final JMenuItem itemCut = new JMenuItem(Bundle.getString(KeywordsTreePopupMenu.class, "KeywordsTreePopupMenu.DisplayName.ActionCut", new Object[0]), AppLookAndFeel.ICON_CUT);
    private final JMenuItem itemCopy = new JMenuItem(Bundle.getString(KeywordsTreePopupMenu.class, "KeywordsTreePopupMenu.DisplayName.ActionCopy", new Object[0]), AppLookAndFeel.ICON_COPY);
    private final JMenuItem itemCollapseAllSubitems = new JMenuItem(Bundle.getString(KeywordsTreePopupMenu.class, "KeywordsTreePopupMenu.ItemCollapse", new Object[0]));
    private JTree tree;
    private TreePath treePathAtMouseCursor;
    private TreePath[] selectedTreePaths;

    private KeywordsTreePopupMenu() {
        this.init();
    }

    public JMenuItem getItemAdd() {
        return this.itemAdd;
    }

    public JMenuItem getItemRemove() {
        return this.itemRemove;
    }

    public JMenuItem getItemRename() {
        return this.itemRename;
    }

    public JMenuItem getItemToggleReal() {
        return this.itemToggleReal;
    }

    public JMenuItem getItemAddToEditPanel() {
        return this.itemAddToEditPanel;
    }

    public JMenuItem getItemRemoveFromEditPanel() {
        return this.itemRemoveFromEditPanel;
    }

    public JMenuItem getItemCut() {
        return this.itemCut;
    }

    public JMenuItem getItemCopy() {
        return this.itemCopy;
    }

    public JMenuItem getItemPaste() {
        return this.itemPaste;
    }

    public JMenuItem getItemDisplayImages() {
        return this.itemDisplayImages;
    }

    public JMenuItem getItemDisplayImagesKw() {
        return this.itemDisplayImagesKw;
    }

    public JMenuItem getItemCollapseAllSubitems() {
        return this.itemCollapseAllSubitems;
    }

    public JMenuItem getItemExpandAllSubitems() {
        return this.itemExpandAllSubitems;
    }

    public void setTreePathAtMouseCursor(TreePath path) {
        this.treePathAtMouseCursor = path;
    }

    public TreePath getTreePathAtMouseCursor() {
        return this.treePathAtMouseCursor;
    }

    public void setSelectedTreePaths(TreePath[] treePaths) {
        this.selectedTreePaths = treePaths == null ? null : Arrays.copyOf(treePaths, treePaths.length);
    }

    public TreePath[] getSelectedTreePaths() {
        return this.selectedTreePaths == null ? null : Arrays.copyOf(this.selectedTreePaths, this.selectedTreePaths.length);
    }

    public boolean isMouseCursorInSelection() {
        if (this.treePathAtMouseCursor == null || this.selectedTreePaths == null) {
            return false;
        }
        for (TreePath treePath : this.selectedTreePaths) {
            if (!treePath.equals(this.treePathAtMouseCursor)) continue;
            return true;
        }
        return false;
    }

    public boolean isMouseOverTreePath() {
        return this.treePathAtMouseCursor != null;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setTree(JTree tree) {
        this.tree = tree;
    }

    private void init() {
        this.addItems();
        this.setAccelerators();
    }

    private void addItems() {
        this.add(this.itemAddToEditPanel);
        this.add(this.itemRemoveFromEditPanel);
        JMenu menuEdit = new JMenu(Bundle.getString(KeywordsTreePopupMenu.class, "KeywordsTreePopupMenu.DisplayName.MenuEdit", new Object[0]));
        menuEdit.add(this.itemAdd);
        menuEdit.add(this.itemRemove);
        menuEdit.add(this.itemRename);
        menuEdit.add(this.itemToggleReal);
        menuEdit.addSeparator();
        menuEdit.add(this.itemCopy);
        menuEdit.add(this.itemCut);
        menuEdit.add(this.itemPaste);
        this.addSeparator();
        this.add(menuEdit);
        this.addSeparator();
        this.add(this.itemExpandAllSubitems);
        this.add(this.itemCollapseAllSubitems);
        this.addSeparator();
        this.add(this.itemDisplayImages);
        this.add(this.itemDisplayImagesKw);
    }

    private void setAccelerators() {
        this.itemAdd.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(78));
        this.itemRemove.setAccelerator(KeyEventUtil.getKeyStroke(127));
        this.itemRename.setAccelerator(KeyEventUtil.getKeyStroke(113));
        this.itemToggleReal.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(82));
        this.itemAddToEditPanel.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(66));
        this.itemRemoveFromEditPanel.setAccelerator(KeyEventUtil.getKeyStroke(8));
        this.itemCopy.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(67));
        this.itemCut.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(88));
        this.itemPaste.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(86));
    }
}

