/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.tree;

import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.TreeUtil;
import org.jphototagger.program.event.listener.TreeMouseListener;
import org.jphototagger.program.module.keywords.tree.KeywordTreeNodesClipboard;
import org.jphototagger.program.module.keywords.tree.KeywordsTreePopupMenu;

public final class KeywordsTreeMouseListener
extends TreeMouseListener {
    private final KeywordsTreePopupMenu popupMenu = KeywordsTreePopupMenu.INSTANCE;

    public KeywordsTreeMouseListener() {
        this.listenExpandAllSubItems(this.popupMenu.getItemExpandAllSubitems(), true);
        this.listenCollapseAllSubItems(this.popupMenu.getItemCollapseAllSubitems(), true);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        if (MouseEventUtil.isPopupTrigger(evt)) {
            TreePath treePathAtMouseCursor = TreeUtil.getTreePath(evt);
            boolean isHkNode = treePathAtMouseCursor != null && !TreeUtil.isRootItemPosition(evt) && treePathAtMouseCursor.getLastPathComponent() instanceof DefaultMutableTreeNode;
            JTree tree = (JTree)evt.getSource();
            this.popupMenu.setTree(tree);
            this.setTreePathsToPopupMenu(tree, treePathAtMouseCursor);
            this.setMenuItemsEnabled(isHkNode);
            this.popupMenu.getItemAdd().setEnabled(treePathAtMouseCursor != null);
            this.popupMenu.show(tree, evt.getX(), evt.getY());
        }
    }

    private void setTreePathsToPopupMenu(JTree tree, TreePath treePathAtMouseCursor) {
        TreePath[] treePathArray;
        this.popupMenu.setTreePathAtMouseCursor(treePathAtMouseCursor);
        if (treePathAtMouseCursor == null) {
            this.popupMenu.setSelectedTreePaths(null);
            return;
        }
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths == null) {
            TreePath[] treePathArray2 = new TreePath[1];
            treePathArray = treePathArray2;
            treePathArray2[0] = treePathAtMouseCursor;
        } else {
            treePathArray = selectionPaths;
        }
        this.popupMenu.setSelectedTreePaths(treePathArray);
    }

    private void setMenuItemsEnabled(boolean hkNode) {
        this.popupMenu.getItemRemove().setEnabled(hkNode);
        this.popupMenu.getItemRename().setEnabled(hkNode);
        this.popupMenu.getItemToggleReal().setEnabled(hkNode);
        this.popupMenu.getItemAddToEditPanel().setEnabled(hkNode);
        this.popupMenu.getItemRemoveFromEditPanel().setEnabled(hkNode);
        this.popupMenu.getItemCut().setEnabled(hkNode);
        this.popupMenu.getItemPaste().setEnabled(hkNode && !KeywordTreeNodesClipboard.INSTANCE.isEmpty());
        this.popupMenu.getItemExpandAllSubitems().setEnabled(hkNode);
        this.popupMenu.getItemCollapseAllSubitems().setEnabled(hkNode);
    }

    @Override
    protected void popupTrigger(JTree tree, TreePath path, int x, int y) {
    }
}

