/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jphototagger.domain.metadata.keywords.Keyword;
import org.jphototagger.domain.repository.KeywordsRepository;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.SortedChildrenTreeNode;
import org.jphototagger.lib.swing.util.TreeUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.keywords.KeywordsUtil;
import org.openide.util.Lookup;

public final class KeywordsTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(KeywordsTreeModel.class.getName());
    private final KeywordsRepository repo = Lookup.getDefault().lookup(KeywordsRepository.class);
    private final DefaultMutableTreeNode ROOT = (DefaultMutableTreeNode)this.getRoot();

    public KeywordsTreeModel() {
        super(new SortedChildrenTreeNode(Bundle.getString(KeywordsTreeModel.class, "KeywordsTreeModel.DisplayName.Root", new Object[0])));
        this.createTree();
    }

    public DefaultMutableTreeNode findChildByName(DefaultMutableTreeNode parent, String name) {
        if (parent == null) {
            throw new NullPointerException("parent == null");
        }
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        Enumeration<TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            Object userObject = child.getUserObject();
            if (!(userObject instanceof Keyword) || !((Keyword)userObject).getName().equalsIgnoreCase(name)) continue;
            return child;
        }
        return null;
    }

    public synchronized DefaultMutableTreeNode insert(DefaultMutableTreeNode parentNode, String keyword, boolean real, boolean errorMessageIfExists) {
        if (parentNode == null) {
            throw new NullPointerException("parentNode == null");
        }
        if (keyword == null) {
            throw new NullPointerException("keyword == null");
        }
        if (!this.ensureIsNotChild(parentNode, keyword, errorMessageIfExists)) {
            return null;
        }
        Object userObject = parentNode.getUserObject();
        boolean parentIsRoot = parentNode.equals(this.ROOT);
        assert (parentIsRoot || userObject instanceof Keyword) : parentNode;
        if (parentIsRoot || userObject instanceof Keyword) {
            Long idParent = parentIsRoot ? null : ((Keyword)userObject).getId();
            Keyword child = new Keyword(null, idParent, keyword, real);
            if (this.repo.saveKeyword(child)) {
                KeywordsUtil.insertDcSubject(keyword);
                SortedChildrenTreeNode node = new SortedChildrenTreeNode(child);
                this.insertNode(parentNode, node);
                return node;
            }
            String message = Bundle.getString(KeywordsTreeModel.class, "KeywordsTreeModel.Error.DbInsert", keyword);
            MessageDisplayer.error(null, message);
        }
        return null;
    }

    public synchronized void copySubtree(DefaultMutableTreeNode source, DefaultMutableTreeNode target) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        if (target == null) {
            throw new NullPointerException("target == null");
        }
        if (!this.ensureIsNotChild(target, source.getUserObject().toString(), true) || !this.ensureTargetIsNotBelowSource(source, target)) {
            return;
        }
        this.cpySubtree(source, target);
    }

    private synchronized void cpySubtree(DefaultMutableTreeNode source, DefaultMutableTreeNode target) {
        DefaultMutableTreeNode newTarget = this.deepCopy(source, target);
        Enumeration<TreeNode> e = source.children();
        while (e.hasMoreElements()) {
            this.cpySubtree((DefaultMutableTreeNode)e.nextElement(), newTarget);
        }
    }

    private synchronized DefaultMutableTreeNode deepCopy(DefaultMutableTreeNode source, DefaultMutableTreeNode target) {
        Keyword srcKeyword = (Keyword)source.getUserObject();
        Keyword targetKeyword = (Keyword)target.getUserObject();
        Keyword keyword = new Keyword(null, targetKeyword.getId(), srcKeyword.getName(), srcKeyword.isReal());
        if (this.repo.saveKeyword(keyword)) {
            KeywordsUtil.insertDcSubject(keyword.getName());
            SortedChildrenTreeNode node = new SortedChildrenTreeNode(keyword);
            target.add(node);
            this.fireTreeNodesInserted(this, target.getPath(), new int[]{target.getIndex(node)}, new Object[]{node});
            return node;
        }
        String message = Bundle.getString(KeywordsTreeModel.class, "KeywordsTreeModel.Error.DbCopy", keyword.getName(), targetKeyword.getName());
        MessageDisplayer.error(null, message);
        return null;
    }

    private void insertNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        parent.add(child);
        int childIndex = parent.getIndex(child);
        this.fireTreeNodesInserted(this, parent.getPath(), new int[]{childIndex}, new Object[]{child});
        KeywordsUtil.expandAllTreesTo(child);
    }

    private boolean ensureIsNotChild(DefaultMutableTreeNode parentNode, String keyword, boolean errorMessage) {
        if (this.childHasKeyword(parentNode, keyword)) {
            if (errorMessage) {
                String message = Bundle.getString(KeywordsTreeModel.class, "KeywordsTreeModel.Error.KeywordExists", keyword, parentNode);
                MessageDisplayer.error(null, message);
            }
            return false;
        }
        return true;
    }

    private boolean ensureTargetIsNotBelowSource(DefaultMutableTreeNode source, DefaultMutableTreeNode target) {
        boolean isBelow = TreeUtil.isAbove(source, target);
        if (isBelow) {
            String message = Bundle.getString(KeywordsTreeModel.class, "KeywordsTreeModel.Error.TargetBelowSource", new Object[0]);
            MessageDisplayer.error(null, message);
            return false;
        }
        return true;
    }

    private boolean childHasKeyword(DefaultMutableTreeNode parentNode, String keyword) {
        Enumeration<TreeNode> children = parentNode.children();
        while (children.hasMoreElements()) {
            String s;
            Object userObject;
            TreeNode o = children.nextElement();
            if (!(o instanceof DefaultMutableTreeNode) || !((userObject = ((DefaultMutableTreeNode)o).getUserObject()) instanceof Keyword) || (s = ((Keyword)userObject).getName()) == null || !s.equals(keyword)) continue;
            return true;
        }
        return false;
    }

    public synchronized void delete(DefaultMutableTreeNode keywordNode) {
        if (keywordNode == null) {
            throw new NullPointerException("keywordNode == null");
        }
        ArrayList<Keyword> delKeywords = new ArrayList<Keyword>();
        Enumeration<TreeNode> e = keywordNode.preorderEnumeration();
        while (e.hasMoreElements()) {
            Object userObject;
            TreeNode el = e.nextElement();
            if (!(el instanceof DefaultMutableTreeNode) || !((userObject = ((DefaultMutableTreeNode)el).getUserObject()) instanceof Keyword)) continue;
            delKeywords.add((Keyword)userObject);
        }
        if (this.repo.deleteKeywords(delKeywords)) {
            this.removeNodeFromParent(keywordNode);
        } else {
            String message = Bundle.getString(KeywordsTreeModel.class, "KeywordsTreeModel.Error.DbRemove", keywordNode.toString());
            MessageDisplayer.error(null, message);
        }
    }

    public void changed(DefaultMutableTreeNode node, Keyword keyword) {
        if (node == null) {
            throw new NullPointerException("node == null");
        }
        if (keyword == null) {
            throw new NullPointerException("keyword == null");
        }
        assert (node.getUserObject().equals(keyword)) : node.getUserObject();
        KeywordsTreeModel src = this;
        TreeNode parent = node.getParent();
        if (parent instanceof DefaultMutableTreeNode) {
            if (this.repo.updateKeyword(keyword)) {
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parent;
                this.fireTreeNodesChanged(src, parentNode.getPath(), new int[]{parentNode.getIndex(node)}, new Object[]{node});
            } else {
                String message = Bundle.getString(KeywordsTreeModel.class, "KeywordsTreeModel.Error.DbUpdate", keyword);
                MessageDisplayer.error(null, message);
            }
        }
    }

    public void move(DefaultMutableTreeNode source, DefaultMutableTreeNode target, Keyword keyword) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        if (target == null) {
            throw new NullPointerException("target == null");
        }
        if (keyword == null) {
            throw new NullPointerException("keyword == null");
        }
        if (this.ensureIsNotChild(target, keyword.getName(), true) && this.ensureTargetIsNotBelowSource(source, target) && this.setIdParent(keyword, target) && this.repo.updateKeyword(keyword)) {
            DefaultMutableTreeNode removeNode = TreeUtil.findNodeWithUserObject(this.ROOT, source.getUserObject());
            if (removeNode != null) {
                this.removeNodeFromParent(removeNode);
            }
            this.insertNode(target, source);
        }
    }

    private boolean setIdParent(Keyword keyword, DefaultMutableTreeNode parentNode) {
        if (parentNode.equals(this.ROOT)) {
            keyword.setIdParent(null);
            return true;
        }
        Object userObject = parentNode.getUserObject();
        if (userObject instanceof Keyword) {
            keyword.setIdParent(((Keyword)userObject).getId());
            return true;
        }
        LOGGER.log(Level.WARNING, "''{0}'' is not root and does not contain a keyword to move ''{1}'' below!", new Object[]{parentNode, keyword});
        return false;
    }

    private void createTree() {
        Collection<Keyword> roots = this.repo.findRootKeywords();
        for (Keyword rootKeyword : roots) {
            SortedChildrenTreeNode rootNode = new SortedChildrenTreeNode(rootKeyword);
            this.insertNode(this.ROOT, rootNode);
            this.insertChildren(rootNode);
        }
    }

    private void insertChildren(DefaultMutableTreeNode parentNode) {
        Keyword parent = (Keyword)parentNode.getUserObject();
        Collection<Keyword> children = this.repo.findChildKeywords(parent.getId());
        for (Keyword child : children) {
            SortedChildrenTreeNode childNode = new SortedChildrenTreeNode(child);
            this.insertNode(parentNode, childNode);
            this.insertChildren(childNode);
        }
    }

    public void removeAllKeywords() {
        TreeUtil.removeAllChildren(this, this.ROOT);
    }
}

