/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.tree;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.metadata.keywords.Keyword;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.repository.event.xmp.XmpDeletedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.domain.thumbnails.ThumbnailsPanelSettings;
import org.jphototagger.domain.thumbnails.event.ThumbnailsPanelRefreshEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.program.module.keywords.list.ShowThumbnailsContainingAllKeywords2;
import org.jphototagger.program.resource.GUI;

public final class KeywordsTreeItemSelectedController
implements TreeSelectionListener {
    private final List<List<String>> selectedKeywordPaths = new ArrayList<List<String>>();

    public KeywordsTreeItemSelectedController() {
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
        GUI.getSelKeywordsTree().getSelectionModel().addTreeSelectionListener(this);
    }

    private boolean isKeywordSelected() {
        return GUI.getSelKeywordsTree().getSelectionPaths() != null;
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        this.selectedKeywordPaths.clear();
        if (evt.isAddedPath()) {
            this.selectedKeywordPaths.addAll(this.getKeywordStringPaths());
            this.showThumbnailsOfSelectedKeywords(new ThumbnailsPanelSettings(new Point(0, 0), Collections.emptyList()));
        }
    }

    @EventSubscriber(eventClass=ThumbnailsPanelRefreshEvent.class)
    public void refresh(ThumbnailsPanelRefreshEvent evt) {
        if (this.isKeywordSelected() && evt.getOriginOfDisplayedThumbnails().isFilesMatchingAKeyword()) {
            this.showThumbnailsOfSelectedKeywords(evt.getThumbnailsPanelSettings());
        }
    }

    private void showThumbnailsOfSelectedKeywords(ThumbnailsPanelSettings settings) {
        EventQueueUtil.invokeInDispatchThread(new ShowThumbnailsContainingAllKeywords2(this.selectedKeywordPaths, settings));
    }

    private List<List<String>> getKeywordStringPaths() {
        ArrayList<List<String>> keywordPaths = new ArrayList<List<String>>();
        List<List<Keyword>> hkwp = this.getKeywordPaths();
        for (List<Keyword> kws : hkwp) {
            ArrayList<String> stringKeywords = new ArrayList<String>();
            for (Keyword kw : kws) {
                stringKeywords.add(kw.getName());
            }
            keywordPaths.add(stringKeywords);
        }
        return keywordPaths;
    }

    private List<List<Keyword>> getKeywordPaths() {
        TreePath[] selPaths = GUI.getSelKeywordsTree().getSelectionPaths();
        ArrayList<List<Keyword>> paths = new ArrayList<List<Keyword>>();
        for (TreePath selPath : selPaths) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            ArrayList<Keyword> kwPath = new ArrayList<Keyword>();
            for (Object userObject : selNode.getUserObjectPath()) {
                Keyword kw;
                if (!(userObject instanceof Keyword) || !(kw = (Keyword)userObject).isReal().booleanValue()) continue;
                kwPath.add(kw);
            }
            paths.add(kwPath);
        }
        return paths;
    }

    @EventSubscriber(eventClass=XmpDeletedEvent.class)
    public void xmpDeleted(XmpDeletedEvent evt) {
        if (this.isKeywordSelected() && evt.getXmp().containsOneOf(XmpDcSubjectsSubjectMetaDataValue.INSTANCE, this.getSelectedKeywords())) {
            this.showThumbnailsOfSelectedKeywords(this.createThumbnailsPanelSettings());
        }
    }

    @EventSubscriber(eventClass=XmpInsertedEvent.class)
    public void xmpInserted(XmpInsertedEvent evt) {
        if (this.isKeywordSelected() && evt.getXmp().containsOneOf(XmpDcSubjectsSubjectMetaDataValue.INSTANCE, this.getSelectedKeywords())) {
            this.showThumbnailsOfSelectedKeywords(this.createThumbnailsPanelSettings());
        }
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        if (this.isKeywordSelected()) {
            List<String> selectedKeywords = this.getSelectedKeywords();
            if (Xmp.valueDeleted(evt.getOldXmp(), evt.getUpdatedXmp(), XmpDcSubjectsSubjectMetaDataValue.INSTANCE, selectedKeywords) || Xmp.valueInserted(evt.getOldXmp(), evt.getUpdatedXmp(), XmpDcSubjectsSubjectMetaDataValue.INSTANCE, selectedKeywords)) {
                this.showThumbnailsOfSelectedKeywords(this.createThumbnailsPanelSettings());
            }
        }
    }

    private List<String> getSelectedKeywords() {
        ArrayList<String> selKeywords = new ArrayList<String>(this.selectedKeywordPaths.size());
        for (List<String> path : this.selectedKeywordPaths) {
            int pathsize = path.size();
            if (pathsize <= 0) continue;
            selKeywords.add(path.get(pathsize - 1));
        }
        return selKeywords;
    }

    public ThumbnailsPanelSettings createThumbnailsPanelSettings() {
        ThumbnailsPanelSettings settings = new ThumbnailsPanelSettings(GUI.getThumbnailsPanel().getViewPosition(), Collections.emptyList());
        settings.setSelectedFiles(GUI.getThumbnailsPanel().getSelectedFiles());
        return settings;
    }
}

