/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.tree;

import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jphototagger.domain.metadata.keywords.Keyword;
import org.jphototagger.program.app.ui.AppLookAndFeel;

public final class KeywordsTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Icon ICON_REAL = AppLookAndFeel.getIcon("icon_keyword.png");
    private static final Icon ICON_HELPER = AppLookAndFeel.getIcon("icon_folder.png");
    private static final Color TREE_FOREGROUND = AppLookAndFeel.getTreeForeground();
    private static final Color TREE_BACKGROUND = AppLookAndFeel.getTreeBackground();
    private static final Color TREE_SELECTION_FOREGROUND = AppLookAndFeel.getTreeSelectionForeground();
    private static final Color TREE_SELECTION_BACKGROUND = AppLookAndFeel.getTreeSelectionBackground();
    private static final long serialVersionUID = 1L;
    private int tempSelectionRow = -1;
    private final Set<String> highlightKeywords = new HashSet<String>();

    public KeywordsTreeCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, false, row, hasFocus);
        this.render(((DefaultMutableTreeNode)value).getUserObject(), tree, row, sel);
        return this;
    }

    private void render(Object userObject, JTree tree, int row, boolean itemAtIndexIsSelected) {
        boolean isSelection;
        boolean selImgHasKeyword = false;
        boolean real = false;
        boolean helper = false;
        if (userObject instanceof Keyword) {
            Keyword keyword = (Keyword)userObject;
            real = keyword.isReal();
            helper = !real;
            selImgHasKeyword = real && this.isHighlightKeyword(keyword.getName());
            this.setText(keyword.getName());
        }
        boolean tempSelRowIsSelected = this.tempSelectionRow < 0 ? false : tree.isRowSelected(this.tempSelectionRow);
        boolean tempSelExists = this.tempSelectionRow >= 0;
        boolean isTempSelRow = row == this.tempSelectionRow;
        boolean bl = isSelection = isTempSelRow || !tempSelExists && itemAtIndexIsSelected || tempSelExists && !isTempSelRow && itemAtIndexIsSelected && tempSelRowIsSelected;
        this.setIcon(real ? ICON_REAL : (helper ? ICON_HELPER : ICON_REAL));
        this.setForeground(isSelection ? TREE_SELECTION_FOREGROUND : (selImgHasKeyword ? AppLookAndFeel.TREE_SEL_IMG_HAS_KEYWORD_FOREGROUND : TREE_FOREGROUND));
        this.setBackground(isSelection ? TREE_SELECTION_BACKGROUND : (selImgHasKeyword ? AppLookAndFeel.TREE_SEL_IMG_HAS_KEYWORD_BACKGROUND : TREE_BACKGROUND));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHighlightKeyword(Object value) {
        String stringValue = value.toString();
        Set<String> set = this.highlightKeywords;
        synchronized (set) {
            for (String keyword : this.highlightKeywords) {
                if (keyword == null || !keyword.equalsIgnoreCase(stringValue)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighlightKeywords(Collection<? extends String> keywordsToHighlight) {
        if (keywordsToHighlight == null) {
            throw new NullPointerException("keywords == null");
        }
        Set<String> set = this.highlightKeywords;
        synchronized (set) {
            this.highlightKeywords.clear();
            this.highlightKeywords.addAll(keywordsToHighlight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelImgKeywords(Collection<? extends String> keywords) {
        if (keywords == null) {
            throw new NullPointerException("keywords == null");
        }
        Set<String> set = this.highlightKeywords;
        synchronized (set) {
            this.highlightKeywords.addAll(keywords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelImgKeywords(Collection<? extends String> keywords) {
        if (keywords == null) {
            throw new NullPointerException("keywords == null");
        }
        Set<String> set = this.highlightKeywords;
        synchronized (set) {
            this.highlightKeywords.removeAll(keywords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelImgKeyword(String keyword) {
        if (keyword == null) {
            throw new NullPointerException("keyword == null");
        }
        Set<String> set = this.highlightKeywords;
        synchronized (set) {
            this.highlightKeywords.add(keyword);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelImgKeyword(String keyword) {
        if (keyword == null) {
            throw new NullPointerException("keyword == null");
        }
        Set<String> set = this.highlightKeywords;
        synchronized (set) {
            this.highlightKeywords.remove(keyword);
        }
    }

    public void setTempSelectionRow(int index) {
        this.tempSelectionRow = index;
    }
}

