/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.repository.KeywordsRepository;
import org.jphototagger.domain.repository.event.dcsubjects.DcSubjectInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.program.factory.ModelFactory;
import org.jphototagger.program.module.keywords.tree.KeywordsTreeModel;
import org.openide.util.Lookup;

public final class KeywordsRepositoryUpdatesController {
    private final KeywordsRepository repo = Lookup.getDefault().lookup(KeywordsRepository.class);

    public KeywordsRepositoryUpdatesController() {
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        if (this.isAutoInsertKeywords()) {
            this.addNotExistingKeywords(evt.getUpdatedXmp());
        }
    }

    @EventSubscriber(eventClass=DcSubjectInsertedEvent.class)
    public void dcSubjectInserted(DcSubjectInsertedEvent evt) {
        if (this.isAutoInsertKeywords()) {
            this.addNotExistingKeywords(Collections.singleton(evt.getDcSubject()));
        }
    }

    @EventSubscriber(eventClass=XmpInsertedEvent.class)
    public void xmpInserted(XmpInsertedEvent evt) {
        if (this.isAutoInsertKeywords()) {
            this.addNotExistingKeywords(evt.getXmp());
        }
    }

    private boolean isAutoInsertKeywords() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return !prefs.containsKey("KeywordsTree.AutoInsertUnknownKeywords") || prefs.getBoolean("KeywordsTree.AutoInsertUnknownKeywords");
    }

    private void addNotExistingKeywords(Xmp xmp) {
        Object xmpValue = xmp.getValue(XmpDcSubjectsSubjectMetaDataValue.INSTANCE);
        if (xmpValue instanceof List) {
            this.addNotExistingKeywords((List)xmpValue);
        }
    }

    private void addNotExistingKeywords(Collection<? extends String> keywords) {
        for (String string : keywords) {
            if (this.repo.existsKeyword(string)) continue;
            this.addKeyword(string);
        }
    }

    private void addKeyword(final String keyword) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                KeywordsTreeModel model = ModelFactory.INSTANCE.getModel(KeywordsTreeModel.class);
                model.insert((DefaultMutableTreeNode)model.getRoot(), keyword, true, false);
            }
        });
    }
}

