/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.tree;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.TreeUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.keywords.KeywordsPanel;
import org.jphototagger.program.module.keywords.tree.KeywordsTreePopupMenu;

public abstract class KeywordsController
implements ActionListener,
KeyListener {
    private final KeywordsPanel panel;

    protected abstract boolean myKey(KeyEvent var1);

    protected abstract void localAction(List<DefaultMutableTreeNode> var1);

    protected abstract boolean canHandleMultipleNodes();

    public KeywordsController(KeywordsPanel _panel) {
        if (_panel == null) {
            throw new NullPointerException("_panel == null");
        }
        this.panel = _panel;
        this.listen();
    }

    private void listen() {
        this.panel.getTree().addKeyListener(this);
    }

    protected KeywordsPanel getHKPanel() {
        return this.panel;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        List<DefaultMutableTreeNode> selNodes;
        if (this.myKey(evt) && (selNodes = this.getSelectedNodes(evt)) != null && !selNodes.isEmpty() && this.checkNodeCount(selNodes)) {
            this.localAction(selNodes);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        List<DefaultMutableTreeNode> selNodes = this.getSelectedNodes(evt);
        if (selNodes != null && !selNodes.isEmpty() && this.checkNodeCount(selNodes)) {
            this.localAction(selNodes);
        }
    }

    protected List<DefaultMutableTreeNode> getSelectedNodes(ActionEvent evt) {
        TreePath[] selectedTreePaths;
        TreePath[] treePathArray;
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        if (KeywordsTreePopupMenu.INSTANCE.isMouseCursorInSelection()) {
            treePathArray = KeywordsTreePopupMenu.INSTANCE.getSelectedTreePaths();
        } else if (KeywordsTreePopupMenu.INSTANCE.isMouseOverTreePath()) {
            TreePath[] treePathArray2 = new TreePath[1];
            treePathArray = treePathArray2;
            treePathArray2[0] = KeywordsTreePopupMenu.INSTANCE.getTreePathAtMouseCursor();
        } else {
            treePathArray = selectedTreePaths = null;
        }
        if (selectedTreePaths == null) {
            return null;
        }
        ArrayList<DefaultMutableTreeNode> selectedNodes = new ArrayList<DefaultMutableTreeNode>();
        for (TreePath selectedTreePath : selectedTreePaths) {
            Object node = selectedTreePath.getLastPathComponent();
            if (!(node instanceof DefaultMutableTreeNode)) continue;
            selectedNodes.add((DefaultMutableTreeNode)node);
        }
        return selectedNodes;
    }

    protected List<DefaultMutableTreeNode> getSelectedNodes(KeyEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        if (evt.getComponent() instanceof JTree) {
            JTree tree = (JTree)evt.getComponent();
            if (tree.isSelectionEmpty()) {
                return null;
            }
            ArrayList<DefaultMutableTreeNode> selNodes = new ArrayList<DefaultMutableTreeNode>();
            for (TreePath selPath : tree.getSelectionPaths()) {
                Object node = selPath.getLastPathComponent();
                if (!(node instanceof DefaultMutableTreeNode)) continue;
                selNodes.add((DefaultMutableTreeNode)node);
            }
            return selNodes;
        }
        return null;
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    protected boolean ensureNoChild(List<DefaultMutableTreeNode> nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes == null");
        }
        int size = nodes.size();
        if (size <= 1) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode parent = nodes.get(i);
            for (int j = 0; j < size; ++j) {
                DefaultMutableTreeNode node;
                if (j == i || !TreeUtil.isAbove(parent, node = nodes.get(j))) continue;
                String message = Bundle.getString(KeywordsController.class, "KeywordsController.Tree.Error.IsChild", new Object[0]);
                MessageDisplayer.error(null, message);
                return false;
            }
        }
        return true;
    }

    private boolean checkNodeCount(Collection<DefaultMutableTreeNode> nodes) {
        if (!this.canHandleMultipleNodes() && nodes.size() > 1) {
            String message = Bundle.getString(KeywordsController.class, "KeywordsController.Error.MultiSelection", new Object[0]);
            MessageDisplayer.error(null, message);
            return false;
        }
        return true;
    }
}

