/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public final class KeywordTreeNodesClipboard {
    public static final KeywordTreeNodesClipboard INSTANCE = new KeywordTreeNodesClipboard();
    private Action action = Action.UNKNOWN;
    private final List<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();

    public boolean isEmpty() {
        return this.nodes.size() <= 0;
    }

    public List<DefaultMutableTreeNode> getContent() {
        return Collections.unmodifiableList(this.nodes);
    }

    public void setContent(DefaultMutableTreeNode node, Action action) {
        if (node == null) {
            throw new NullPointerException("node == null");
        }
        if (action == null) {
            throw new NullPointerException("action == null");
        }
        this.nodes.clear();
        this.nodes.add(node);
        this.action = action;
    }

    public void setContent(List<DefaultMutableTreeNode> nodes, Action action) {
        if (nodes == null) {
            throw new NullPointerException("nodes == null");
        }
        if (action == null) {
            throw new NullPointerException("action == null");
        }
        nodes.clear();
        this.nodes.addAll(nodes);
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public void empty() {
        this.nodes.clear();
        this.action = Action.UNKNOWN;
    }

    public boolean isMove() {
        return this.action.equals((Object)Action.MOVE);
    }

    public boolean isCopy() {
        return this.action.equals((Object)Action.COPY);
    }

    private KeywordTreeNodesClipboard() {
    }

    public static enum Action {
        COPY,
        MOVE,
        UNKNOWN;

    }
}

