/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.tree;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.swingx.JXTree;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.program.module.keywords.tree.KeywordsTreeCellRenderer;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class HighlightKeywordsTreeController {
    private final ImageFilesRepository repo = Lookup.getDefault().lookup(ImageFilesRepository.class);
    private final List<File> selectedFiles = new ArrayList<File>();

    public HighlightKeywordsTreeController() {
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        this.selectedFiles.clear();
        this.selectedFiles.addAll(evt.getSelectedFiles());
        this.setKeywords();
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        this.setKeywords();
    }

    private void setKeywords() {
        this.removeKeywords();
        ArrayList<String> keywords = new ArrayList<String>();
        for (File file : this.selectedFiles) {
            keywords.addAll(this.repo.findDcSubjectsOfImageFile(file));
        }
        this.setKeywords(GUI.getSelKeywordsTree(), keywords);
        this.setKeywords(GUI.getEditKeywordsTree(), keywords);
        this.setKeywords(GUI.getInputHelperKeywordsTree(), keywords);
    }

    private void setKeywords(JTree tree, Collection<String> keywords) {
        TreeCellRenderer treeCellRenderer = tree.getCellRenderer();
        if (treeCellRenderer instanceof JXTree.DelegatingRenderer) {
            treeCellRenderer = ((JXTree.DelegatingRenderer)treeCellRenderer).getDelegateRenderer();
        }
        if (treeCellRenderer instanceof KeywordsTreeCellRenderer) {
            ((KeywordsTreeCellRenderer)treeCellRenderer).setHighlightKeywords(keywords);
            tree.repaint();
        }
    }

    private void removeKeywords() {
        this.setKeywords(GUI.getEditKeywordsTree(), new ArrayList<String>());
        this.setKeywords(GUI.getInputHelperKeywordsTree(), new ArrayList<String>());
    }
}

