/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.tree;

import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jphototagger.domain.metadata.SelectedFilesMetaDataEditor;
import org.jphototagger.domain.metadata.keywords.Keyword;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.editmetadata.EditRepeatableTextEntryPanel;
import org.jphototagger.program.module.keywords.KeywordsPanel;
import org.jphototagger.program.module.keywords.KeywordsUtil;
import org.jphototagger.program.module.keywords.tree.KeywordsController;
import org.openide.util.Lookup;

public class AddKeywordsToEditPanelController
extends KeywordsController
implements ActionListener,
KeyListener {
    public AddKeywordsToEditPanelController(KeywordsPanel panel) {
        super(panel);
    }

    @Override
    protected boolean myKey(KeyEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return KeyEventUtil.isMenuShortcut(evt, 66);
    }

    @Override
    protected boolean canHandleMultipleNodes() {
        return false;
    }

    @Override
    protected void localAction(List<DefaultMutableTreeNode> nodes) {
        final DefaultMutableTreeNode node = nodes.get(0);
        final ArrayList keywordNames = new ArrayList();
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                AddKeywordsToEditPanelController.this.addParentKeywords(node, keywordNames);
                AddKeywordsToEditPanelController.this.addToEditPanel(keywordNames);
            }
        });
    }

    private void addToEditPanel(List<String> keywordNames) {
        SelectedFilesMetaDataEditor editor = Lookup.getDefault().lookup(SelectedFilesMetaDataEditor.class);
        JPanel panel = editor.getEditPanelForMetaDataValue(XmpDcSubjectsSubjectMetaDataValue.INSTANCE);
        if (panel instanceof EditRepeatableTextEntryPanel) {
            EditRepeatableTextEntryPanel editPanel = (EditRepeatableTextEntryPanel)panel;
            if (editPanel.isEditable()) {
                for (String keywordName : keywordNames) {
                    editPanel.addText(keywordName);
                }
                KeywordsUtil.addHighlightKeywords(keywordNames);
                editor.saveIfDirtyAndInputIsSaveEarly();
            } else {
                String message = Bundle.getString(AddKeywordsToEditPanelController.class, "AddKeywordsToEditPanelController.Error.EditDisabled", new Object[0]);
                MessageDisplayer.error(null, message);
            }
        } else {
            String message = Bundle.getString(AddKeywordsToEditPanelController.class, "AddKeywordsToEditPanelController.Error.NoEditPanel", new Object[0]);
            MessageDisplayer.error(null, message);
        }
    }

    private void addParentKeywords(DefaultMutableTreeNode node, List<String> keywords) {
        TreeNode parent;
        Keyword keyword;
        Object userObject = node.getUserObject();
        if (userObject instanceof Keyword && (keyword = (Keyword)userObject).isReal().booleanValue()) {
            keywords.add(keyword.getName());
        }
        if ((parent = node.getParent()) == null || this.getHKPanel().getTree().getModel().getRoot().equals(parent)) {
            return;
        }
        if (parent instanceof DefaultMutableTreeNode) {
            this.addParentKeywords((DefaultMutableTreeNode)parent, keywords);
        }
    }
}

