/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.list;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jphototagger.api.windows.MainWindowManager;
import org.jphototagger.api.windows.WaitDisplayer;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.thumbnails.OriginOfDisplayedThumbnails;
import org.jphototagger.domain.thumbnails.ThumbnailsPanelSettings;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.keywords.list.KeywordsListControllerUtil;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class ShowThumbnailsContainingAllKeywords2
implements Runnable {
    private final List<List<String>> keywordLists;
    private final ImageFilesRepository repo = Lookup.getDefault().lookup(ImageFilesRepository.class);
    private final ThumbnailsPanelSettings settings;

    public ShowThumbnailsContainingAllKeywords2(List<List<String>> keywordLists, ThumbnailsPanelSettings settings) {
        if (keywordLists == null) {
            throw new NullPointerException("keywordLists == null");
        }
        if (settings == null) {
            throw new NullPointerException("settings == null");
        }
        this.keywordLists = this.deepCopy(keywordLists);
        this.settings = settings;
    }

    @Override
    public void run() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                WaitDisplayer waitDisplayer = Lookup.getDefault().lookup(WaitDisplayer.class);
                waitDisplayer.show();
                ShowThumbnailsContainingAllKeywords2.this.setFilesToThumbnailsPanel();
                waitDisplayer.hide();
            }
        });
    }

    private void setFilesToThumbnailsPanel() {
        List<File> imageFiles = this.getImageFilesOfKeywords();
        GUI.getThumbnailsPanel().setFiles(imageFiles, OriginOfDisplayedThumbnails.FILES_MATCHING_A_KEYWORD);
        GUI.getThumbnailsPanel().applyThumbnailsPanelSettings(this.settings);
    }

    private List<File> getImageFilesOfKeywords() {
        ArrayList<File> imageFiles = new ArrayList<File>();
        for (List<String> keywords : this.keywordLists) {
            if (keywords.size() == 1) {
                imageFiles.addAll(this.repo.findImageFilesContainingDcSubject(keywords.get(0), false));
                this.setTitle(keywords.get(0));
                continue;
            }
            if (keywords.size() <= 1) continue;
            this.setTitle(keywords);
            imageFiles.addAll(this.repo.findImageFilesContainingAllDcSubjects(keywords));
        }
        return imageFiles;
    }

    private void setTitle(List<String> keywords) {
        String keywordPathString = KeywordsListControllerUtil.keywordPathString(keywords);
        String title = Bundle.getString(ShowThumbnailsContainingAllKeywords2.class, "ShowThumbnailsContainingAllKeywords2.AppFrame.Title.Keywords.Path", keywordPathString);
        MainWindowManager mainWindowManager = Lookup.getDefault().lookup(MainWindowManager.class);
        mainWindowManager.setMainWindowTitle(title);
    }

    private void setTitle(String keyword) {
        String title = Bundle.getString(ShowThumbnailsContainingAllKeywords2.class, "ShowThumbnailsContainingAllKeywords2.AppFrame.Title.Keyword", keyword);
        MainWindowManager mainWindowManager = Lookup.getDefault().lookup(MainWindowManager.class);
        mainWindowManager.setMainWindowTitle(title);
    }

    private List<List<String>> deepCopy(List<List<String>> kwLists) {
        ArrayList<List<String>> copy = new ArrayList<List<String>>(kwLists.size());
        for (List<String> kwList : kwLists) {
            copy.add(new ArrayList<String>(kwList));
        }
        return copy;
    }
}

