/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.list;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jphototagger.api.windows.MainWindowManager;
import org.jphototagger.api.windows.WaitDisplayer;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.thumbnails.OriginOfDisplayedThumbnails;
import org.jphototagger.domain.thumbnails.ThumbnailsPanelSettings;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.keywords.list.KeywordsListControllerUtil;
import org.jphototagger.program.module.thumbnails.ThumbnailsPanel;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class ShowThumbnailsContainingAllKeywords
implements Runnable {
    private final List<String> keywords;
    private final ThumbnailsPanelSettings tnPanelSettings;
    private final ImageFilesRepository repo = Lookup.getDefault().lookup(ImageFilesRepository.class);

    public ShowThumbnailsContainingAllKeywords(List<String> keywords, ThumbnailsPanelSettings settings) {
        if (keywords == null) {
            throw new NullPointerException("keywords == null");
        }
        this.keywords = new ArrayList<String>(keywords);
        this.tnPanelSettings = settings;
    }

    @Override
    public void run() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                WaitDisplayer waitDisplayer = Lookup.getDefault().lookup(WaitDisplayer.class);
                waitDisplayer.show();
                ShowThumbnailsContainingAllKeywords.this.setFilesToThumbnailsPanel();
                waitDisplayer.hide();
            }
        });
    }

    private void setFilesToThumbnailsPanel() {
        ArrayList<File> imageFiles = new ArrayList<File>(this.getImageFilesOfKeywords());
        ThumbnailsPanel tnPanel = GUI.getThumbnailsPanel();
        tnPanel.setFiles(imageFiles, OriginOfDisplayedThumbnails.FILES_MATCHING_A_KEYWORD);
        tnPanel.applyThumbnailsPanelSettings(this.tnPanelSettings);
    }

    private Set<File> getImageFilesOfKeywords() {
        if (this.keywords.size() == 1) {
            this.setTitle(this.keywords.get(0));
            return this.repo.findImageFilesContainingDcSubject(this.keywords.get(0), false);
        }
        if (this.keywords.size() > 1) {
            this.setTitle(this.keywords);
            return this.repo.findImageFilesContainingAllDcSubjects(this.keywords);
        }
        return Collections.emptySet();
    }

    private void setTitle(List<String> keywords) {
        String keywordPathString = KeywordsListControllerUtil.keywordPathString(keywords);
        String title = Bundle.getString(ShowThumbnailsContainingAllKeywords.class, "ShowThumbnailsContainingAllKeywords.AppFrame.Title.Keywords.Path", keywordPathString);
        MainWindowManager mainWindowManager = Lookup.getDefault().lookup(MainWindowManager.class);
        mainWindowManager.setMainWindowTitle(title);
    }

    private void setTitle(String keyword) {
        String title = Bundle.getString(ShowThumbnailsContainingAllKeywords.class, "ShowThumbnailsContainingAllKeywords.AppFrame.Title.Keyword", keyword);
        MainWindowManager mainWindowManager = Lookup.getDefault().lookup(MainWindowManager.class);
        mainWindowManager.setMainWindowTitle(title);
    }
}

