/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.list;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.List;
import org.jphototagger.lib.swing.InputDialog;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.misc.InputHelperDialog;
import org.jphototagger.program.module.keywords.KeywordsUtil;
import org.jphototagger.program.module.keywords.list.KeywordsListController;
import org.jphototagger.program.module.keywords.list.KeywordsListPopupMenu;

public final class RenameKeywordsController
extends KeywordsListController {
    public RenameKeywordsController() {
        this.listenToActionsOf(KeywordsListPopupMenu.INSTANCE.getItemRename());
    }

    @Override
    protected boolean myKey(KeyEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return evt.getKeyCode() == 113;
    }

    @Override
    protected boolean myAction(ActionEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return evt.getSource() == KeywordsListPopupMenu.INSTANCE.getItemRename();
    }

    @Override
    protected void action(List<String> keywords) {
        if (keywords == null) {
            throw new NullPointerException("keywords == null");
        }
        int size = keywords.size();
        if (size == 1) {
            String fromName = keywords.get(0);
            String toName = this.getNewName(fromName);
            if (toName != null && !toName.equals(fromName)) {
                KeywordsUtil.renameDcSubject(fromName, toName);
            }
        } else if (size > 1) {
            String message = Bundle.getString(RenameKeywordsController.class, "RenameKeywordsController.Info.MultipleSelected", new Object[0]);
            MessageDisplayer.information(null, message);
        }
    }

    private String getNewName(String fromName) {
        assert (fromName != null && fromName.trim().length() > 0) : fromName;
        boolean finished = false;
        InputHelperDialog owner = InputHelperDialog.INSTANCE;
        String info = Bundle.getString(RenameKeywordsController.class, "RenameKeywordsController.Info.Input", new Object[0]);
        String input = fromName;
        InputDialog dlg = new InputDialog(owner, info, input);
        while (!finished) {
            boolean equals;
            dlg.setVisible(true);
            boolean bl = finished = !dlg.isAccepted();
            if (!dlg.isAccepted()) continue;
            String newName = dlg.getInput();
            boolean bl2 = equals = newName != null && !newName.trim().isEmpty() && newName.equals(fromName);
            if (equals) {
                String message = Bundle.getString(RenameKeywordsController.class, "RenameKeywordsController.Confirm.NewName", new Object[0]);
                finished = !MessageDisplayer.confirmYesNo(dlg, message);
                continue;
            }
            return newName;
        }
        return null;
    }
}

