/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.domain.repository.RepositoryStatistics;
import org.jphototagger.domain.repository.event.dcsubjects.DcSubjectDeletedEvent;
import org.jphototagger.domain.repository.event.dcsubjects.DcSubjectInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpDeletedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.openide.util.Lookup;

public final class KeywordsListModel
extends DefaultListModel<Object> {
    private static final long serialVersionUID = 1L;
    private final ImageFilesRepository imageFileRepo = Lookup.getDefault().lookup(ImageFilesRepository.class);

    public KeywordsListModel() {
        this.addElements();
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    private void addElements() {
        Repository repo = Lookup.getDefault().lookup(Repository.class);
        if (repo == null || !repo.isInit()) {
            return;
        }
        Set<String> keywords = this.imageFileRepo.findAllDcSubjects();
        for (String keyword : keywords) {
            this.addElement(keyword);
        }
    }

    private void addNewKeywords(Collection<? extends String> keywords) {
        for (String string : keywords) {
            if (this.containsKeyword(string)) continue;
            this.addElement(string);
        }
    }

    private boolean containsKeyword(String keyword) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Object element = e.nextElement();
            if (!(element instanceof String) || !((String)element).equalsIgnoreCase(keyword)) continue;
            return true;
        }
        return false;
    }

    private void removeKeywordsNotInDb(Collection<? extends String> keywords) {
        for (String string : keywords) {
            if (!this.contains(string) || this.repositoryHasKeyword(string)) continue;
            this.removeElement(string);
        }
    }

    boolean repositoryHasKeyword(String keyword) {
        RepositoryStatistics repoStatistics = Lookup.getDefault().lookup(RepositoryStatistics.class);
        return repoStatistics.existsMetaDataValue(XmpDcSubjectsSubjectMetaDataValue.INSTANCE, keyword);
    }

    private List<String> getKeywords(Xmp xmp) {
        ArrayList<String> keywords = new ArrayList<String>();
        if (xmp.contains(XmpDcSubjectsSubjectMetaDataValue.INSTANCE)) {
            keywords.addAll((List)xmp.getValue(XmpDcSubjectsSubjectMetaDataValue.INSTANCE));
        }
        return keywords;
    }

    @EventSubscriber(eventClass=XmpInsertedEvent.class)
    public void xmpInserted(XmpInsertedEvent evt) {
        this.addNewKeywords(this.getKeywords(evt.getXmp()));
    }

    @EventSubscriber(eventClass=XmpDeletedEvent.class)
    public void xmpDeleted(XmpDeletedEvent evt) {
        this.removeKeywordsNotInDb(this.getKeywords(evt.getXmp()));
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        this.addNewKeywords(this.getKeywords(evt.getUpdatedXmp()));
        this.removeKeywordsNotInDb(this.getKeywords(evt.getOldXmp()));
    }

    @EventSubscriber(eventClass=DcSubjectDeletedEvent.class)
    public void dcSubjectDeleted(DcSubjectDeletedEvent evt) {
        this.removeKeywordsNotInDb(Collections.singleton(evt.getDcSubject()));
    }

    @EventSubscriber(eventClass=DcSubjectInsertedEvent.class)
    public void dcSubjectInserted(DcSubjectInsertedEvent evt) {
        this.addNewKeywords(Collections.singleton(evt.getDcSubject()));
    }
}

