/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.list;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.List;
import org.jdesktop.swingx.JXList;
import org.jphototagger.program.misc.InputHelperDialog;
import org.jphototagger.program.module.Controller;
import org.jphototagger.program.module.keywords.KeywordsUtil;
import org.jphototagger.program.module.keywords.list.KeywordsListModel;
import org.jphototagger.program.module.keywords.list.KeywordsListPopupMenu;
import org.jphototagger.program.resource.GUI;

public abstract class KeywordsListController
extends Controller {
    protected abstract void action(List<String> var1);

    protected KeywordsListController() {
        this.listen();
    }

    private void listen() {
        this.listenToKeyEventsOf(GUI.getAppPanel().getListEditKeywords(), InputHelperDialog.INSTANCE.getPanelKeywords().getList());
    }

    @Override
    protected void action(ActionEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        this.action(Arrays.asList(this.getStringOfPopupMenu()));
    }

    @Override
    protected void action(KeyEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        Object source = evt.getSource();
        if (source instanceof JXList) {
            JXList jxList = (JXList)source;
            this.action(KeywordsUtil.getSelectedKeywordsFromList(jxList));
        }
    }

    protected KeywordsListModel getModel() {
        return (KeywordsListModel)GUI.getAppPanel().getListEditKeywords().getModel();
    }

    private String getStringOfPopupMenu() {
        JXList list = KeywordsListPopupMenu.INSTANCE.getList();
        int listIndex = KeywordsListPopupMenu.INSTANCE.getSelIndex();
        if (listIndex < 0) {
            return "";
        }
        int modelIndex = list.convertIndexToModel(listIndex);
        return (String)list.getModel().getElementAt(modelIndex);
    }
}

