/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.list;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.swingx.JXList;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.repository.event.xmp.XmpDeletedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.domain.thumbnails.ThumbnailsPanelSettings;
import org.jphototagger.domain.thumbnails.event.ThumbnailsPanelRefreshEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.program.module.keywords.KeywordsUtil;
import org.jphototagger.program.module.keywords.list.ShowThumbnailsContainingAllKeywords;
import org.jphototagger.program.module.keywords.list.ShowThumbnailsContainingKeywords;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class KeywordListItemSelectedController
implements ActionListener,
ListSelectionListener {
    private static final String KEY_RADIO_BUTTON = "ControllerKeywordItemSelected.RadioButton";
    private final List<String> selectedKeywords = new ArrayList<String>();

    public KeywordListItemSelectedController() {
        this.readPersistent();
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
        GUI.getSelKeywordsList().addListSelectionListener(this);
        this.getRadioButtonAllKeywords().addActionListener(this);
        this.getRadioButtonOneKeyword().addActionListener(this);
    }

    private JRadioButton getRadioButtonAllKeywords() {
        return GUI.getAppPanel().getRadioButtonSelKeywordsMultipleSelAll();
    }

    private JRadioButton getRadioButtonOneKeyword() {
        return GUI.getAppPanel().getRadioButtonSelKeywordsMultipleSelOne();
    }

    private boolean isKeywordSelected() {
        return GUI.getSelKeywordsList().getSelectedIndex() >= 0;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.isKeywordSelected()) {
            this.writePersistent();
            this.update(null);
        }
    }

    @EventSubscriber(eventClass=ThumbnailsPanelRefreshEvent.class)
    public void refresh(ThumbnailsPanelRefreshEvent evt) {
        if (this.isKeywordSelected() && evt.getOriginOfDisplayedThumbnails().isFilesMatchingAKeyword()) {
            this.update(evt);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.selectedKeywords.clear();
            if (this.isKeywordSelected()) {
                this.selectedKeywords.addAll(this.getSelectedKeywords());
                this.update(null);
            }
        }
    }

    private List<String> getSelectedKeywords() {
        JXList listSelKeywords = GUI.getSelKeywordsList();
        return KeywordsUtil.getSelectedKeywordsFromList(listSelKeywords);
    }

    private void update(ThumbnailsPanelRefreshEvent evt) {
        EventQueueUtil.invokeInDispatchThread(this.isAllKeywords() ? new ShowThumbnailsContainingAllKeywords(this.selectedKeywords, evt == null ? this.createThumbnailsPanelSettings() : evt.getThumbnailsPanelSettings()) : new ShowThumbnailsContainingKeywords(this.selectedKeywords, evt == null ? this.createThumbnailsPanelSettings() : evt.getThumbnailsPanelSettings()));
    }

    private boolean isAllKeywords() {
        return this.getRadioButtonAllKeywords().isSelected();
    }

    private void readPersistent() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        boolean radioButtonAll = true;
        if (prefs.containsKey(KEY_RADIO_BUTTON)) {
            radioButtonAll = prefs.getInt(KEY_RADIO_BUTTON) == 0;
        }
        this.getRadioButtonAllKeywords().setSelected(radioButtonAll);
        this.getRadioButtonOneKeyword().setSelected(!radioButtonAll);
    }

    private void writePersistent() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setInt(KEY_RADIO_BUTTON, this.isAllKeywords() ? 0 : 1);
    }

    @EventSubscriber(eventClass=XmpDeletedEvent.class)
    public void xmpDeleted(XmpDeletedEvent evt) {
        if (this.isKeywordSelected() && evt.getXmp().containsOneOf(XmpDcSubjectsSubjectMetaDataValue.INSTANCE, this.selectedKeywords)) {
            this.update(null);
        }
    }

    @EventSubscriber(eventClass=XmpInsertedEvent.class)
    public void xmpInserted(XmpInsertedEvent evt) {
        if (this.isKeywordSelected() && evt.getXmp().containsOneOf(XmpDcSubjectsSubjectMetaDataValue.INSTANCE, this.selectedKeywords)) {
            this.update(null);
        }
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        if (this.isKeywordSelected() && (Xmp.valueDeleted(evt.getOldXmp(), evt.getUpdatedXmp(), XmpDcSubjectsSubjectMetaDataValue.INSTANCE, this.selectedKeywords) || Xmp.valueInserted(evt.getOldXmp(), evt.getUpdatedXmp(), XmpDcSubjectsSubjectMetaDataValue.INSTANCE, this.selectedKeywords))) {
            this.update(null);
        }
    }

    public ThumbnailsPanelSettings createThumbnailsPanelSettings() {
        ThumbnailsPanelSettings settings = new ThumbnailsPanelSettings(GUI.getThumbnailsPanel().getViewPosition(), Collections.emptyList());
        settings.setSelectedFiles(GUI.getThumbnailsPanel().getSelectedFiles());
        return settings;
    }
}

