/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.list;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.metadata.SelectedFilesMetaDataEditor;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.repository.SynonymsRepository;
import org.jphototagger.lib.swing.InputDialog;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.misc.InputHelperDialog;
import org.jphototagger.program.module.editmetadata.EditRepeatableTextEntryPanel;
import org.jphototagger.program.module.keywords.list.KeywordsListController;
import org.jphototagger.program.module.keywords.list.KeywordsListPopupMenu;
import org.openide.util.Lookup;

public final class EditKeywordSynonymsController
extends KeywordsListController
implements PopupMenuListener {
    private static final String DELIM = ";";
    private static final String DISPLAYNAME = Bundle.getString(EditKeywordSynonymsController.class, "EditKeywordSynonymsController.MenuItemEditSynonyms.DisplayName", new Object[0]);
    private final JMenuItem itemEditSynonyms = new JMenuItem(DISPLAYNAME);
    private final SynonymsRepository repo = Lookup.getDefault().lookup(SynonymsRepository.class);

    public EditKeywordSynonymsController() {
        this.addMenuItem();
        this.listen();
    }

    private void listen() {
        this.listenToActionsOf(KeywordsListPopupMenu.INSTANCE.getItemEditSynonyms(), this.itemEditSynonyms);
        this.getKeywordsList().addKeyListener(this);
        this.getPopupMenu().addPopupMenuListener(this);
    }

    private EditRepeatableTextEntryPanel getKeywordsPanel() {
        SelectedFilesMetaDataEditor editor = Lookup.getDefault().lookup(SelectedFilesMetaDataEditor.class);
        return (EditRepeatableTextEntryPanel)editor.getEditPanelForMetaDataValue(XmpDcSubjectsSubjectMetaDataValue.INSTANCE);
    }

    private JXList getKeywordsList() {
        return this.getKeywordsPanel().getList();
    }

    private JPopupMenu getPopupMenu() {
        return this.getKeywordsPanel().getPopupMenu();
    }

    private void addMenuItem() {
        this.itemEditSynonyms.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(83));
        JPopupMenu popupMenu = this.getPopupMenu();
        popupMenu.add(new JPopupMenu.Separator());
        popupMenu.add(this.itemEditSynonyms);
    }

    private void editInEditList() {
        ArrayList<String> keywords = new ArrayList<String>();
        for (Object selValue : this.getKeywordsList().getSelectedValues()) {
            keywords.add(selValue.toString());
        }
        if (!keywords.isEmpty()) {
            this.action(keywords);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.itemEditSynonyms) {
            this.editInEditList();
        } else {
            super.actionPerformed(evt);
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (evt.getSource() == this.getKeywordsList() && this.myKey(evt)) {
            this.editInEditList();
        } else {
            super.keyPressed(evt);
        }
    }

    private boolean itemsInEditListSelected() {
        return this.getKeywordsList().getSelectedValue() != null;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
        boolean selected = this.itemsInEditListSelected();
        EditRepeatableTextEntryPanel editPanel = this.getKeywordsPanel();
        editPanel.getItemRename().setEnabled(selected);
        editPanel.getItemRemove().setEnabled(selected);
        this.itemEditSynonyms.setEnabled(selected);
    }

    @Override
    protected boolean myKey(KeyEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return KeyEventUtil.isMenuShortcutWithAlt(evt, 83);
    }

    @Override
    protected boolean myAction(ActionEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return evt.getSource() == KeywordsListPopupMenu.INSTANCE.getItemEditSynonyms();
    }

    @Override
    protected void action(List<String> keywords) {
        if (keywords == null) {
            throw new NullPointerException("keywords == null");
        }
        for (String keyword : keywords) {
            this.editSynonyms(keyword);
        }
    }

    private void editSynonyms(String keyword) {
        Set<String> oldSynonyms = this.repo.findSynonymsOfWord(keyword);
        InputHelperDialog owner = InputHelperDialog.INSTANCE;
        String info = Bundle.getString(EditKeywordSynonymsController.class, "EditKeywordSynonymsController.Info.Input", keyword, DELIM);
        String input = this.catSynonyms(oldSynonyms);
        InputDialog dlg = new InputDialog(owner, info, input);
        dlg.setVisible(true);
        String synonyms = dlg.getInput();
        if (dlg.isAccepted() && synonyms != null) {
            Set<String> newSynonyms = this.splitSynonyms(synonyms);
            for (String synonym : newSynonyms) {
                this.repo.saveSynonym(keyword, synonym);
            }
            SynonymsRepository synonymsRepo = Lookup.getDefault().lookup(SynonymsRepository.class);
            for (String synonym : oldSynonyms) {
                if (newSynonyms.contains(synonym)) continue;
                synonymsRepo.deleteSynonym(keyword, synonym);
            }
        }
    }

    private Set<String> splitSynonyms(String synonymString) {
        HashSet<String> synonyms = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(synonymString, DELIM);
        while (st.hasMoreTokens()) {
            String synonym = st.nextToken().trim();
            if (synonym.isEmpty()) continue;
            synonyms.add(synonym);
        }
        return synonyms;
    }

    private String catSynonyms(Set<String> synonyms) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String synonym : synonyms) {
            sb.append(i == 0 ? "" : DELIM);
            sb.append(synonym);
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent evt) {
    }
}

