/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords.list;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.List;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.misc.InputHelperDialog;
import org.jphototagger.program.module.keywords.KeywordsUtil;
import org.jphototagger.program.module.keywords.list.KeywordsListController;
import org.jphototagger.program.module.keywords.list.KeywordsListPopupMenu;

public final class DeleteKeywordsController
extends KeywordsListController {
    public DeleteKeywordsController() {
        this.listenToActionsOf(KeywordsListPopupMenu.INSTANCE.getItemDelete());
    }

    @Override
    protected boolean myKey(KeyEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return evt.getKeyCode() == 127;
    }

    @Override
    protected boolean myAction(ActionEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return evt.getSource() == KeywordsListPopupMenu.INSTANCE.getItemDelete();
    }

    @Override
    protected void action(List<String> keywords) {
        String message;
        if (keywords == null) {
            throw new NullPointerException("keywords == null");
        }
        int size = keywords.size();
        if (size == 1) {
            String keyword = keywords.get(0);
            String message2 = Bundle.getString(DeleteKeywordsController.class, "DeleteKeywordsController.List.Confirm.Delete", keyword);
            if (MessageDisplayer.confirmYesNo(InputHelperDialog.INSTANCE, message2)) {
                KeywordsUtil.deleteDcSubject(keyword);
            }
        } else if (size > 1 && MessageDisplayer.confirmYesNo(InputHelperDialog.INSTANCE, message = Bundle.getString(DeleteKeywordsController.class, "DeleteKeywordsController.List.Confirm.DeleteMultiple", size))) {
            for (String keyword : keywords) {
                KeywordsUtil.deleteDcSubject(keyword);
            }
        }
    }
}

