/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXTree;
import org.jphototagger.api.concurrent.SerialTaskExecutor;
import org.jphototagger.domain.image.ImageFile;
import org.jphototagger.domain.metadata.SelectedFilesMetaDataEditor;
import org.jphototagger.domain.metadata.keywords.Keyword;
import org.jphototagger.domain.metadata.xmp.FileXmp;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpLastModifiedMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.repository.KeywordsRepository;
import org.jphototagger.domain.repository.SaveOrUpdate;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.concurrent.HelperThread;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.ListUtil;
import org.jphototagger.lib.swing.util.TreeUtil;
import org.jphototagger.lib.util.ArrayUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.ui.AppPanel;
import org.jphototagger.program.factory.ModelFactory;
import org.jphototagger.program.misc.InputHelperDialog;
import org.jphototagger.program.misc.SaveXmp;
import org.jphototagger.program.module.keywords.tree.KeywordsTreeCellRenderer;
import org.jphototagger.program.module.keywords.tree.KeywordsTreeModel;
import org.jphototagger.program.resource.GUI;
import org.jphototagger.xmp.XmpMetadata;
import org.openide.util.Lookup;

public final class KeywordsUtil {
    private static final Logger LOGGER = Logger.getLogger(KeywordsUtil.class.getName());
    private static final ImageFilesRepository imageFileRepo = Lookup.getDefault().lookup(ImageFilesRepository.class);
    private static final XmpSidecarFileResolver XMP_SIDECAR_FILE_RESOLVER = Lookup.getDefault().lookup(XmpSidecarFileResolver.class);

    private KeywordsUtil() {
    }

    public static void addKeywordsToEditPanel(final DefaultMutableTreeNode node) {
        if (node == null) {
            throw new NullPointerException("node == null");
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                SelectedFilesMetaDataEditor editor = Lookup.getDefault().lookup(SelectedFilesMetaDataEditor.class);
                List<String> keywordStrings = KeywordsUtil.getKeywordStrings(node, true);
                for (String keyword : keywordStrings) {
                    editor.setOrAddText(XmpDcSubjectsSubjectMetaDataValue.INSTANCE, keyword);
                }
                if (keywordStrings.size() > 1) {
                    Collections.reverse(keywordStrings);
                }
            }
        });
    }

    public static void insertDcSubject(String dcSubject) {
        if (!imageFileRepo.existsDcSubject(dcSubject)) {
            imageFileRepo.saveDcSubject(dcSubject);
        }
    }

    public static void insertDcSubject() {
        String input;
        String info = Bundle.getString(KeywordsUtil.class, "KeywordsUtil.Input.InsertDcSubject", new Object[0]);
        String dcSubject = MessageDisplayer.input(info, input = "");
        if (dcSubject != null && KeywordsUtil.checkExistsDcSubject(dcSubject)) {
            if (imageFileRepo.saveDcSubject(dcSubject)) {
                KeywordsUtil.insertDcSubjectAsKeyword(dcSubject);
            } else {
                String message = Bundle.getString(KeywordsUtil.class, "KeywordsUtil.Error.InsertDcSubject", dcSubject);
                MessageDisplayer.error(null, message);
            }
        }
    }

    private static void insertDcSubjectAsKeyword(String keyword) {
        KeywordsRepository repo = Lookup.getDefault().lookup(KeywordsRepository.class);
        if (!repo.existsKeyword(keyword)) {
            repo.saveKeyword(new Keyword(null, null, keyword, true));
        }
    }

    private static boolean checkExistsDcSubject(String dcSubject) {
        if (imageFileRepo.existsDcSubject(dcSubject)) {
            String message = Bundle.getString(KeywordsUtil.class, "KeywordsUtil.Error.DcSubjectExists", dcSubject);
            MessageDisplayer.error(null, message);
            return false;
        }
        return true;
    }

    public static void saveKeywordsToImageFile(List<String> keywordStrings, File imageFile) {
        if (keywordStrings == null) {
            throw new NullPointerException("keywordStrings == null");
        }
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        if (!imageFile.exists()) {
            return;
        }
        Xmp xmp = null;
        try {
            xmp = XmpMetadata.getXmpFromSidecarFileOf(imageFile);
        }
        catch (IOException ex) {
            Logger.getLogger(KeywordsUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (xmp == null) {
            xmp = new Xmp();
        }
        for (String keyword : keywordStrings) {
            if (xmp.containsValue(XmpDcSubjectsSubjectMetaDataValue.INSTANCE, keyword)) continue;
            xmp.setValue(XmpDcSubjectsSubjectMetaDataValue.INSTANCE, keyword);
        }
        ArrayList<FileXmp> saveList = new ArrayList<FileXmp>();
        saveList.add(new FileXmp(imageFile, xmp));
        SaveXmp.save(saveList);
    }

    public static List<Keyword> getKeywords(DefaultMutableTreeNode node, boolean real) {
        ArrayList<Keyword> list = new ArrayList<Keyword>();
        DefaultMutableTreeNode n = node;
        while (n != null) {
            TreeNode parent;
            Object userObject = n.getUserObject();
            if (userObject instanceof Keyword) {
                Keyword keyword = (Keyword)userObject;
                if (!real || real && keyword.isReal().booleanValue()) {
                    list.add(keyword);
                }
            }
            n = (parent = n.getParent()) instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)parent : null;
        }
        return list;
    }

    public static List<String> getKeywordStrings(DefaultMutableTreeNode node, boolean real) {
        ArrayList<String> list = new ArrayList<String>();
        for (Keyword keyword : KeywordsUtil.getKeywords(node, real)) {
            list.add(keyword.getName());
        }
        return list;
    }

    public static void selectNode(final JTree tree, final Keyword keyword) {
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        if (keyword == null) {
            throw new NullPointerException("keyword == null");
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                KeywordsTreeModel model = ModelFactory.INSTANCE.getModel(KeywordsTreeModel.class);
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
                DefaultMutableTreeNode selNode = null;
                Enumeration<TreeNode> e = root.breadthFirstEnumeration();
                while (selNode == null && e.hasMoreElements()) {
                    Keyword hkw;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                    Object userObject = node.getUserObject();
                    if (!(userObject instanceof Keyword) || !(hkw = (Keyword)userObject).equals(keyword)) continue;
                    selNode = node;
                }
                if (selNode != null) {
                    tree.setSelectionPath(new TreePath(selNode.getPath()));
                }
            }
        });
    }

    public static List<String> getParentKeywordNames(Keyword keyword, boolean real) {
        ArrayList<String> names = new ArrayList<String>();
        KeywordsRepository repo = Lookup.getDefault().lookup(KeywordsRepository.class);
        List<Keyword> parents = repo.findParentKeywords(keyword);
        for (Keyword parent : parents) {
            boolean add = !real || real && parent.isReal() != false;
            if (!add) continue;
            names.add(parent.getName());
        }
        return names;
    }

    public static void addHighlightKeywords(final Collection<String> keywords) {
        if (keywords == null) {
            throw new NullPointerException("keywords == null");
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                for (KeywordsTreeCellRenderer treeCellRendererKeywords : KeywordsUtil.getCellRenderer()) {
                    treeCellRendererKeywords.addSelImgKeywords(keywords);
                }
            }
        });
    }

    public static void removeHighlightKeyword(final String keyword) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                for (KeywordsTreeCellRenderer treeCellRendererKeywords : KeywordsUtil.getCellRenderer()) {
                    treeCellRendererKeywords.removeSelImgKeyword(keyword);
                }
            }
        });
    }

    private static List<KeywordsTreeCellRenderer> getCellRenderer() {
        ArrayList<KeywordsTreeCellRenderer> renderer = new ArrayList<KeywordsTreeCellRenderer>();
        for (JTree tree : KeywordsUtil.getKeywordTrees()) {
            TreeCellRenderer treeCellRenderer = tree.getCellRenderer();
            if (treeCellRenderer instanceof JXTree.DelegatingRenderer) {
                treeCellRenderer = ((JXTree.DelegatingRenderer)treeCellRenderer).getDelegateRenderer();
            }
            if (!(treeCellRenderer instanceof KeywordsTreeCellRenderer)) continue;
            renderer.add((KeywordsTreeCellRenderer)treeCellRenderer);
        }
        return renderer;
    }

    private static List<JTree> getKeywordTrees() {
        return Arrays.asList(GUI.getAppPanel().getTreeEditKeywords(), GUI.getAppPanel().getTreeSelKeywords(), InputHelperDialog.INSTANCE.getPanelKeywords().getTree());
    }

    public static void selectInSelKeywordsList(final List<Integer> modelIndices) {
        if (modelIndices == null) {
            throw new NullPointerException("indices == null");
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                JXList selKeywordsList = GUI.getAppPanel().getListSelKeywords();
                selKeywordsList.clearSelection();
                GUI.getAppPanel().displaySelKeywordsList(AppPanel.SelectAlso.SEL_KEYWORDS_TAB);
                if (!modelIndices.isEmpty()) {
                    List<Integer> listIndices = ListUtil.convertModelIndicesToListIndices(modelIndices, selKeywordsList);
                    selKeywordsList.setSelectedIndices(ArrayUtil.toIntArray(listIndices));
                    selKeywordsList.ensureIndexIsVisible(listIndices.get(0));
                }
            }
        });
    }

    public static List<String> getSelectedKeywordsFromList(JXList keywordsList) {
        int[] selectedIndices;
        if (keywordsList == null) {
            throw new NullPointerException("keywordsList == null");
        }
        ArrayList<String> selectedKeywords = new ArrayList<String>();
        ListModel listModel = keywordsList.getModel();
        for (int selectedIndex : selectedIndices = keywordsList.getSelectedIndices()) {
            int modelIndex = keywordsList.convertIndexToModel(selectedIndex);
            Object selectedElement = listModel.getElementAt(modelIndex);
            if (!(selectedElement instanceof String)) continue;
            selectedKeywords.add((String)selectedElement);
        }
        return selectedKeywords;
    }

    public static void expandAllTreesTo(final DefaultMutableTreeNode node) {
        if (node == null) {
            throw new NullPointerException("node == null");
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                for (JTree tree : KeywordsUtil.getKeywordTrees()) {
                    TreeUtil.expandPath(tree, new TreePath(node.getPath()));
                }
            }
        });
    }

    public static void renameDcSubject(String fromName, String toName) {
        if (fromName == null) {
            throw new NullPointerException("fromName == null");
        }
        if (toName == null) {
            throw new NullPointerException("toName == null");
        }
        if (!fromName.equals(toName)) {
            SerialTaskExecutor executor = Lookup.getDefault().lookup(SerialTaskExecutor.class);
            RenameDcSubject renameDcSubject = new RenameDcSubject(fromName, toName);
            executor.addTask(renameDcSubject);
        }
    }

    public static void deleteDcSubject(String keyword) {
        if (keyword == null) {
            throw new NullPointerException("keyword == null");
        }
        SerialTaskExecutor executor = Lookup.getDefault().lookup(SerialTaskExecutor.class);
        DeleteDcSubject deleteDcSubject = new DeleteDcSubject(keyword);
        executor.addTask(deleteDcSubject);
    }

    private static void updateXmp(Xmp xmp, File file, File sidecarFile) {
        if (XmpMetadata.writeXmpToSidecarFile(xmp, sidecarFile)) {
            ImageFile imageFile = new ImageFile();
            imageFile.setFile(file);
            imageFile.setLastmodified(file.lastModified());
            imageFile.setSizeInBytes(file.length());
            xmp.setValue(XmpLastModifiedMetaDataValue.INSTANCE, sidecarFile.lastModified());
            imageFile.setXmp(xmp);
            imageFile.addToSaveIntoRepository(SaveOrUpdate.XMP);
            imageFileRepo.saveOrUpdateImageFile(imageFile);
        }
    }

    private static class RenameDcSubject
    extends HelperThread {
        private final String toName;
        private final String fromName;
        private volatile boolean cancel;

        private RenameDcSubject(String fromName, String toName) {
            super("JPhotoTagger: Renaming DC subject");
            this.fromName = fromName;
            this.toName = toName;
            this.setInfo(Bundle.getString(RenameDcSubject.class, "KeywordsUtil.Info.Rename", new Object[0]));
        }

        @Override
        public void run() {
            int index;
            ArrayList<File> imageFiles = new ArrayList<File>(imageFileRepo.findImageFilesContainingDcSubject(this.fromName, false));
            RenameDcSubject.logStartRename(this.fromName, this.toName);
            this.progressStarted(0, 0, imageFiles.size(), null);
            int size = imageFiles.size();
            for (index = 0; !this.cancel && !this.isInterrupted() && index < size; ++index) {
                File imageFile = (File)imageFiles.get(index);
                File sidecarFile = XMP_SIDECAR_FILE_RESOLVER.suggestXmpSidecarFile(imageFile);
                Xmp xmp = null;
                try {
                    xmp = XmpMetadata.getXmpFromSidecarFileOf(imageFile);
                }
                catch (IOException ex) {
                    Logger.getLogger(KeywordsUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (xmp != null) {
                    xmp.removeValue(XmpDcSubjectsSubjectMetaDataValue.INSTANCE, this.fromName);
                    xmp.setValue(XmpDcSubjectsSubjectMetaDataValue.INSTANCE, this.toName);
                    KeywordsUtil.updateXmp(xmp, imageFile, sidecarFile);
                }
                this.progressPerformed(index + 1, sidecarFile.getName());
            }
            this.deleteKeyword();
            this.progressEnded(index);
        }

        private void deleteKeyword() {
            if (!imageFileRepo.isDcSubjectReferenced(this.fromName)) {
                imageFileRepo.deleteDcSubject(this.fromName);
            }
        }

        private static void logStartRename(String fromName, String toName) {
            LOGGER.log(Level.INFO, "Rename keyword ''{0}'' into ''{1}'' in the repository and all XMP sidecar files", new Object[]{fromName, toName});
        }

        @Override
        public void cancel() {
            this.cancel = true;
        }
    }

    private static class DeleteDcSubject
    extends HelperThread {
        private final String dcSubject;
        private volatile boolean cancel;

        DeleteDcSubject(String keyword) {
            super("JPhotoTagger: Deleting keyword");
            this.dcSubject = keyword;
            this.setInfo(Bundle.getString(DeleteDcSubject.class, "KeywordsUtil.Info.Delete", new Object[0]));
        }

        @Override
        public void run() {
            int index;
            ArrayList<File> imageFiles = new ArrayList<File>(imageFileRepo.findImageFilesContainingDcSubject(this.dcSubject, false));
            DeleteDcSubject.logStartDelete(this.dcSubject);
            this.progressStarted(0, 0, imageFiles.size(), null);
            int size = imageFiles.size();
            for (index = 0; !this.cancel && !this.isInterrupted() && index < size; ++index) {
                File imageFile = (File)imageFiles.get(index);
                File sidecarFile = XMP_SIDECAR_FILE_RESOLVER.suggestXmpSidecarFile(imageFile);
                Xmp xmp = null;
                try {
                    xmp = XmpMetadata.getXmpFromSidecarFileOf(imageFile);
                }
                catch (IOException ex) {
                    Logger.getLogger(KeywordsUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (xmp != null) {
                    xmp.removeValue(XmpDcSubjectsSubjectMetaDataValue.INSTANCE, this.dcSubject);
                    KeywordsUtil.updateXmp(xmp, imageFile, sidecarFile);
                }
                this.progressPerformed(index, sidecarFile.getName());
            }
            this.checkRepository();
            this.progressEnded(index);
        }

        private static void logStartDelete(String keyword) {
            LOGGER.log(Level.INFO, "Deleting keyword ''{0}'' from the repository and all XMP sidecar files", keyword);
        }

        @Override
        public void cancel() {
            this.cancel = true;
        }

        private void checkRepository() {
            if (imageFileRepo.existsDcSubject(this.dcSubject)) {
                imageFileRepo.deleteDcSubject(this.dcSubject);
            }
        }
    }
}

