/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SortOrder;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXTree;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.swing.WaitListModel;
import org.jphototagger.lib.swing.WaitTreeModel;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.swing.util.TreeUtil;
import org.jphototagger.lib.swingx.ListTextFilter;
import org.jphototagger.lib.swingx.SearchInJxListAction;
import org.jphototagger.lib.swingx.SearchInJxTreeAction;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.datatransfer.DragListItemsTransferHandler;
import org.jphototagger.program.datatransfer.Flavor;
import org.jphototagger.program.module.keywords.KeywordHighlightPredicate;
import org.jphototagger.program.module.keywords.list.KeywordsListCellRenderer;
import org.jphototagger.program.module.keywords.tree.KeywordsTreeCellRenderer;
import org.jphototagger.program.module.keywords.tree.KeywordsTreeTransferHandler;
import org.openide.util.Lookup;

public class KeywordsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ListTextFilter listTextFilter;
    private String keyTree = "KeywordsPanel.Tree.SelectedNode";
    private String keyCard = "KeywordsPanel.Card";
    private JButton buttonAsList;
    private JButton buttonAsTree;
    private JButton buttonSearchInList;
    private JButton buttonSearchInTree;
    private JToggleButton buttonToggleExpandAllNodes;
    private JLabel labelListFilter;
    private JXList list;
    private JPanel panelButtons;
    private JPanel panelList;
    private JPanel panelListFilter;
    private JPanel panelTree;
    private JScrollPane scrollPaneList;
    private JScrollPane scrollPaneTree;
    private JTextField textFieldListFilter;
    private JTree tree;

    public KeywordsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.tree.getSelectionModel().setSelectionMode(4);
        MnemonicUtil.setMnemonics(this);
    }

    private void decorateList() {
        this.listTextFilter = new ListTextFilter(this.list);
        this.listTextFilter.filterOnDocumentChanges(this.textFieldListFilter.getDocument());
        this.list.setAutoCreateRowSorter(true);
        this.list.setSortOrder(SortOrder.ASCENDING);
        this.list.addHighlighter(KeywordHighlightPredicate.getHighlighter());
    }

    public JTree getTree() {
        return this.tree;
    }

    public JXList getList() {
        return this.list;
    }

    public void setListModel(ListModel<?> model) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        this.list.setModel((ListModel)model);
        this.decorateList();
    }

    public void setKeyCard(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.keyCard = key;
    }

    public void setKeyTree(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.keyTree = key;
    }

    public void readProperties() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.applyTreeSettings(this.keyTree, this.tree);
        this.readCardProperties();
    }

    private void readCardProperties() {
        String s;
        String name = "Tree";
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs.containsKey(this.keyCard) && ((s = prefs.getString(this.keyCard)).equals("Tree") || s.equals("List"))) {
            name = s;
        }
        this.displayCard(name);
    }

    private void displayCard(String name) {
        CardLayout cl = (CardLayout)this.getLayout();
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        cl.show(this, name);
        prefs.setString(this.keyCard, name);
    }

    public void writeProperties() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setTree(this.keyTree, this.tree);
    }

    public void expandAll(boolean expand) {
        boolean buttonPressed = this.buttonToggleExpandAllNodes.isSelected();
        if (buttonPressed != expand) {
            this.buttonToggleExpandAllNodes.doClick();
        }
    }

    public boolean isExpandedAll() {
        return this.buttonToggleExpandAllNodes.isSelected();
    }

    private void handleButtonToggleExpandAllNodesActionPerformed() {
        boolean selected = this.buttonToggleExpandAllNodes.isSelected();
        TreeUtil.expandAll(this.tree, selected);
        this.buttonToggleExpandAllNodes.setText(selected ? Bundle.getString(KeywordsPanel.class, "KeywordsPanel.ButtonToggleExpandAllNodes.Selected", new Object[0]) : Bundle.getString(KeywordsPanel.class, "KeywordsPanel.ButtonToggleExpandAllNodes.DeSelected", new Object[0]));
    }

    private void initComponents() {
        this.panelTree = new JPanel();
        this.scrollPaneTree = new JScrollPane();
        this.tree = new JXTree();
        this.tree.setShowsRootHandles(true);
        this.panelButtons = new JPanel();
        this.buttonToggleExpandAllNodes = new JToggleButton();
        this.buttonSearchInTree = new JButton();
        this.buttonAsList = new JButton();
        this.panelList = new JPanel();
        this.panelListFilter = new JPanel();
        this.labelListFilter = new JLabel();
        this.textFieldListFilter = new JTextField();
        this.scrollPaneList = new JScrollPane();
        this.list = new JXList();
        this.list.setTransferHandler(new DragListItemsTransferHandler(Flavor.KEYWORDS_LIST));
        this.buttonSearchInList = new JButton();
        this.buttonAsTree = new JButton();
        this.setName("Form");
        this.setLayout(new CardLayout());
        this.panelTree.setName("panelTree");
        this.panelTree.setLayout(new GridBagLayout());
        this.scrollPaneTree.setName("scrollPaneTree");
        this.tree.setModel(WaitTreeModel.INSTANCE);
        this.tree.setCellRenderer(new KeywordsTreeCellRenderer());
        this.tree.setDragEnabled(true);
        this.tree.setName("tree");
        this.scrollPaneTree.setViewportView(this.tree);
        this.tree.setTransferHandler(new KeywordsTreeTransferHandler());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelTree.add((Component)this.scrollPaneTree, gridBagConstraints);
        this.panelButtons.setName("panelButtons");
        this.panelButtons.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/keywords/Bundle");
        this.buttonToggleExpandAllNodes.setText(bundle.getString("KeywordsPanel.buttonToggleExpandAllNodes.text"));
        this.buttonToggleExpandAllNodes.setMargin(new Insets(1, 1, 1, 1));
        this.buttonToggleExpandAllNodes.setName("buttonToggleExpandAllNodes");
        this.buttonToggleExpandAllNodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeywordsPanel.this.buttonToggleExpandAllNodesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.panelButtons.add((Component)this.buttonToggleExpandAllNodes, gridBagConstraints);
        this.buttonSearchInTree.setAction(new SearchInJxTreeAction((JXTree)this.tree));
        this.buttonSearchInTree.setText(bundle.getString("KeywordsPanel.buttonSearchInTree.text"));
        this.buttonSearchInTree.setMargin(new Insets(1, 1, 1, 1));
        this.buttonSearchInTree.setName("buttonSearchInTree");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.panelButtons.add((Component)this.buttonSearchInTree, gridBagConstraints);
        this.buttonAsList.setText(bundle.getString("KeywordsPanel.buttonAsList.text"));
        this.buttonAsList.setMargin(new Insets(1, 1, 1, 1));
        this.buttonAsList.setName("buttonAsList");
        this.buttonAsList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeywordsPanel.this.buttonAsListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.panelButtons.add((Component)this.buttonAsList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.panelTree.add((Component)this.panelButtons, gridBagConstraints);
        this.add((Component)this.panelTree, "Tree");
        this.panelList.setName("panelList");
        this.panelList.setLayout(new GridBagLayout());
        this.panelListFilter.setName("panelListFilter");
        this.panelListFilter.setLayout(new GridBagLayout());
        this.labelListFilter.setText(bundle.getString("KeywordsPanel.labelListFilter.text"));
        this.labelListFilter.setName("labelListFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelListFilter.add((Component)this.labelListFilter, gridBagConstraints);
        this.textFieldListFilter.setName("textFieldListFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelListFilter.add((Component)this.textFieldListFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelList.add((Component)this.panelListFilter, gridBagConstraints);
        this.scrollPaneList.setName("scrollPaneList");
        this.list.setModel((ListModel)WaitListModel.INSTANCE);
        this.list.setCellRenderer((ListCellRenderer)new KeywordsListCellRenderer());
        this.list.setDragEnabled(true);
        this.list.setName("list");
        this.scrollPaneList.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelList.add((Component)this.scrollPaneList, gridBagConstraints);
        this.buttonSearchInList.setAction(new SearchInJxListAction(this.list));
        this.buttonSearchInList.setText(bundle.getString("KeywordsPanel.buttonSearchInList.text"));
        this.buttonSearchInList.setMargin(new Insets(1, 1, 1, 1));
        this.buttonSearchInList.setName("buttonSearchInList");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelList.add((Component)this.buttonSearchInList, gridBagConstraints);
        this.buttonAsTree.setText(bundle.getString("KeywordsPanel.buttonAsTree.text"));
        this.buttonAsTree.setMargin(new Insets(1, 1, 1, 1));
        this.buttonAsTree.setName("buttonAsTree");
        this.buttonAsTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeywordsPanel.this.buttonAsTreeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelList.add((Component)this.buttonAsTree, gridBagConstraints);
        this.add((Component)this.panelList, "List");
    }

    private void buttonToggleExpandAllNodesActionPerformed(ActionEvent evt) {
        this.handleButtonToggleExpandAllNodesActionPerformed();
    }

    private void buttonAsListActionPerformed(ActionEvent evt) {
        this.displayCard("List");
    }

    private void buttonAsTreeActionPerformed(ActionEvent evt) {
        this.displayCard("Tree");
    }
}

