/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.keywords;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.jphototagger.program.module.keywords.list.KeywordsListCellRenderer;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class KeywordHighlightPredicate
implements HighlightPredicate {
    private static final Highlighter HIGHLIGHTER = KeywordHighlightPredicate.createHighlighter();
    private final ImageFilesRepository repo = Lookup.getDefault().lookup(ImageFilesRepository.class);
    private final Set<String> keywordsOfSelectedImages = new HashSet<String>();
    private final List<File> selectedFiles = new ArrayList<File>();

    public KeywordHighlightPredicate() {
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    private static Highlighter createHighlighter() {
        Color background = AppLookAndFeel.LIST_SEL_IMG_HAS_KEYWORD_BACKGROUND;
        Color foreground = AppLookAndFeel.LIST_SEL_IMG_HAS_KEYWORD_FOREGROUND;
        KeywordHighlightPredicate predicate = new KeywordHighlightPredicate();
        ColorHighlighter highlighter = new ColorHighlighter(predicate, background, foreground);
        return highlighter;
    }

    public static Highlighter getHighlighter() {
        return HIGHLIGHTER;
    }

    @Override
    public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
        boolean isTemporarySelection = this.isTemporarySelection(renderer, adapter.row);
        if (isTemporarySelection) {
            return false;
        }
        Object value = adapter.getValue();
        return value == null ? false : this.containsKeyword(value.toString());
    }

    private boolean containsKeyword(String keyword) {
        for (String kw : this.keywordsOfSelectedImages) {
            if (kw == null || !kw.equalsIgnoreCase(keyword)) continue;
            return true;
        }
        return false;
    }

    private boolean isTemporarySelection(Component renderer, int row) {
        if (renderer instanceof KeywordsListCellRenderer) {
            int tempSelectionRow = ((KeywordsListCellRenderer)renderer).getTempSelectionRow();
            return tempSelectionRow == row;
        }
        return false;
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        this.selectedFiles.clear();
        this.selectedFiles.addAll(evt.getSelectedFiles());
        this.setKeywords();
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        this.setKeywords();
    }

    private void setKeywords() {
        this.keywordsOfSelectedImages.clear();
        for (File file : this.selectedFiles) {
            this.keywordsOfSelectedImages.addAll(this.repo.findDcSubjectsOfImageFile(file));
        }
        this.repaintLists();
    }

    private void repaintLists() {
        this.repaint(GUI.getSelKeywordsList());
        this.repaint(GUI.getEditKeywordsList());
        this.repaint(GUI.getInputHelperKeywordsList());
    }

    private void repaint(Component component) {
        if (component.isShowing()) {
            component.repaint();
        }
    }
}

