/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.imagecollections;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.swingx.JXList;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.util.ListUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.imagecollections.ImageCollectionsPopupMenu;
import org.jphototagger.program.module.imagecollections.ImageCollectionsUtil;
import org.jphototagger.program.resource.GUI;

public final class RenameImageCollectionController
implements ActionListener,
KeyListener {
    private static final Logger LOGGER = Logger.getLogger(RenameImageCollectionController.class.getName());

    public RenameImageCollectionController() {
        this.listen();
    }

    private void listen() {
        ImageCollectionsPopupMenu.INSTANCE.getItemRename().addActionListener(this);
        GUI.getImageCollectionsList().addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        Object value;
        JXList list = GUI.getImageCollectionsList();
        if (this.isRename(evt) && !list.isSelectionEmpty() && (value = list.getSelectedValue()) instanceof String) {
            this.renameImageCollection((String)value);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.renameImageCollection(ListUtil.getItemString(GUI.getImageCollectionsList(), ImageCollectionsPopupMenu.INSTANCE.getItemIndex()));
    }

    private boolean isRename(KeyEvent evt) {
        return evt.getKeyCode() == 113;
    }

    private void renameImageCollection(final String fromName) {
        if (fromName != null) {
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    String errorMessage = Bundle.getString(RenameImageCollectionController.class, "ListModelImageCollections.Error.RenameSpecialCollection", fromName);
                    if (!ImageCollectionsUtil.checkIsNotSpecialCollection(fromName, errorMessage)) {
                        return;
                    }
                    ImageCollectionsUtil.renameImageCollection(fromName);
                }
            });
        } else {
            LOGGER.log(Level.WARNING, "Rename photo album: Couldn't find the album's name (Item value == null)!");
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }
}

