/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.imagecollections;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.List;
import javax.swing.JMenuItem;
import org.jdesktop.swingx.JXList;
import org.jphototagger.api.messages.MessageType;
import org.jphototagger.api.windows.MainWindowManager;
import org.jphototagger.domain.repository.ImageCollectionsRepository;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.thumbnails.ThumbnailsPanel;
import org.jphototagger.program.module.thumbnails.ThumbnailsPopupMenu;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class PickRejectController
implements ActionListener,
KeyListener {
    private final ImageCollectionsRepository repo = Lookup.getDefault().lookup(ImageCollectionsRepository.class);

    public PickRejectController() {
        this.listen();
    }

    private void listen() {
        GUI.getThumbnailsPanel().addKeyListener(this);
        this.getPickItem().addActionListener(this);
        this.getRejectItem().addActionListener(this);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 80) {
            this.addOrRemove(true);
        } else if (evt.getKeyCode() == 82) {
            this.addOrRemove(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.getPickItem())) {
            this.addOrRemove(true);
        } else if (evt.getSource().equals(this.getRejectItem())) {
            this.addOrRemove(false);
        }
    }

    private void addOrRemove(boolean pick) {
        if (pick && this.isPickCollection() || !pick && this.isRejectCollection()) {
            return;
        }
        ThumbnailsPanel panelThumbnails = GUI.getThumbnailsPanel();
        if (panelThumbnails.isAFileSelected()) {
            List<File> selFiles = panelThumbnails.getSelectedFiles();
            MainWindowManager mainWindowManager = Lookup.getDefault().lookup(MainWindowManager.class);
            mainWindowManager.setMainWindowStatusbarText(this.getPopupMessage(pick), MessageType.INFO, 1000L);
            this.addToCollection(pick ? "SpecialCollectionName.Picked" : "SpecialCollectionName.Rejected", selFiles);
            if (pick && this.isRejectCollection() || !pick && this.isPickCollection()) {
                this.deleteFromCollection(pick ? "SpecialCollectionName.Rejected" : "SpecialCollectionName.Picked", selFiles);
                panelThumbnails.removeFiles(selFiles);
            }
        }
    }

    private String getPopupMessage(boolean pick) {
        return pick ? Bundle.getString(PickRejectController.class, "PickRejectController.Info.Pick", new Object[0]) : Bundle.getString(PickRejectController.class, "PickRejectController.Info.Reject", new Object[0]);
    }

    private boolean isPickCollection() {
        return this.isCollection("SpecialCollectionName.Picked");
    }

    private boolean isRejectCollection() {
        return this.isCollection("SpecialCollectionName.Rejected");
    }

    private boolean isCollection(String collection) {
        if (!GUI.getThumbnailsPanel().getOriginOfDisplayedThumbnails().isFilesOfAnImageCollection()) {
            return false;
        }
        JXList list = GUI.getAppPanel().getListImageCollections();
        if (list.getSelectedIndex() < 0) {
            return false;
        }
        return list.getSelectedValue().toString().equals(collection);
    }

    private void addToCollection(String collection, List<File> files) {
        this.repo.insertImagesIntoImageCollection(collection, files);
    }

    private void deleteFromCollection(String collection, List<File> files) {
        this.repo.deleteImagesFromImageCollection(collection, files);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    private JMenuItem getPickItem() {
        return ThumbnailsPopupMenu.INSTANCE.getItemPick();
    }

    private JMenuItem getRejectItem() {
        return ThumbnailsPopupMenu.INSTANCE.getItemReject();
    }
}

