/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.imagecollections;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.imagecollections.ImageCollection;
import org.jphototagger.domain.repository.ImageCollectionsRepository;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.thumbnails.ThumbnailsPanel;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class ImageCollectionsUtil {
    private static final Logger LOGGER = Logger.getLogger(ImageCollectionsUtil.class.getName());

    public static void deleteSelectedFiles() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                Object selectedValue = ImageCollectionsUtil.getSelectedCollection();
                if (selectedValue != null) {
                    ThumbnailsPanel tnPanel = GUI.getThumbnailsPanel();
                    List<File> selectedFiles = tnPanel.getSelectedFiles();
                    String collectionName = ImageCollection.getLocalizedName(selectedValue.toString());
                    if (ImageCollectionsUtil.deleteImagesFromCollection(collectionName, selectedFiles)) {
                        tnPanel.removeFiles(selectedFiles);
                    }
                } else {
                    LOGGER.log(Level.WARNING, "No Image collection selected!");
                }
            }
        });
    }

    public static Object getSelectedCollection() {
        JXList list = GUI.getAppPanel().getListImageCollections();
        return list.getSelectedValue();
    }

    public static String insertImageCollection(List<File> imageFiles) {
        if (imageFiles == null) {
            throw new NullPointerException("imageFiles == null");
        }
        String name = ImageCollectionsUtil.inputCollectionName("");
        if (name != null && !name.isEmpty()) {
            ImageCollectionsUtil.logAddImageCollection(name);
            ImageCollectionsRepository repo = Lookup.getDefault().lookup(ImageCollectionsRepository.class);
            if (!repo.saveImageCollection(name, imageFiles)) {
                ImageCollectionsUtil.errorMessageAddImageCollection(name);
                return null;
            }
        }
        return name;
    }

    public static boolean deleteImagesFromCollection(String collectionName, List<File> imageFiles) {
        if (collectionName == null) {
            throw new NullPointerException("collectionName == null");
        }
        if (imageFiles == null) {
            throw new NullPointerException("imageFiles == null");
        }
        String message = Bundle.getString(ImageCollectionsUtil.class, "ImageCollectionsHelper.Confirm.DeleteSelectedFiles", collectionName);
        if (ImageCollectionsUtil.confirmDelete(message)) {
            boolean removed;
            ImageCollectionsRepository repo = Lookup.getDefault().lookup(ImageCollectionsRepository.class);
            boolean bl = removed = repo.deleteImagesFromImageCollection(collectionName, imageFiles) == imageFiles.size();
            if (!removed) {
                ImageCollectionsUtil.errorMessageDeleteImagesFromCollection(collectionName);
            }
            return removed;
        }
        return false;
    }

    public static boolean deleteImageCollection(String collectionName) {
        ImageCollectionsRepository repo;
        if (collectionName == null) {
            throw new NullPointerException("collectionName == null");
        }
        boolean deleted = false;
        String message = Bundle.getString(ImageCollectionsUtil.class, "ImageCollectionsHelper.Confirm.DeleteCollection", collectionName);
        if (ImageCollectionsUtil.confirmDelete(message) && !(deleted = (repo = Lookup.getDefault().lookup(ImageCollectionsRepository.class)).deleteImageCollection(collectionName))) {
            ImageCollectionsUtil.errorMessageDeleteImageCollection(collectionName);
        }
        return deleted;
    }

    public static boolean addImagesToCollection(String collectionName, List<File> imageFiles) {
        if (collectionName == null) {
            throw new NullPointerException("collectionName == null");
        }
        if (imageFiles == null) {
            throw new NullPointerException("imageFiles == null");
        }
        ImageCollectionsRepository repo = Lookup.getDefault().lookup(ImageCollectionsRepository.class);
        boolean added = repo.insertImagesIntoImageCollection(collectionName, imageFiles);
        if (!added) {
            ImageCollectionsUtil.errorMessageAddImagesToCollection(collectionName);
        }
        return added;
    }

    public static String renameImageCollection(String fromName) {
        if (fromName == null) {
            throw new NullPointerException("fromName == null");
        }
        String newName = ImageCollectionsUtil.inputCollectionName(fromName);
        if (newName != null && !newName.isEmpty()) {
            boolean renamed;
            ImageCollectionsRepository repo = Lookup.getDefault().lookup(ImageCollectionsRepository.class);
            boolean bl = renamed = repo.updateRenameImageCollection(fromName, newName) > 0;
            if (renamed) {
                return newName;
            }
            ImageCollectionsUtil.errorMessageRenameImageCollection(fromName);
            return null;
        }
        return null;
    }

    public static boolean isValidName(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        return !ImageCollection.isSpecialCollection(name);
    }

    private static boolean checkIsValidName(String name) {
        if (ImageCollectionsUtil.isValidName(name)) {
            return true;
        }
        String message = Bundle.getString(ImageCollectionsUtil.class, "ImageCollectionsHelper.Error.InvalidName", name);
        MessageDisplayer.error(null, message);
        return false;
    }

    private static void logAddImageCollection(String name) {
        LOGGER.log(Level.INFO, "Insert photo album ''{0}'' into the repository", name);
    }

    private static void errorMessageAddImagesToCollection(String collectionName) {
        String message = Bundle.getString(ImageCollectionsUtil.class, "ImageCollectionsHelper.Error.AddImagesToCollection", collectionName);
        MessageDisplayer.error(null, message);
    }

    private static void errorMessageAddImageCollection(String collectionName) {
        String message = Bundle.getString(ImageCollectionsUtil.class, "ImageCollectionsHelper.Error.AddImageCollection", collectionName);
        MessageDisplayer.error(null, message);
    }

    private static void errorMessageDeleteImageCollection(String collectionName) {
        String message = Bundle.getString(ImageCollectionsUtil.class, "ImageCollectionsHelper.Error.DeleteImageCollection", collectionName);
        MessageDisplayer.error(null, message);
    }

    private static void errorMessageDeleteImagesFromCollection(String collectionName) {
        String message = Bundle.getString(ImageCollectionsUtil.class, "ImageCollectionsHelper.Error.DeleteImagesFromCollection", collectionName);
        MessageDisplayer.error(null, message);
    }

    private static void errorMessageRenameImageCollection(String collectionName) {
        String message = Bundle.getString(ImageCollectionsUtil.class, "ImageCollectionsHelper.Error.RenameImageCollection", collectionName);
        MessageDisplayer.error(null, message);
    }

    private static boolean confirmDelete(String message) {
        return MessageDisplayer.confirmYesNo(null, message);
    }

    private static String inputCollectionName(String defaultName) {
        boolean willAdd;
        String name = ImageCollectionsUtil.getCollectionName(defaultName);
        boolean bl = willAdd = name != null;
        while (name != null && willAdd) {
            willAdd = false;
            String nameNextTry = name;
            ImageCollectionsRepository repo = Lookup.getDefault().lookup(ImageCollectionsRepository.class);
            if (repo.existsImageCollection(name) || !ImageCollectionsUtil.checkIsValidName(name)) {
                String message = Bundle.getString(ImageCollectionsUtil.class, "ImageCollectionsHelper.Confirm.InputNewCollectionName", name);
                willAdd = MessageDisplayer.confirmYesNo(null, message);
                name = null;
            }
            if (!willAdd) continue;
            name = ImageCollectionsUtil.getCollectionName(nameNextTry);
        }
        return name;
    }

    private static String getCollectionName(String defaultName) {
        String input;
        String info = Bundle.getString(ImageCollectionsUtil.class, "ImageCollectionsHelper.Input.CollectionName", new Object[0]);
        String name = MessageDisplayer.input(info, input = defaultName);
        if (name != null && (name = name.trim()).isEmpty()) {
            name = null;
        }
        return name;
    }

    public static boolean checkIsNotSpecialCollection(String collectionName, String errorMessage) {
        if (collectionName == null) {
            throw new NullPointerException("collectionName == null");
        }
        if (errorMessage == null) {
            throw new NullPointerException("propertyKey == null");
        }
        if (ImageCollection.isSpecialCollection(collectionName)) {
            MessageDisplayer.warning(null, errorMessage);
            return false;
        }
        return true;
    }

    private ImageCollectionsUtil() {
    }
}

