/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.imagecollections;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.imagecollections.ImageCollection;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.ListUtil;
import org.jphototagger.program.module.imagecollections.ImageCollectionsPopupMenu;

public final class ImageCollectionsMouseListener
extends MouseAdapter {
    private final ImageCollectionsPopupMenu popupMenu = ImageCollectionsPopupMenu.INSTANCE;

    @Override
    public void mousePressed(MouseEvent evt) {
        int index = ListUtil.getItemIndex(evt);
        this.popupMenu.setItemIndex(index);
        if (MouseEventUtil.isPopupTrigger(evt)) {
            JXList list = (JXList)evt.getSource();
            boolean isItem = index >= 0;
            boolean isSpecialCollection = this.isSpecialCollection(list, index);
            this.popupMenu.getItemDelete().setEnabled(isItem && !isSpecialCollection);
            this.popupMenu.getItemRename().setEnabled(isItem && !isSpecialCollection);
            this.popupMenu.show(list, evt.getX(), evt.getY());
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        ((JXList)evt.getSource()).setCursor(Cursor.getDefaultCursor());
    }

    private boolean isSpecialCollection(JXList list, int index) {
        if (index < 0) {
            return false;
        }
        int modelIndex = list.convertIndexToModel(index);
        Object o = list.getModel().getElementAt(modelIndex);
        if (o != null) {
            return ImageCollection.isSpecialCollection(o.toString());
        }
        return false;
    }
}

